
<?
//
// Programmation Web avec PHP, Code X-4: Classe d'envoi d'un EMail par un composant
//
// Cette classe exploite la fonction mail() de PHP.
// Elle implmente les fichiers attachs, les CC, Bcc, et les priorits.
// Auteur: 	Leo West (lwest@free.fr ;-)

class Mail
{
	var $sendto= array();
	var $from;
	var $acc= array();
	var $abcc= array();
	var $aattach= array();
	var $priorities= array( '1 (Highest)', '2 (High)', '3 (Normal)', '4 (Low)', '5 (Lowest)' );

// Constructeur
function Mail($from, $to, $subject= '')
{
	if( is_array($to) ) {
		$this->sendto= $to;
	} else {
		$this->sendto[0]= $to;
	}
	if( ! is_string($from) ) {
		echo "Class Mail: erreur, \"from\" n'est pas une chane!";
		exit;
	}
	$this->from=$from;
	$this->xmailer = "cls_mail";
	if( $subject != '' )
		$this->Subject($subject);
	if( ! $this->CheckAdresses( $this->sendto ) )
		return false;
}
// Positionne les adresses de copies (CC).
// Cette mthode accepte un tableau ou une seule chaine en paramtres
function Cc($cc)
{
	if( is_array($cc) )
		$this->acc= $cc;
	else
		$this->acc[0]= $cc;
	$this->CheckAdresses( $this->acc );
}
// Positionne les adresses en Bcc.
// Cette mthode accepte un tableau ou une seule chaine en paramtres
function Bcc( $bcc)
{
	if( is_array($bcc) )
		$this->abbc= $bcc;
	else
		$this->abcc[0]= $bcc;
	$this->CheckAdresses( $this->abcc );
}
// Affecte le sujet du message
function Subject( $subject )
{
	$this->subject= $subject;
}
// Affecte le corps du message
function Body( $body )
{
	$this->body= $body;
}
// Construit l'en-tte
function _build_headers()
{
	$this->to= implode( ",", $this->sendto);
	$this->cc= implode( ",", $this->acc);
	$this->bcc= implode( ",", $this->abcc);
	$from= $this->from;
	// Cration du header e-mail
	$this->headers= "From: $from\n";
	if( isset($this->organization) )
		$this->headers .= "Organization: $this->organization\n";
	if( $cc != '' )
		$this->headers .= "CC: $this->cc\n";
	if( $this->priority )
		$this->headers .= "X-Priority: $this->priority\n";
	if( $this->xmailer )
		$this->headers .= "X-Mailer: $this->xmailer\n";
}
// Envoi du message
function Send()
{
	// construction de l'en-tte
	$this->_build_headers();
		// inclusion des fichiers attachs
	if( sizeof( $this->aattach > 0 ) ) {
		$this->_build_attachement();
		$this->body= $this->body . $this->attachment;
	}
	// envoi du mail au destinataire principal
	for( $i=0; $i< sizeof($this->sendto); $i++ ) {
		$sendto= $this->sendto[$i];
		mail($sendto, $this->subject, $this->body, $this->headers);
	}
	// envoi du mail aux CC
	for( $i=0; $i< sizeof($this->acc); $i++ ) {
		$sendto= $this->acc[$i];
		mail($sendto, $this->subject, $this->body, $this->headers);
	}
	// envoi du mail aux Bcc
	for( $i=0; $i< sizeof($this->abcc); $i++ ) {
		$sendto= $this->abcc[$i];
		mail($sendto, $this->subject, $this->body, $this->headers);
	}
}
// Affecte le champ "Organization"
function Organization($org )
{
	$this->organization= $org;
}
// Affecte une priorit au message ex: $m->Priority(1) ; => Highest
function Priority($priority )
{
	if( isset( $this->priorities[$priority-1]) ) {
		$this->priority= $this->priorities[$priority-1];
	} else {
			echo "Class Mail, mthode Priority : mauvaise priorit ( $priority ). Les priorits valides sont ( de la plus haute  la plus basse) : 1,2,3,4,5";
			exit;
	}
}
// Attache un fichier au message
function Attach($filename, $filetype="application/x-unknown-content-type")
{
	$sz= sizeof($this->aattach);
	$this->aattach[$sz] = $filename;
	$this->actype[$sz]= $filetype;
}
// Retourne l'e-e mail envoy
function getMail()
{
	if( ! isset( $this->headers ) ) {
		echo "Class Mail, mthode getMail : e-mail mal format. Invoquer la mthode Send() avant getMail()";
		exit;
	}
	return ($this->headers . $this->body);
}
// Renvoie l'e-e mail courant
function Show()
{
	$this->_build_headers();
	if( sizeof( $this->aattach > 0 ) ) {
		$this->_build_attachement();
		$this->body= $this->body . $this->attachment;
	}
	$mail = $this->headers;
	$mail .= "\n$this->body";
	return $mail;
}

// Renvoie true si l'adresse e-mail est valide
function ValidEmail($address)
{
	if (strlen($address)>0) {
 		if(ereg( "^[^@  ]+@([a-zA-Z0-9\-]+\.)+([a-zA-Z0-9\-]{2}|net|com|gov|mil|org|edu|int)\$",$address) ) {
 			return true;
 		}else{
 			return false;
 		}
 	}else{
 		return true;
 	}
}
// Vrification des adresses
function CheckAdresses( $aad )
{
	for($i=0;$i< sizeof( $aad); $i++ ) {
		if( ! $this->ValidEmail( $aad[$i]) ) {
			echo "Class Mail, mthode Mail : adresse invalide $aad[$i]";
			exit;
		}
	}
}
// Vrifie et encode les fichiers attachs
function _build_attachement()
{
	$this->boundary= "------------36B1A07664D99CFE8E10B242";
	$this->headers .= 	"MIME-Version: 1.0\nContent-Type: multipart/mixed;\n
			boundary=\"$this->boundary\"\n\n";
	$this->body= 	"This is a multi-part message in MIME format.\n--$this->boundary\n
               			Content-Type: text/plain; charset=us-ascii\n
               			Content-Transfer-Encoding: 7bit\n\n" . $this->body ."\n";
	$sep= chr(13) . chr(10);
	$ata= array(); $k=0;
	// Pour chaque fichier attach...
	for( $i=0; $i < sizeof( $this->aattach); $i++ ) {
		$filename= $this->aattach[$i];
		// content-type
		$ctype= $this->actype[$i];
		if( ! file_exists( $filename) ) {
			echo "Class Mail, mthode attach : fichier $filename introuvable";
			exit;
		}
		$subhdr= "--$this->boundary\nContent-type: $ctype;\n
		name=\"$filename\"\nContent-Transfer-Encoding:base64\n
		Content-Disposition: inline;;\n  filename=\"$filename\"\n";
		$ata[$k++]= $subhdr;
		$linesz= filesize( $filename)+1;
		$fp= fopen( $filename, 'r' );
		$data= base64_encode(fread( $fp, $linesz));
		$deb=0; $len=72; $data_len= strlen($data);
		do {
			$ata[$k++]= substr($data,$deb,$len);
			$deb += $len;
		} while($deb < $data_len );
		fclose($fp);
	}
	$ata[$k++]= "$this->boundary--";
	$this->attachment= implode($sep, $ata);
}
} // Fin classe Mail
?>
