
<HTML>
<HEAD><TITLE>Programmation Web avec PHP, Code VI-2: Mise en oeuvre d'une classe</TITLE></HEAD>
<BODY>
<H1>Exemple d'utilisation des classes</H1>
<?

//
// Dclaration et dfinition des Classes
//

// Dclaration des proprits de la classe " vehicule " et de ses valeurs par dfaut

class vehicule
{
	var $puissance = 100;
	var $couleur = "blanc";
	var $moteur = "arrete";

	// implmentation des mthodes agissant sur tous les types de vhicules
	function demarrer() {
		$this->moteur = "en marche";
	}

	function arreter() {
		$this->moteur = "arrt";
	}

	function assigner_puissance($p) {
		$this->puissance = $p;
	}

	function peindre($coul) {
		$this->couleur = $coul;
	}

	function etat() {
		echo "couleur : $this->couleur<br>";
		echo "moteur de $this->puissance chevaux $this->moteur<br>";
	}
}

// Nous ajoutons ici une proprit, une mthode
// permettant de grer cette proprit, et une mthode
// d'affichage propre aux voitures portant le mme nom que la
// mthode d'affichage de la classe mre.

class voiture extends vehicule
{
	var $nb_porte = 4;

	function assigner_portes($p) {
		$this->nb_porte = $p;
	}

	function etat() {
		echo "Voiture $this->nb_porte portes <br>";
		echo "couleur : $this->couleur<br>";
		echo "moteur de $this->puissance chevaux $this->moteur<br>";
	}
}

// De mme, quelques ajouts que pour la classe camion

class camion extends vehicule
{
	var $poids = 15;

	function assigner_poids($p) {
		$this->poids = $p;
	}

	function etat() {
		echo "Camion de $this->poids tonnes <br>";
		echo "couleur : $this->couleur<br>";
		echo "moteur de $this->puissance chevaux $this->moteur<br>";
	}
}

// Illustration du polymorphisme :
// Cration d'une fonction d'affichage valable pour les voitures et les camions.

function affichage($objet) {

	// le principe de cette fonction est de pouvoir lui passer en paramtre
	// n'importe quel objet implmentant une mthode " etat ".
	// Il n'est pas ncessaire de connatre la nature de l'objet (voiture,
	// camion, etc.,...). C'est le polymorphisme.

	$objet->etat();
}

//
// Utilisation des Classes
//

// Instanciation de la classe voiture et affectation des proprits de cette voiture.
$v = new voiture;
$v->peindre("rouge");
$v->assigner_portes(2);

// Mme opration avec la classe camion.
$c = new camion;
$c->assigner_poids(38);
$c->assigner_puissance(250);
$c->demarrer();

// Affichage de l'tat de chacun des objets " voiture " et " camion " par
// l'intermdiaire de la mme fonction " affichage ".
affichage($v);
echo "<br><br>";
affichage($c);
?>
<BR><HR><P><A href="menu.php3">Retourner au menu principal</A></P>
</BODY>
</HTML>
