
<HTML>
<HEAD><TITLE>Programmation Web avec PHP, Code X-7: Gnration d'une image</TITLE></HEAD>
<BODY>
<H1>Exemple de gnration d'une image GIF</H1>
<?

// On monte en mmoire la bibliothque " php3_gd.dll " (ici sous Wwindows)
dl( "php3_gd.dll" );

// Cration d'une fonction permettant de dessiner une portion de camembert
function portion($xc,$yc,$diametre,$epaisseur,$dep,$couleur,$image,$caption)
{
	// Dfinition de la couleur blanche sur l'image en cours de construction
	$blanc = ImageColorAllocate($image, 255,255,255);
	for ($i=$diametre;$i>=0;$i--) {
		// on utilise la fonction imagearc qui fait partie de la
		// bibliothque graphique et qui tracer des arcs d'ellipse.
		imagearc($image,$xc,$yc,$i,$i,$dep,$dep+$epaisseur,$couleur);
	}
	// Dtermination des coordonnes d'affichage de la lgende
	$alpha = ($dep + ($epaisseur/2)) * ((2*M_PI)/360);
	$cs = 95 * cos($alpha);
	$sn = 95 * sin($alpha);
	$xt = $xc + $cs;
	$yt = $yc + $sn;
	// Affichage de la lgende
	imagestring($image, 2, $xt, $yt, $caption, $blanc);
}

// Fonction qui construit le camembert  partir du tableau de valeurs
function pie_chart($tabval)
{
	// cration de l'image gif d'une taille de 200 x 200 pixels.
	$img = imageCreate(300,300);
	// remplissage de l'image avec d'un fond noir
	$noir = ImageColorAllocate($img, 0, 0, 0);
	imagefill($img, 0, 0, $noir);
	// calcul du total des valeurs
	$total = 0;
	for($i=0;$i<sizeof($tabval);$i++) {
		$total = $total + $tabval[$i];
	}
	$unite = 360/$total;
	$begin = 0;
	// dessin des portions
	for($i=0;$i<sizeof($tabval);$i++) {
		// cration d'une couleur alatoire pour la portion courante
		srand((double)microtime()*1000000);
		$coul = ImageColorAllocate($img,
				rand(0,255),rand(0,255),rand(0,255));
		$part = $tabval[$i]*$unite;
		portion(150, 150, 150, $part, $begin, $coul, $img, $tabval[$i]);
		$begin = $begin + $part;
	}
	// Gnration d'un fichier GIF contenant le rsultat.
	// Remarque : le paramtre qui fournitdonnant le nom du fichier tant optionnel,
	// on aurait tout aussi bien pu gnrer l'image dans le flux HTTP
    	// retourn au navigateur client, et ainsi l'afficher directement
	imagegif($img,"imagephp.gif");
}

// Programme principal - Cration du tableau de donnes
$tb = array(22,50,180,150,80,250,30,100);

// Appel de la fonction de cration du camembert
pie_chart($tb);
?>
<BR><HR><P><A href="menu.php3">Retourner au menu principal</A>&nbsp;&nbsp;<A href="buildgif.php3.txt">Voir le source</A></P>
</BODY>
</HTML>
