<?
/*
** FileName : Common.Inc
** Description : Scripts communs des fonctions de gestion des pages PHP
**
** Contents : 
**
** 	SList( $Prefix, $Arr_Row, $Suffix )
** 	SListEx( $Before, $Prefix, $Arr_Row, $Suffix, $After )
** 	DList( $Prefix, $Arr_Row, $Middle, $Suffix )
** 	DListEx( $Before, $Prefix, $Arr_Row, $Middle, $Suffix, $After )
** 	ColSplit( $Sep, $Arr_Row, $Col )
** 	Echo_Common_Header( $Style, $Fond, $WinTitle )
** 	Echo_LogoToMenuV_Cell( $Style, $Logo )
** 	Echo_MenuVToMenuH_Cell( $Style )
** 	Echo_MenuHToPath_Cell( $Style, $Title )
** 	Echo_PathToData_Cell( $Style )
** 	Echo_DataToFoot_Cell( $Style )
** 	Echo_Common_Footer( $Style, $FootLine )
** 	Sql_GetTabInf( $TablePrefix, $Plage )
** 	Sql_GetColInf( $TableName, $ColumnPrefix, $Plage )
**
*/

function SList( $Prefix, $Arr_Row, $Suffix )
{
	$Str = "";
	if( isset( $Arr_Row ) && count( $Arr_Row ) > 0 ) 
	{
		while( list( $key, $val ) = each( $Arr_Row ) ) 
		{
			$Str = $Str . $Prefix . $val . $Suffix;
		}
	}
	else
	{
		$Str = "NO ITEMS IN Arr_Row, function SList";
	}
	return $Str;
}

function SListEx( $Before, $Prefix, $Arr_Row, $Suffix, $After )
{
	return ( $Before . SList( $Prefix, $Arr_Row, $Suffix ) . $After );
}

function DList( $Prefix, $Arr_Row, $Middle, $Suffix )
{
	$Str = "";
	if( isset( $Arr_Row ) && count( $Arr_Row ) > 0 ) 
	{
		while( list( $key, $val ) = each( $Arr_Row ) ) 
		{
			$Str = $Str . $Prefix . $val . $Middle . $val . $Suffix;
		}
	}
	return $Str;
}

function DListEx( $Before, $Prefix, $Arr_Row, $Middle, $Suffix, $After )
{
	return ( $Before . DList( $Prefix, $Arr_Row, $Middle, $Suffix ) . $After );
}

function ColSplit( $Sep, $Arr_Row, $Col )
{
	$arr_res = array();
	$nb_rows = 0;
	while( list( $k, $v ) = each( $Arr_Row ) )
	{
		$arr_str = Split( $Sep, $v );
		$arr_res[$nb_rows++]  = $arr_str[$Col];
	}
	return $arr_res;
}

# Affichage de l'en tete de page commun
function Echo_Common_Header( $Style, $Fond, $WinTitle )
{
	if( $Style == 1 )
	{
		echo( "<HTML>\n" );
		echo( "<!-- En tte de page commun style ".$Style."--!>\n" );
		echo( "<HEAD><TITLE>".$WinTitle."</TITLE></HEAD>\n" );
		echo( "<BODY background=\"".$Fond."\">\n" );
		echo( "<!-- Table principale compose de 3 bandeaux verticaux --!>\n" );
		echo( "<TABLE border=0 width=\"100%\" cellspacing=0 cellpadding=0>\n" );
		echo( "  <TR>\n" );
		echo( "    <TD width=\"1%\" height=\"100%\" valign=\"TOP\" >&nbsp;</TD>\n" );
	}
	else
	{
		echo( "<HTML>\n" );
		echo( "<!-- En tte de page commun standard --!>\n" );
		echo( "<HEAD><TITLE>".$SCRIPT_PARAM."</TITLE></HEAD>\n" );
		echo( "<BODY background=\"".$Fond."\">\n" );
		echo( "<P>\n" );
		echo( "<!-- Dbut de page --!>\n" );
	}
}

# Affichage de la cellule du logo
function Echo_LogoToMenuV_Cell( $Style, $Logo )
{
	if( $Style == 1 )
	{
		echo( "    <TD width=\"22%\" height=\"100%\" valign=\"TOP\" >\n" );
		echo( "      <TABLE border=0 width=\"100%\" cellspacing=2 cellpadding=2>\n" );
		echo( "        <TR>\n" );
		echo( "          <!-- Logo, en haut  gauche --!>\n" );
		echo( "          <TD align=\"CENTER\"><A href=\"Accueil.Php3\"><IMG border=0 src=\"".$Logo."\"></IMG></A></TD>\n" );
		echo( "        </TR>\n" );
		echo( "        <TR>\n" );
		echo( "          <TD align=\"CENTER\" valign=\"TOP\"><BR>\n" );
		echo( "            <!-- Menu vertical gauche --!>\n" );
	}
}

# Affichage de la fin du menu droit jusqu'au dbut du menu haut
function Echo_MenuVToMenuH_Cell( $Style )
{
	if( $Style == 1 )
	{
		echo( "          </TD>\n" );
		echo( "        </TR>\n" );
		echo( "      </TABLE>\n" );
		echo( "    </TD>\n" );
		echo( "    <TD height=\"100%\" valign=\"TOP\">\n" );
		echo( "      <TABLE border=0 width=\"100%\" cellspacing=2 cellpadding=2>\n" );
		echo( "        <TR>\n" );
		echo( "          <TD>\n" );
		echo( "            <TABLE border=0 width=\"100%\" cellspacing=2 cellpadding=2>\n" );
		echo( "              <TR><TD bgcolor=\"#222222\">\n" );
		echo( "                <!-- Menu horizontal haut --!>\n" );
	}
}

# Affichage de la fin du menu haut jusqu'au dbut du path
function Echo_MenuHToPath_Cell( $Style, $Title )
{
	if( $Style == 1 )
	{
		echo( "              </TD></TR>\n" );
		echo( "              <TR><TD><BIG><BIG><BIG><BIG><B>".$Title."</B></BIG></BIG></BIG></BIG></TD></TR>\n" );
		echo( "              <TR><TD><SMALL>\n" );
		echo( "                <!-- Liens du chemin d'accs --!>\n" );
	}
	else
	{
		echo( "<BIG><BIG><BIG><BIG><B>".$Title."</B></BIG></BIG></BIG></BIG><P>\n" );
	}
}

# Affichage de la fin du path au dbut de la partie variable
function Echo_PathToData_Cell( $Style )
{
	if( $Style == 1 )
	{
		echo( "              </SMALL></TD></TR>\n" );
		echo( "            </TABLE>\n" );
		echo( "          </TD>\n" );
		echo( "        </TR>\n" );
		echo( "        <TR>\n" );
		echo( "          <TD>\n" );
		echo( "            <!-- Partie variable de la page --!>\n" );
	}
}

# Affichage de la fin du path au dbut de la partie variable
function Echo_DataToFoot_Cell( $Style )
{
	if( $Style == 1 )
	{
		echo( "          </TD>\n" );
		echo( "        </TR>\n" );
		echo( "      </TABLE>\n" );
		echo( "    </TD>\n" );
	}
}

# Affichage du pied de page commun
function Echo_Common_Footer( $Style, $FootLine )
{
	if( $Style == 1 )
	{
		echo( "  </TR>\n" );
		echo( "</TABLE><P><HR>\n" );
		echo( "<!-- Pied de page commun style ".$Style."--!>\n" );
		echo( "<TABLE border=0 width=\"100%\" cellspacing=1 cellpadding=1>\n" );
		echo( "  <TR>\n" );
# Texte du pied de page pass en paramtre
		echo( "    <TD width=\"90%\" align=\"LEFT\">&nbsp;".$FootLine."</TD>\n" );
# Lien vers le haut de la page
		echo( "    <TD width=\"10%\" align=\"RIGHT\"><A href=\"#Top\">Top</A>&nbsp;</TD>\n" );
		echo( "  </TR>\n" );
		echo( "</TABLE>\n" );
		echo( "</BODY>\n" );
		echo( "</HTML>\n" );
	}
	else
	{
		echo( "<P><HR>".$FootLine."\n" );
		echo( "</BODY>\n" );
		echo( "</HTML>\n" );
	}

}

# Rcupre la valeur d'un paramtre d'URL, en extrayant les caractres compris entre Col= et & (ou la fin de la chaine)
function Param_GetVal( $Prm_Str, $Col_Nam )
{
	if ( ( $prm_val = strstr( $Prm_Str, $Col_Nam."=" ) ) )
	{
		if ( strpos( $prm_val, "&" ) > 0 ) {
			$val_str = substr( $prm_val, 0, strpos( $prm_val, "&" ) );
			$val_str = urldecode( substr( $val_str, strpos( $val_str, "=" ) + 1 ) );
		} else {
			$val_str = urldecode( substr( $prm_val, strpos( $prm_val, "=" ) + 1 ) );
		}
	}
	return $val_str;
}

# Rcupre les lignes d'informations d'une ou plusieurs tables
# typvin~type de vin~ref~typ~m~le~2~types de vins~
function Sql_GetTabInf( $TablePrefix, $Plage )
{
	# Variable de retour et traitement paramtres
	$arr_sql = array( );
	if ( IsSet( $TablePrefix ) ) $TablePrefix = StrToUpper( $TablePrefix );
	if ( IsSet( $Plage ) ) $Plage = ( $Plage == "" ? "ALL" : StrToUpper( $Plage ) ); else $Plage = "ALL";
	if ( $Plage != "ALL" && $Plage != "OBJ" && $Plage != "LNK" && $Plage != "REF" && $Plage != "OTH" && $Plage != "" ) return $arr_sql;

	# Parcourir fichier des tables
	if( ! ( $arr_file = File( "TABLES.TXT" ) ) ) return $arr_sql;
	$num_tab = 0;
	while ( count( $arr_file ) > 0 && list( $key, $str ) = each( $arr_file ) )
	{
		# Eviter lignes en commentaires
		if ( $str != "" && substr( $str[0], 1, 1 ) != ";" )
		{
			# Dcouper les champs de la table
			$arr_str = split( "~", StrToUpper( $str ), 16 );
			# Stocker les infos de la table si dans plage
			if ( $Plage == "" || $Plage =="ALL" || $Plage == $arr_str[2] )
			{
				if ( $TablePrefix == "" || strstr( $arr_str[0], $TablePrefix ) != false )
				{
					$arr_sql[$num_tab++] = $str;
				}
			}
			unset( $arr_str );
		}
	}
	unset( $arr_file );
	return $arr_sql;
}

# Rcupre les lignes d'informations d'une ou plusieurs colonnes
# typvin~cod_typvin~code~A~8~Y~N~N~EFT
function Sql_GetColInf( $TableName, $ColumnPrefix, $Plage )
{
	# Variable de retour et traitement paramtres
	$arr_sql = array( );
	if ( IsSet( $TableName ) ) $TableName = StrToUpper( $TableName ); else return $arr_sql;
	if ( IsSet( $ColumnPrefix ) ) $ColumnPrefix = StrToUpper( $ColumnPrefix ); else $ColumnPrefix = "";
	if ( IsSet( $Plage ) ) $Plage = ( $Plage == "" ? "ALL" : StrToUpper( $Plage ) ); else $Plage = "ALL";
	if ( $Plage != "ALL" && $Plage != "KEY" && $Plage != "NOTKEY" && $Plage != "NULL" && $Plage != "NOTNULL" && $Plage != "NULLBUTKEY" && $Plage != "NOTNULLBUTKEY" && $Plage != "FORKEY" && $Plage != "NOTFORKEY" && $Plage != "IDENT" && $Plage != "NOTIDENT" ) return $arr_sql;

	# Parcourir le fichier des colonnes
	if( ! ( $arr_file = File( "COLUMNS.TXT" ) ) ) return $arr_sql;
	$num_col = 0;
	$tab_fnd = false;
	while ( count( $arr_file ) > 0 && list( $key, $str ) = each( $arr_file ) )
	{
		# Eviter lignes en commentaires
		if ( $str != "" && substr( $str[0], 1, 1 ) != ";" )
		{
			# Dcouper les champs de la colonne
			$arr_str = split( "~", StrToUpper( $str ), 16 );
			$tab_name = $arr_str[0];
			$col_name = $arr_str[1];
			# Vrification du nom de la table
			if ( strtoupper( $tab_name ) == $TableName )
			{
				$tab_fnd = true;
				# Vrification du prfixe de la colonne
				if ( $ColumnPrefix == "" || strstr( $col_name, $ColumnPrefix ) != false )
				{
					$col_key = ( strtoupper( $arr_str[5] ) == "Y" ) ? "Y" : "N";
					$col_null = ( strtoupper( $arr_str[7] ) == "Y" ) ? "Y" : "N";
					$col_ident = ( strtoupper( $arr_str[6] ) == "Y" ) ? "Y" : "N";
					$col_forkey = ( strtoupper( $arr_str[8] ) == "Y" ) ? "Y" : "N";
					# Vrification de la plage
					if ( ( $Plage =="ALL" )
					||  ( $Plage == "KEY" && $col_key == "Y" ) 
					||  ( $Plage == "NOTKEY" && $col_key == "N" ) 
					||  ( $Plage == "NULL" && $col_null == "Y" ) 
					||  ( $Plage == "NOTNULL" && $col_null == "N" ) 
					||  ( $Plage == "NULLBUTKEY" && $col_null == "Y" && $col_key == "N" ) 
					||  ( $Plage == "NOTNULLBUTKEY" && $col_null == "N" && $col_key == "N" ) 
					||  ( $Plage == "FORKEY" && $col_forkey == "Y" ) 
					||  ( $Plage == "NOTFORKEY" && $col_forkey == "N" ) 
					||  ( $Plage == "IDENT" && $col_ident == "Y" ) 
					||  ( $Plage == "NOTIDENT" && $col_ident == "N" ) )
					{
						$arr_sql[$num_col++] = $str;
					}
				}
			} elseif ( $tab_fnd == true ) break;
			unset( $arr_str );
		}
	}
	unset( $arr_file );
	return $arr_sql;
}
?>
