<?
/*
** FileName : Sql_Odbc.Inc
** Description : Scripts communs de gestion des ordres SQL avec ODBC
**
** Contents : 
**
** 	Exec_SqlSelectOne ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
** 	Param_GetVal( $Prm_Str, $Col_Nam )
** 	Build_SQLForm( $Arr_Col, $Prm_Str, $Action )
** 	Build_SQLListKeyItem( $Arr_Col, $bas_url )
** 	Build_SQLListNotKeyItem( $Arr_Col )
** 	Build_SQLListHeader( $Arr_Col )
** 	Build_SQLInsCmd ( $Tab_Name, $Prm_Str, $Arr_Cols )
** 	Build_SQLUpdCmd ( $Tab_Name, $Prm_Str, $Arr_Cols  )
** 	Build_SQLDelCmd ( $Tab_Name, $Prm_Str, $Arr_Cols  )
** 	Echo_OneColSqlRes ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
** 	Exec_SqlProc ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
**
*/

# Excution d'une requte SQL Select d'une ligne dans une base de donnes
function Exec_SqlSelectOne ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
{
	$sql_cnx = false;
	$sql_res = false;

	# Connexion ODBC
	$sql_cnx = odbc_connect( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd );

	# Connexion rate
	if ( $sql_cnx == false )
	{
		$sql_res = "<B>Erreur de connexion  Oracle ODBC.</B>\n";
	} else {
		# Connexion russie -> Excution commande SQL
		$sql_id = odbc_exec( $sql_cnx, $SQLString );
		# Excution rate
		if ( $sql_id == false ) 
		{
			$sql_res = "Connexion OK mais erreur d'execution de la commande SQL : <P>$SQLString<P>\n";
		} else {
			$arr_res = array();
			# Excution russie -> Si au moins une ligne, afficher tout
			if ( odbc_fetch_into( $sql_id, 1, &$arr_res ) )
			{
				$sql_res = "";
				while( list( $k, $v ) = each( $arr_res ) )
				{
					$col_name = StrToLower( odbc_field_name( $sql_id, $k+1 ) );
					$sql_res .= "&$col_name=$v";
				}
			}
			# Excution russie mais aucune ligne ramene
			else
			{
				$sql_res = "Connexion OK, excution SQL OK, mais aucune ligne n'a t renvoye.\n";
			}
		}
		# Dconnexion ODBC
 		odbc_close( $sql_cnx );
	}
	return $sql_res;
}

# Construction d'un formulaire de saisie des informations d'une table
# Rsultat compos de pls lignes :   <TR><TD>Code&nbsp;:&nbsp;</TD><TD><INPUT type="TEXT" name="cod_cli" value="Cli001"></TD></TR>
function Build_SQLForm( $Arr_Col, $Prm_Str, $Action, $RowPrefix )
{
	$sql_str = "";
	$sql_keystr = "";
	$sql_notkeystr = "";
	reset( $Arr_Col );
	while ( ( count ( $Arr_Col ) > 0 ) && ( list( $key, $val ) = each( $Arr_Col ) ) )
	{
		$arr_str = split( "~", $val, 16 );
		$col_nam = $arr_str[1];
		$prm_val = Param_GetVal( $Prm_Str, $arr_str[1] );
		$width = Max( 6, Min( intval( $arr_str[4] ), 80 ) );
		# Colonnes cl
		if ( StrToUpper( $arr_str[5] ) == "Y" ) {
			if ( $Action == "Ins" && StrToUpper( $arr_str[6] ) != "Y" ) {
				$sql_keystr .= "$RowPrefix<TR><TD width=\"20%\">".ucfirst( $arr_str[2] )."&nbsp;:&nbsp;</TD>";
				$sql_keystr .= "<TD><INPUT type=\"TEXT\" maxlength=$arr_str[4] size=$width name=\"$arr_str[1]\"></TD></TR>\n";
			} elseif ( $Action == "Upd" ) {
				$sql_keystr .= "$RowPrefix<TR><TD width=\"20%\">".ucfirst( $arr_str[2] )."&nbsp;:&nbsp;</TD>";
				$sql_keystr .= "<TD><B>$prm_val</B>&nbsp;<INPUT type=\"HIDDEN\" name=\"$arr_str[1]\" value=\"$prm_val\"></TD></TR>\n";
			} elseif ( $Action == "Del" ) {
				$sql_keystr .= "$RowPrefix<TR><TD width=\"20%\">".ucfirst( $arr_str[2] )."&nbsp;:&nbsp;</TD>";
				$sql_keystr .= "<TD><B>$prm_val</B>&nbsp;<INPUT type=\"HIDDEN\" name=\"arr_str[1]\" value=\"$prm_val\"></TD></TR>\n";
			}
		# Autres colonnes (non cl)
		} else {
			if ( $Action == "Ins" ) {
			     	$sql_notkeystr .= "$RowPrefix<TR><TD width=\"20%\">" .ucfirst( $arr_str[2] )."&nbsp;:&nbsp;</TD>";
			     	$sql_notkeystr .= "<TD><INPUT type=\"TEXT\" maxlength=$arr_str[4] size=$width name=\"$arr_str[1]\"></TD></TR>\n";
			} elseif ( $Action == "Upd" ) {
			     	$sql_notkeystr .= "$RowPrefix<TR><TD width=\"20%\">" .ucfirst( $arr_str[2] )."&nbsp;:&nbsp;</TD>";
			     	$sql_notkeystr .= "<TD><INPUT type=\"TEXT\" maxlength=$arr_str[4] size=$width name=\"$arr_str[1]\" value=\"$prm_val\"></TD></TR>\n";
			} elseif ( $Action == "Del" ) {
			     	# En suppression, affichage de la cl uniquement
			}
		}
	}
	return $sql_keystr.$sql_notkeystr;
}

function Build_SQLListKeyItem( $Arr_Col, $bas_url )
{
	$sql_str = "";
	$key_str = "";
	$mor_str = "";
	reset( $Arr_Col );
	while ( ( count ( $Arr_Col ) > 0 ) && ( list( $key, $val ) = each( $Arr_Col ) ) )
	{
		$arr_str = split( "~", $val, 16 );
		if ( StrToUpper( $arr_str[5] ) == "Y" )
		{
			$key_str .= "'";
			if ( $key_str != "'" ) $key_str .= "&";
			$key_str = $key_str . $arr_str[1] . "=' || " . $arr_str[1];
			if ( $mor_str != "" ) {
				$first = true;
				$mor_str .= " || '<TD>'"; 
			} else {
				$first = false;
			}
			$mor_str .= $arr_str[1];
			if ( $first = true ) $mor_str .= " || '</A>'";
			$mor_str .= " || '</TD>'";
		}
	}
	if ( $bas_url != "" ) 
	{
		$sql_str = "'<TD><A href=\"$bas_url&' || $key_str || '\">' || " . $mor_str;
	} else {
		$sql_str = "' || $key_str || '";
	}
	return $sql_str;
}

function Build_SQLListNotKeyItem( $Arr_Col )
{
	$sql_str = "";
	reset( $Arr_Col );
	while ( ( count ( $Arr_Col ) > 0 ) && ( list( $key, $val ) = each( $Arr_Col ) ) )
	{
		$arr_str = split( "~", $val, 16 );
		if ( StrToUpper( $arr_str[5] ) == "N" )
		{
			$sql_str = $sql_str . "'<TD>' || " . $arr_str[1] . " || '</TD>'";
		}
	}
	return $sql_str;
}

# Construit l'en tte de liste pour une table (concatnation de TD formatts par colonne)
function Build_SQLListHeader( $Arr_Col )
{
	$sql_str = "";
	reset( $Arr_Col );
	while ( ( count ( $Arr_Col ) > 0 ) && ( list( $key, $val ) = each( $Arr_Col ) ) )
	{
		$arr_str = split( "~", $val, 16 );
		$sql_str .= "<TD><B>".ucfirst( $arr_str[2] )."</B></TD>";
	}
	return $sql_str;
}

# Construit une requte dynamique d'insertion dans une table
function Build_SQLInsCmd ( $Tab_Name, $Prm_Str, $Arr_Cols )
{
	if ( ( ! isset( $Tab_Name ) ) || ( ! isset( $Prm_Str ) ) ) return false;

	# Crer un tableau des colonnes de la table
	if ( ! isset( $Arr_Cols ) ) $Arr_Cols = Sql_GetColInf( $Tab_Name, "", "ALL" );
	if ( ! isset( $Arr_Cols ) || count( $Arr_Cols ) <= 0 ) return false;

	$sql_string = "Insert Into $Tab_Name ( ";
	$value_string = "";
	$one_done = false;
	while( list( $k, $v ) = each( $Arr_Cols ) ) 
	{
		# Dcoupage informations colonne courante
		$a_col = Split( "~", $v, 8 );
		# Si ce n'est pas une colonne identity
		if ( $a_col[6] != "Y" )
		{
			# Chercher si la valeur de la colonne est renseigne dans la chaine des paramtres
			$col_name = $a_col[1];
#			if( isset( $$col_name ) )
			if ( ( $prm_val = strstr( $Prm_Str, $col_name."=" ) ) ) 
			{
				# Ajouter une virgule entre colonnes et entre valeurs (si dj une colonne trouve !)
				if ( $one_done == true ) { 
					$sql_string .= ", ";
					$value_string .= ", "; 
				} else { 
					$one_done = true; 		# Premire colonne trouve
				}
				$sql_string .= $col_name;
				# Rcupre la valeur du paramtre dans l'url
#				$val_str = $$col_name;
				$val_str = Param_GetVal( $Prm_Str, $col_name );
				# Suivant le type de donnes
				if ( $a_col[3] == "date" ) {
					$val_str = "To_Date( '$val_str', 'DD/MM/YYYY' )";
				} elseif ( $a_col[3] == "char" ) {
					$val_str = "'$val_str'";
				}
				$value_string .= $val_str;
			}
		}
	 }
	$sql_string .= " ) Values ( ";
	$sql_string .= $value_string;
	$sql_string .= " )";

	return $sql_string;
}

# Construit une requte dynamique de mise  jour dans une table
function Build_SQLUpdCmd ( $Tab_Name, $Prm_Str, $Arr_Cols )
{
	if ( ( ! isset( $Tab_Name ) ) || ( ! isset( $Prm_Str ) ) ) return false;

	# Crer un tableau des colonnes de la table
	if ( ! isset( $Arr_Cols ) ) $Arr_Cols = Sql_GetColInf( $Tab_Name, "", "ALL" );
	if ( ! isset( $Arr_Cols ) || count( $Arr_Cols ) <= 0 ) return false;

	$sql_string = "Update $Tab_Name Set ";
	$whr_str = " Where ";
	$one_done = false;
	$one_done_whr = false;
	while( list( $k, $v ) = each( $Arr_Cols ) ) 
	{
		# Dcoupage informations colonne courante
		$a_col = Split( "~", $v, 8 );
		# Chercher si la valeur de la colonne est renseigne dans la chaine des paramtres
		$col_name = $a_col[1];
#		if( isset( $$col_name ) )
		if ( ( $prm_val = strstr( $Prm_Str, $a_col[1]."=" ) ) ) 
		{
			# Rcupre la valeur du paramtre dans l'url
# 			$val_str = $$col_name;
			$val_str = Param_GetVal( $Prm_Str, $col_name );
			# Suivant le type de donnes
			if ( $a_col[3] == "date" ) {
				$val_str = "To_Date( '$val_str', 'DD/MM/YYYY' )";
			} elseif ( $a_col[3] == "char" ) {
				$val_str = "'$val_str'";
			}
			# Si ce n'est pas une colonne cl, remplir section set
			if ( $a_col[5] == "N" ) 
			{
				if ( $one_done == true ) { $sql_string .= ", "; } else { $one_done = true; }
				$sql_string .= "$col_name = $val_str";
			# Si colonne cl, remplir section where
			} else {
				if ( $one_done_whr == true ) { $whr_str .= " And "; } else { $one_done_whr = true; }
				$whr_str .= "$col_name = $val_str";
			}
		}
	 }
	$sql_string .= $whr_str;

	return $sql_string;
}

# Construit une requte dynamique de suppression dans une table
function Build_SQLDelCmd ( $Tab_Name, $Prm_Str, $Arr_Cols )
{
	if ( ( ! isset( $Tab_Name ) ) || ( ! isset( $Prm_Str ) ) ) return false;

	# Crer un tableau des colonnes de la table
	if ( ! isset( $Arr_Cols ) ) $Arr_Cols = Sql_GetColInf( $Tab_Name, "", "KEY" );
	if ( ! isset( $Arr_Cols ) || count( $Arr_Cols ) <= 0 ) return false;

	$sql_string = "Delete From $Tab_Name ";
	$whr_str = " Where ";
	$one_done_whr = false;
	while( list( $k, $v ) = each( $Arr_Cols ) ) 
	{
		# Dcoupage informations colonne courante
		$a_col = Split( "~", $v, 8 );
		if ( StrToUpper( $a_col[5] ) != "Y" ) continue;
		# Chercher si la valeur de la colonne est renseigne dans la chaine des paramtres
		$col_name = $a_col[1];
#		if( isset( $$col_name ) )
		if ( ( $prm_val = strstr( $Prm_Str, $a_col[1]."=" ) ) ) 
		{
			# Rcupre la valeur du paramtre dans l'url
#			$val_str = $$col_name;
			$val_str = Param_GetVal( $Prm_Str, $col_name );
			# Suivant le type de donnes
			if ( $a_col[3] == "date" ) {
				$val_str = "To_Date( '$val_str', 'DD/MM/YYYY' )";
			} elseif ( $a_col[3] == "char" ) {
				$val_str = "'$val_str'";
			}
			if ( $one_done_whr == true ) { $whr_str .= " And "; } else { $one_done_whr = true; }
			$whr_str .= "$col_name = $val_str";
		}
	 }
	$sql_string .= $whr_str;

	return $sql_string;
}

# Excution d'une requte SQL de base de donnes 
function Echo_OneColSqlRes ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString, $RowPrefix )
{
	$sql_cnx = false;
	$sql_res = false;

	# Connexion ODBC
	$sql_cnx = odbc_connect( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd );

	# Connexion rate
	if ( $sql_cnx == false )
	{
		echo( "<B>Erreur de connexion  Oracle ODBC.</B>\n" );
	} else {
		# Connexion russie -> Excution commande SQL
		$sql_res = odbc_exec( $sql_cnx, $SQLString );

		# Excution rate
		if ( $sql_res == false )
		{
			echo( "Connexion OK mais erreur d'execution de la commande SQL : <P>".$SQLString."<P>\n" );
		} else {
			# Excution russie -> Si au moins une ligne, afficher tout
			if ( odbc_fetch_row( $sql_res, 1 ) == true ) 
			{ 
				# Attention ; rptition
				echo( $RowPrefix .odbc_result( $sql_res, 1 ) . "\n" );
				while( odbc_fetch_row( $sql_res ) ) 
					echo( $RowPrefix . odbc_result( $sql_res, 1 ) . "\n" );
			}
			# Excution russie mais aucune ligne ramene
			else
			{ 
				echo( "Connexion OK, excution SQL OK, mais aucune ligne n'a t renvoye.\n" );
			}
		}
		# Dconnexion ODBC
 		odbc_close( $sql_cnx );
	}
}

# Excution d'une requte SQL de base de donnes
function Exec_SqlProc ( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd, $SQLString )
{
	$sql_cnx = false;
	$sql_res = false;

	# Connexion ODBC
	$sql_cnx = odbc_connect( $SQL_CnxDsn, $SQL_CnxUsr, $SQL_CnxPwd );
	# Connexion rate
	if ( $sql_cnx == false )
	{
		echo( "<B>Erreur de connexion  Oracle ODBC.</B>\n" );
		return false;
	} else {
		# Connexion russie -> Excution commande SQL
		$sql_res = odbc_exec( $sql_cnx, $SQLString );

		# Dconnexion ODBC
 		odbc_close( $sql_cnx );

		# Excution rate
		if ( $sql_res == false )
		{
			echo( "Connexion OK mais erreur d'execution de la commande SQL : <P>".$SQLString."<P>\n" );
			return false;
		}
	}
	return true;
}

?>