<?
#
# Constantes propres  la gestion des mots-cls (paramtres)
#
define( "LANG_INS_START", "{" );
define( "LANG_INS_END", "}" );
define( "LANG_KEY_START", "KEY_" );
#
# Constantes propres  la gestion des services (options)
# 
define( "LANG_SRV_START", "DEB_" );
define( "LANG_SRV_END", "FIN_" );
define( "LANG_SRV_SEP", "~" );
define( "LANG_SRV_IDENT", "Srv" );

######################################################################################
#
# Gen_IncludeServices
# Inclusion/Exclusion des "Services" d'un fichier
# Retourne 0 ou 1 suivant qu'il reste ou non des balises de services
# aprs le passage de l'algorithme (->appel rcursif)
# 
function Gen_IncludeServices ( $SrcFileName, $DstFileName, $UsedServices )
{
	// Charger le fichier source dans le tableau
	$FileArr = FILE( $SrcFileName );
	// Tableau des lignes destination
	$NewRows = Array();
	// Liste des options  inclure
	$UsedServices = LANG_SRV_SEP.$UsedServices.LANG_SRV_SEP;
	$bHasMoreSrv = 0;
	$DoExit = False;
	$Offset = StrLen(LANG_INS_START.LANG_SRV_START);
	// Parcourir le tableau des lignes du fichier source
	$SrcLine = reset( $FileArr );
	while ( True )
	{
		// Si ligne courante contient un service (ex: {DEB_Pied_De_Page}),
		// p et q reprsentent les positions des balises de dbut et de fin
		if ( Ereg( LANG_INS_START.LANG_SRV_START, $SrcLine ) )
		{
		 	// Position des balises d'identification de service
			$p = StrPos( $SrcLine, LANG_INS_START.LANG_SRV_START );
		 	$q = StrPos( $SrcLine, LANG_INS_END );
		 	// Nom du service
			$SrvName = SubStr( $SrcLine, $p+$Offset, $q-$p-$Offset );
			// Tester si le service doit tre inclus dans le code
			$bInsert = ( Ereg( LANG_SRV_SEP.$SrvName.LANG_SRV_SEP, $UsedServices ) == True );
			// Lire les lignes suivantes
			if ( ! ( $SrcLine = next( $FileArr ) ) ) break;
			// Jusqu' isolation de la marque de fin de service
			$SrvEndTag = LANG_INS_START.LANG_SRV_END.$SrvName.LANG_INS_END;
			while( ! Ereg( $SrvEndTag, $SrcLine ) )
			{
				// Ajouter la ligne si le service est inclus.
				if ( $bInsert ) {
					$NewRows[] = $SrcLine;
					// Et si c'est une marque de dbut, noter qu'il en reste
					// (Pour la gestion des services 
					if ( Ereg( LANG_INS_START.LANG_SRV_START, $SrcLine ) ) 
						$bHasMoreSrv = 1;
				}
				// Dfinir variables de ligne suivante et sortir si KO;
				if ( ! ( $SrcLine = next( $FileArr ) ) ) { $DoExit = True; break; }
			}
		}
		else
		{
			# Recopier la ligne si elle ne contient pas de marques de fin de service
			$NewRows[] = $SrcLine;
		}
		// Sortir si dernire ligne rencontre
		if ( ( $DoExit ) || ( ! ( $SrcLine = next( $FileArr ) ) ) ) break;
	}
	// Sauver le tableau dans le fichier destination
	if ( $fp = fopen( $DstFileName, "w" ) ) 
	{
		while ( list( $k, $v ) = each( $NewRows ) ) 
		{
			fputs( $fp, $v );
#			Echo( "NEW: <I>$v</I><BR>" );
		}
		fclose( $fp );
	}
	// Nettoyer et retourner indicateur des marques des services restantes
	return $bHasMoreSrv;
} // Gen_IncludeServices

######################################################################################
#
# Gen_ReplaceKeyWords
# Remplacement des mots cls d'un fichier
# 
function Gen_ReplaceKeyWords ( $SrcFileName, $DstFileName, $KeysArray )
{
	# Charger le fichier source
	if ( ! ( $RowsArray = file( $SrcFileName ) ) ) return False;
	# Crer le fichier destination
	if ( ! ( $fp = fopen( $DstFileName, "w" ) ) ) return False;
	# Pour identifier un dbut de mot-cl
	# Pour chaque ligne du fichier
	while( list( $k, $OneRow ) = each( $RowsArray ) )
	{
#		echo( "$k => $OneRow <BR>"  );
		# Pour chaque mot-cl du tableau
		reset( $KeysArray );
		$NewRow = $OneRow;
		while( list ( $KeyCod, $KeyVal ) = each( $KeysArray ) ) 
		{
			# On remplace uniquement les mots-cls (pas les options !)
			if ( ! Ereg( "^".LANG_KEY_START, $KeyCod ) ) continue;
			# Remplacement du mot cl par expression rgulire
			$FullKey = LANG_INS_START.$KeyCod.LANG_INS_END;
#			echo( "<DIR>Replacing $FullKey with $KeyVal </DIR>" );
			$NewRow = Ereg_Replace( $FullKey, $KeyVal, $NewRow );
			# Si il ne reste plus de mots-cls dans la ligne, sortir
			if ( strpos( $NewRow, LANG_INS_START.LANG_KEY_START ) < 0 ) break;
		}
		# Ecriture de la nouvelle ligne du fichier
		fputs( $fp, $NewRow );
	}
	fclose( $fp );
	return True;
} // Gen_ReplaceKeyWords

##############################################################################################
#
# Gen_Model
# 	Gnration d'un modle de SCRIPT
# 	KeysArray est le tableau des mots cls
# 	UsedServices est la chane des services utiliss spars par ~
# 
function Gen_Model( $SrcFile, $DstFile, $KeysArray, $UsedServices )
{
	// Inclusion / Exclusion des services
	// Au premier appel, on utilise Src et Dst (Src inchang)
	// Aux suivants, Dst et Dst
	$bMoreSrv = Gen_IncludeServices ( $SrcFile, $DstFile, $UsedServices );
	while ( $bMoreSrv > 0 ) {
		$bMoreSrv = Gen_IncludeServices ( $DstFile, $DstFile, $UsedServices );
	}
	// Remplacement des mots cls (Dst vers Dst)
	Gen_ReplaceKeyWords ( $DstFile, $DstFile, $KeysArray );
	return 1;
}
?>
