/*=========================================================*/
/* DBMS name:      ORACLE Version 10g                      */
/* Created on:     16/07/2006 10:54:05                     */
/*=========================================================*/
set feedback on
set echo on
set pagesize 1500
set linesize 1500
SPOOL db10gStagiaireEtoile.log
/*=========================================================*/
/* Table: DIM_CLIENTS                                      */
/*=========================================================*/
CREATE TABLE STAGIAIRE.DIM_CLIENTS  (
   CODE_CLIENT          CHAR(5)                    NOT NULL,
   CLIENT               NVARCHAR2(40)              NOT NULL,
   VILLE                VARCHAR2(30)               NOT NULL,
   PAYS                 VARCHAR2(15)               NOT NULL,
   CONSTRAINT PK_DIM_CLIENTS PRIMARY KEY (CODE_CLIENT)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_EMPLOYES                                     */
/*=========================================================*/
CREATE TABLE STAGIAIRE.DIM_EMPLOYES  (
   NO_EMPLOYE           NUMBER(6)                  NOT NULL,
   EMPLOYE              NVARCHAR2(70)              NOT NULL,
   FONCTION             VARCHAR2(30)               NOT NULL,
   CONSTRAINT PK_DIM_EMPLOYES PRIMARY KEY (NO_EMPLOYE)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_PRODUITS                                     */
/*=========================================================*/
CREATE TABLE STAGIAIRE.DIM_PRODUITS  (
   REF_PRODUIT          NUMBER(6)                  NOT NULL,
   NOM_PRODUIT          NVARCHAR2(50)              NOT NULL,
   NOM_CATEGORIE        VARCHAR2(25)               NOT NULL,
   CONSTRAINT PK_DIM_PRODUITS PRIMARY KEY (REF_PRODUIT)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: DIM_TEMPS                                        */
/*=========================================================*/
CREATE TABLE STAGIAIRE.DIM_TEMPS  (
   JOUR                 DATE                       NOT NULL,
   SEMAINE              NUMBER(2)                  NOT NULL,
   MOIS                 VARCHAR2(18)               NOT NULL,
   MOIS_N               NUMBER(2)                  NOT NULL,
   TRIMESTRE            NUMBER(1)                  NOT NULL,
   ANNEE                NUMBER(4)                  NOT NULL,
   CONSTRAINT PK_DIM_TEMPS PRIMARY KEY (JOUR)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: INDICATEURS                                      */
/*=========================================================*/
CREATE TABLE STAGIAIRE.INDICATEURS  (
   JOUR                 DATE                       NOT NULL,
   REF_PRODUIT          NUMBER(6)                  NOT NULL,
   CODE_CLIENT          CHAR(5)                    NOT NULL,
   NO_EMPLOYE           NUMBER(6)                  NOT NULL,
   NO_COMMANDE          NUMBER(6)                  NOT NULL,
   PORT                 NUMBER(12,2),
   QUANTITE             NUMBER(5),
   PRIX_UNITAIRE        NUMBER(12,2),
   CONSTRAINT PK_IND PRIMARY KEY 
   (JOUR, REF_PRODUIT, CODE_CLIENT, NO_EMPLOYE, NO_COMMANDE)
              USING INDEX  TABLESPACE GEST_ETOILE_INDX
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_TEMP                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_TEMP ON 
 STAGIAIRE.INDICATEURS ( JOUR ASC) TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_PROD                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_PROD ON 
STAGIAIRE.INDICATEURS ( REF_PRODUIT ASC )TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_CLIE                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_CLIE ON 
STAGIAIRE.INDICATEURS ( CODE_CLIENT ASC )TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Index: FK_IND_REF_DIM_EMPL                              */
/*=========================================================*/
CREATE INDEX FK_IND_REF_DIM_EMPL ON 
STAGIAIRE.INDICATEURS ( NO_EMPLOYE ASC)TABLESPACE GEST_ETOILE_INDX;
/*=========================================================*/
/* Table: QUANTITES_CLIENTS                                */
/*=========================================================*/
CREATE TABLE STAGIAIRE.QUANTITES_CLIENTS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   QUANTITE             NUMBER(5),
   PORT                 NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_ANNEES                                    */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_ANNEES  (
   ANNEE                NUMBER(4),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS                                   */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_CLIENTS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_1996                              */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_CLIENTS_1996  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_1997                              */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_CLIENTS_1997  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_CLIENTS_1998                              */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_CLIENTS_1998  (
   MOIS                 NUMBER(2),
   CODE_CLIENT          CHAR(5),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;
/*=========================================================*/
/* Table: VENTES_MOIS                                      */
/*=========================================================*/
CREATE TABLE STAGIAIRE.VENTES_MOIS  (
   ANNEE                NUMBER(4),
   MOIS                 NUMBER(2),
   VENTE                NUMBER(12,2),
   REMISE               NUMBER(12,2)
)  TABLESPACE GEST_ETOILE_DATA;

ALTER TABLE STAGIAIRE.INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_CLIE FOREIGN KEY (CODE_CLIENT)
      REFERENCES STAGIAIRE.DIM_CLIENTS (CODE_CLIENT)
      NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_EMPL FOREIGN KEY (NO_EMPLOYE)
      REFERENCES STAGIAIRE.DIM_EMPLOYES (NO_EMPLOYE)
      NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_PROD FOREIGN KEY (REF_PRODUIT)
      REFERENCES STAGIAIRE.DIM_PRODUITS (REF_PRODUIT)
      NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.INDICATEURS
   ADD CONSTRAINT FK_IND_REF_DIM_TEMP FOREIGN KEY (JOUR)
      REFERENCES STAGIAIRE.DIM_TEMPS (JOUR)
      NOT DEFERRABLE;

DECLARE
      v_date DATE := TO_DATE('01/01/1996','DD/MM/YYYY');
BEGIN 
      WHILE v_date < '01/01/1999' LOOP
      INSERT INTO DIM_TEMPS VALUES       
       (v_date, TO_CHAR(v_date, 'IW'), TO_CHAR(v_date, 'Month'),
       TO_CHAR(v_date, 'MM'), TO_CHAR(v_date, 'Q'), TO_CHAR(v_date, 'YYYY'));
       v_date := v_date + 1;
      END LOOP;
end;
/

SPOOL OFF