/*==============================================================*/
/* DBMS name:      ORACLE Version 10g       
/* Created on:     10/07/2006 11:36:08      
/*==============================================================*/
set feedback on
set echo on
set pagesize 1500
set linesize 1500
SPOOL db10gStagiaire.log
/*==============================================================*/
/* Table: CATEGORIES                                            */
/*==============================================================*/
CREATE TABLE STAGIAIRE.CATEGORIES  (
   CODE_CATEGORIE       NUMBER(6)                       NOT NULL,
   NOM_CATEGORIE        VARCHAR2(25)                    NOT NULL,
   DESCRIPTION          VARCHAR2(100)                   NOT NULL,
   CONSTRAINT PK_CATEGORIES PRIMARY KEY (CODE_CATEGORIE)
   USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Table: CLIENTS                                               */
/*==============================================================*/
CREATE TABLE STAGIAIRE.CLIENTS  (
   CODE_CLIENT          CHAR(5)                         NOT NULL,
   SOCIETE              NVARCHAR2(40)                   NOT NULL,
   ADRESSE              NVARCHAR2(60)                   NOT NULL,
   VILLE                VARCHAR2(30)                    NOT NULL,
   CODE_POSTAL          VARCHAR2(10)                    NOT NULL,
   PAYS                 VARCHAR2(15)                    NOT NULL,
   TELEPHONE            VARCHAR2(24)                    NOT NULL,
   FAX                  VARCHAR2(24),
   CONSTRAINT PK_CLIENTS PRIMARY KEY (CODE_CLIENT)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Table: COMMANDES                                             */
/*==============================================================*/
CREATE TABLE STAGIAIRE.COMMANDES  (
   NO_COMMANDE          NUMBER(6)                       NOT NULL,
   CODE_CLIENT          CHAR(5)                         NOT NULL,
   NO_EMPLOYE           NUMBER(6)                       NOT NULL,
   DATE_COMMANDE        DATE                            NOT NULL,
   DATE_ENVOI           DATE,
   PORT                 NUMBER(8,2),
   CONSTRAINT PK_COMMANDES PRIMARY KEY (NO_COMMANDE)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Index: FK_CLIENTS_COMMANDES                                  */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_CLIENTS_COMMANDES ON STAGIAIRE.COMMANDES (
   CODE_CLIENT ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Index: FK_EMPLOYES_COMMANDES                                 */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_EMPLOYES_COMMANDES ON STAGIAIRE.COMMANDES (
   NO_EMPLOYE ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Table: DETAILS_COMMANDES                                     */
/*==============================================================*/
CREATE TABLE STAGIAIRE.DETAILS_COMMANDES  (
   NO_COMMANDE          NUMBER(6)                       NOT NULL,
   REF_PRODUIT          NUMBER(6)                       NOT NULL,
   PRIX_UNITAIRE        NUMBER(8,2)                     NOT NULL,
   QUANTITE             NUMBER(5)                       NOT NULL,
   REMISE               FLOAT                           NOT NULL,
   CONSTRAINT PK_DETAILS_COMMANDES PRIMARY KEY (NO_COMMANDE, REF_PRODUIT)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Index: FK_COM_DET_COM                                        */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_COM_DET_COM ON STAGIAIRE.DETAILS_COMMANDES (
   NO_COMMANDE ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Index: FK_PROD_DET_COM                                       */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_PROD_DET_COM ON STAGIAIRE.DETAILS_COMMANDES (
   REF_PRODUIT ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Table: EMPLOYES                                              */
/*==============================================================*/
CREATE TABLE STAGIAIRE.EMPLOYES  (
   NO_EMPLOYE           NUMBER(6)                       NOT NULL,
   REND_COMPTE          NUMBER(6),
   NOM                  NVARCHAR2(40)                   NOT NULL,
   PRENOM               NVARCHAR2(30)                   NOT NULL,
   FONCTION             VARCHAR2(30)                    NOT NULL,
   TITRE                VARCHAR2(5)                     NOT NULL,
   DATE_NAISSANCE       DATE                            NOT NULL,
   DATE_EMBAUCHE        DATE            DEFAULT SYSDATE NOT NULL,
   SALAIRE              NUMBER(8,2)                     NOT NULL,
   COMMISSION           NUMBER(8,2),
   CONSTRAINT PK_EMPLOYES PRIMARY KEY (NO_EMPLOYE)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Index: FK_EMPLOYES_REND_COMPTE                               */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_EMPLOYES_REND_COMPTE ON STAGIAIRE.EMPLOYES (
   REND_COMPTE ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Table: FOURNISSEURS                                          */
/*==============================================================*/
CREATE TABLE STAGIAIRE.FOURNISSEURS  (
   NO_FOURNISSEUR       NUMBER(6)                       NOT NULL,
   SOCIETE              NVARCHAR2(40)                   NOT NULL,
   ADRESSE              NVARCHAR2(60)                   NOT NULL,
   VILLE                VARCHAR2(30)                    NOT NULL,
   CODE_POSTAL          VARCHAR2(10)                    NOT NULL,
   PAYS                 VARCHAR2(15)                    NOT NULL,
   TELEPHONE            VARCHAR2(24)                    NOT NULL,
   FAX                  VARCHAR2(24),
   CONSTRAINT PK_FOURNISSEURS PRIMARY KEY (NO_FOURNISSEUR)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Table: PRODUITS                                              */
/*==============================================================*/
CREATE TABLE STAGIAIRE.PRODUITS  (
   REF_PRODUIT          NUMBER(6)                       NOT NULL,
   NOM_PRODUIT          NVARCHAR2(40)                   NOT NULL,
   NO_FOURNISSEUR       NUMBER(6)                       NOT NULL,
   CODE_CATEGORIE       NUMBER(6)                       NOT NULL,
   QUANTITE             VARCHAR2(30),
   PRIX_UNITAIRE        NUMBER(8,2)                     NOT NULL,
   UNITES_STOCK         NUMBER(5),
   UNITES_COMMANDEES    NUMBER(5),
   INDISPONIBLE         NUMBER(1),
   CONSTRAINT PK_PRODUITS PRIMARY KEY (REF_PRODUIT)
              USING INDEX  TABLESPACE GEST_INDX
)  TABLESPACE GEST_DATA;
/*==============================================================*/
/* Index: FK_CATEGORIES_PRODUITS                                */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_CATEGORIES_PRODUITS ON STAGIAIRE.PRODUITS (
   CODE_CATEGORIE ASC
)  TABLESPACE GEST_INDX;
/*==============================================================*/
/* Index: FK_FOURNISEURS_PRODUITS                               */
/*==============================================================*/
CREATE INDEX STAGIAIRE.FK_FOURNISEURS_PRODUITS ON STAGIAIRE.PRODUITS (
   NO_FOURNISSEUR ASC
)  TABLESPACE GEST_INDX;

set TERMOUT OFF

@I_CATEGORIES.SQL
@I_CLIENTS.SQL
@I_COMMANDES.SQL
@I_DETAILS_COMMANDES.SQL
@I_EMPLOYES.SQL
@I_FOURNISSEURS.SQL
@I_PRODUITS.SQL

set TERMOUT OFF

update produits set unites_stock = NULL
where indisponible = -1;

update produits set unites_commandees = NULL
where unites_commandees = 0;

update commandes set no_employe=7
where no_employe=2;

update commandes set no_employe=3
where no_employe=5;

update commandes set no_employe=1
where no_employe=8;

ALTER TABLE STAGIAIRE.COMMANDES ADD CONSTRAINT FK_COMMANDE_CLIENTS 
FOREIGN KEY (CODE_CLIENT) REFERENCES STAGIAIRE.CLIENTS (CODE_CLIENT) NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.COMMANDES ADD CONSTRAINT FK_COMMANDE_EMPLOYES 
FOREIGN KEY (NO_EMPLOYE) REFERENCES STAGIAIRE.EMPLOYES (NO_EMPLOYE) NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.DETAILS_COMMANDES ADD CONSTRAINT FK_DETAILS_COMMANDES_COMMANDES 
FOREIGN KEY (NO_COMMANDE) REFERENCES STAGIAIRE.COMMANDES (NO_COMMANDE) NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.DETAILS_COMMANDES ADD CONSTRAINT FK_DETAILS_PRODUITS_PRODUITS 
FOREIGN KEY (REF_PRODUIT) REFERENCES STAGIAIRE.PRODUITS (REF_PRODUIT)  NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.EMPLOYES ADD CONSTRAINT FK_EMPLOYES_EMPLOYES 
FOREIGN KEY (REND_COMPTE) REFERENCES STAGIAIRE.EMPLOYES (NO_EMPLOYE)   NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.PRODUITS ADD CONSTRAINT FK_PRODUITS_CATEGORIE 
FOREIGN KEY (CODE_CATEGORIE) REFERENCES STAGIAIRE.CATEGORIES (CODE_CATEGORIE) NOT DEFERRABLE;

ALTER TABLE STAGIAIRE.PRODUITS ADD CONSTRAINT FK_PRODUITS_FOURNISEUR 
FOREIGN KEY (NO_FOURNISSEUR) REFERENCES STAGIAIRE.FOURNISSEURS (NO_FOURNISSEUR) NOT DEFERRABLE;

SPOOL OFF

@db10gStagiaireEtoile.sql

SET LINESIZE 1500
SET PAGESIZE 5000
SET ECHO OFF
SET FEEDBACK OFF

SPOOL select_count.sql
SELECT 'SELECT '''||TABLE_NAME||''' "Table", count(*) from '||TABLE_NAME||';' "--" FROM DBA_TABLES
WHERE OWNER = 'STAGIAIRE';
SPOOL OFF

SPOOL select_count.log
@select_count.sql
SPOOL OFF


SPOOL select_list.sql
SELECT 'SELECT * FROM (SELECT '''||TABLE_NAME||''' "Table" FROM DUAL),'||TABLE_NAME||' ;' "--" FROM DBA_TABLES
WHERE OWNER = 'STAGIAIRE';
SPOOL OFF

SPOOL select_list.log
@select_list.sql
select TABLE_NAME, TABLESPACE_NAME from user_tables;
select INDEX_NAME, TABLE_NAME , TABLESPACE_NAME  from user_indexes;
SPOOL OFF


EXIT