' Billing Component
' Copyright 2001 by Desaware Inc. All Rights Reserved

Public Class BillingComponent


    Inherits System.ComponentModel.Component

    ' Modify this for your system
    Private Const BillingXMLLocation As String = "d:\MovingToVBNet\Source\ch14\"

#Region " Component Designer generated code "

    Public Sub New(ByVal Container As System.ComponentModel.IContainer)
        MyClass.New()

        'Required for Windows.Forms Class Composition Designer support
        Container.Add(Me)
    End Sub

    Public Sub New()
        MyBase.New()

        'This call is required by the Component Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        OpenXML()

    End Sub

    'Required by the Component Designer
    Private components As System.ComponentModel.Container

    'NOTE: The following procedure is required by the Component Designer
    'It can be modified using the Component Designer.
    'Do not modify it using the code editor.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'BillingComponent
        '

    End Sub

#End Region

    Private myds As New DataSet()
    Private xmllocation As String

    Public Sub OpenXML()
        Dim loc As String
        xmllocation = BillingXMLLocation
        myds.ReadXmlSchema(xmllocation & "billingset.xsd")
        Try
            myds.ReadXml(xmllocation & "BillingData.xml")
        Catch e As Exception
        End Try
        Dim t As DataTable
    End Sub

    Public Sub AddRecord(ByVal Name As String, ByVal Hours As Double, ByVal Description As String)
        Dim dr As DataRow
        dr = myds.Tables(0).NewRow
        dr.Item(0) = Name
        dr.Item(1) = Hours
        dr.Item(2) = Description
        myds.Tables(0).Rows.Add(dr)
        ' We want the dataset to be up to date
        myds.AcceptChanges()
    End Sub

    Public Overloads Overrides Sub Dispose()
        MyBase.Dispose()
        myds.AcceptChanges()
        myds.WriteXml(xmllocation & "BillingData.xml", XmlWriteMode.IgnoreSchema)
        myds.Dispose()
    End Sub

    Public ReadOnly Property Info() As DataSet
        Get
            Return myds
        End Get
    End Property

End Class
