---MERGE
CREATE TABLE Primes
	(brevet CHAR(6), nom CHAR(20), paye NUMBER(7,2), compa CHAR(4));

CREATE TABLE Vols
	(brevet CHAR(6), dateVol DATE, bonus NUMBER(3));

INSERT INTO Primes VALUES ('PL-1', 'Aurlia Ente', 100, 'AF');
INSERT INTO Primes VALUES ('PL-2', 'Agns Bidal', 100, 'AF');
INSERT INTO Primes VALUES ('PL-3', 'Sylvie Payrissat', 0, 'SING');

INSERT INTO Vols VALUES ('PL-1', SYSDATE-15, 50);
INSERT INTO Vols VALUES ('PL-1', SYSDATE-10, 50);
INSERT INTO Vols VALUES ('PL-1', SYSDATE,    50);
INSERT INTO Vols VALUES ('PL-3', SYSDATE-5,  40);
INSERT INTO Vols VALUES ('PL-3', SYSDATE,    40);
INSERT INTO Vols VALUES ('PL-4', SYSDATE,    20);

SELECT * FROM Vols ;
SELECT * FROM Primes ;

CREATE VIEW v_Vols(brevet, sommeBonus)
	AS SELECT brevet, SUM(bonus)
	FROM Vols
	GROUP BY brevet;

SELECT * FROM v_Vols ; 

MERGE INTO Primes p
   USING (SELECT brevet, sommeBonus FROM v_Vols) v
   ON    (p.brevet = v.brevet) 
   WHEN MATCHED THEN UPDATE SET p.paye = p.paye + v.sommeBonus
   WHEN NOT MATCHED THEN INSERT (brevet, paye) VALUES (v.brevet, v.sommeBonus);

SELECT * FROM Primes ;



DROP VIEW v_Vols;
DROP TABLE Vols ;
DROP TABLE Primes;