
CREATE OR REPLACE TRIGGER Trig_Aprs_DI_Installer
 AFTER INSERT OR DELETE ON Installer
 FOR EACH ROW
BEGIN
 IF DELETING THEN
   UPDATE Poste SET nbLog=nbLog - 1 
          WHERE nPoste = :OLD.nPoste;
   UPDATE Logiciel SET nbInstall = nbInstall - 1 
          WHERE nLog = :OLD.nLog;
  ELSE 
   IF INSERTING THEN
      UPDATE Poste SET nbLog = nbLog + 1 
             WHERE nPoste = :NEW.nPoste;
      UPDATE Logiciel SET nbInstall = nbInstall + 1
             WHERE nLog = :NEW.nLog;
   END IF;
 END IF;
END;
/


INSERT INTO installer VALUES ('p8', 'log7', sequenceIns.NEXTVAL,SYSDATE,NULL);

SELECT * FROM Poste;
SELECT * FROM Logiciel;
SELECT * FROM Installer;


DELETE FROM installer WHERE nPoste='p8' AND nLog='log7';

SELECT * FROM Poste;
SELECT * FROM Logiciel;
SELECT * FROM Installer;

--

CREATE OR REPLACE TRIGGER Trig_Aprs_DI_Poste
 AFTER INSERT OR DELETE ON Poste
 FOR EACH ROW
BEGIN
 IF DELETING THEN
    UPDATE Salle SET nbPoste = nbPoste - 1
           WHERE nSalle = :OLD.nSalle;
 ELSE
    UPDATE Salle SET nbPoste = nbPoste + 1 
           WHERE nSalle = :NEW.nSalle;
 END IF;
END;
/

CREATE OR REPLACE TRIGGER Trig_Aprs_U_Salle
 AFTER UPDATE OF nbPoste ON Salle
 FOR EACH ROW
DECLARE
 differ NUMBER;
BEGIN
 differ := :NEW.nbPoste - :OLD.nbPoste;
 UPDATE Segment SET nbPoste = nbPoste + differ 
        WHERE indIP = :NEW.indIP;
END;
/



INSERT INTO poste VALUES ('p99','Poste 99','130.120.82','093','PCWS','s21',0);

SELECT * FROM Poste;
SELECT * FROM Salle;
SELECT * FROM Segment;


-- Contraintes complexes ...
	
CREATE OR REPLACE TRIGGER Trig_Avant_UI_Installer
 BEFORE INSERT OR UPDATE OF nPoste, nLog ON installer
 FOR EACH ROW
DECLARE
 type_log   Types.typeLP%TYPE;
 type_pos   Types.typeLP%TYPE;
 date_achat DATE;
BEGIN
 SELECT typeLog, dateAch INTO type_log,date_achat 
        FROM logiciel WHERE :NEW.nLog = nLog;

 SELECT typePoste INTO type_pos 
        FROM Poste WHERE :NEW.nPoste = nPoste;

 IF type_log != type_pos THEN
     RAISE_APPLICATION_ERROR(-20111,'Poste : '||type_pos||' diffrent du logiciel : '||type_log);
 END IF;
 IF :NEW.dateIns IS NOT NULL THEN
     IF :NEW.dateIns < date_achat THEN
	RAISE_APPLICATION_ERROR(-20112,'Installation ('|| :NEW.dateIns  ||') infrieure a la date d''achat ('||date_achat||')');
     END IF;
 END IF;
END;
/



SELECT nPoste, typePoste  FROM Poste;

SELECT nLog, typeLog FROM Logiciel;

SELECT nPoste, nLog  FROM Installer;

--bug types
INSERT INTO installer VALUES ('p8', 'log7', sequenceIns.NEXTVAL,SYSDATE,NULL);

--bug dates
INSERT INTO installer VALUES ('p99', 'log4', sequenceIns.NEXTVAL,'02-06-1997',NULL);

--ok
INSERT INTO installer VALUES ('p99', 'log4', sequenceIns.NEXTVAL,SYSDATE,NULL);



