
DROP PACKAGE BODY paquetageParcInfo ;
DROP PACKAGE paquetageParcInfo;

CREATE OR REPLACE PACKAGE paquetageParcInfo AS
 PROCEDURE installLogSeg (param1 IN VARCHAR2, param2 IN VARCHAR2, param3 IN VARCHAR2, 
           param4 IN DATE, param5 IN VARCHAR2, param6 IN VARCHAR2, param7 IN NUMBER);
 PROCEDURE calculTemps;
END paquetageParcInfo;
/

CREATE OR REPLACE PACKAGE BODY paquetageParcInfo AS
--
PROCEDURE calculTemps IS
   CURSOR curseur IS SELECT l.nomLog,p.nomPoste,l.dateAch,i.dateIns,i.nLog, i.nPoste
	   FROM Installer i, Logiciel l, Poste p
	   WHERE i.nPoste = p.nPoste AND i.nLog = l.nLog;
   atte NUMBER(4);
BEGIN
   FOR enreg IN curseur LOOP
	IF enreg.dateIns IS NULL THEN
	  DBMS_OUTPUT.PUT_LINE('Pas de date d''installation pour le logiciel ' 
         || enreg.nomLog  || ' sur ' || enreg.nomPoste);
	ELSE
	     IF enreg.dateAch IS NULL THEN
	        DBMS_OUTPUT.PUT_LINE('Date d''achat inconnue pour le logiciel ' 
                   || enreg.nomLog  || ' sur ' || enreg.nomPoste);
	     ELSE 
		   atte :=  enreg.dateIns - enreg.dateAch;
		   IF atte < 0 THEN
		      DBMS_OUTPUT.PUT_LINE('Logiciel ' ||  enreg.nomLog || ' install sur ' || 
		        enreg.nomPoste || ' ' ||  -atte || ' jour(s) avant d''tre achet!');	
		   ELSE
	   IF atte = 0 THEN
		DBMS_OUTPUT.PUT_LINE('Logiciel ' || enreg.nomLog  || ' sur ' || 
		 enreg.nomPoste || ' achet et install le mme jour!');		
	   ELSE 
		DBMS_OUTPUT.PUT_LINE('Logiciel ' || enreg.nomLog  || ' sur ' || 
		 enreg.nomPoste || ', attente ' || atte || ' jour(s).');
		UPDATE Installer SET delai = NUMTODSINTERVAL(enreg.dateIns - enreg.dateAch,'DAY')
		       WHERE  nPoste = enreg.nPoste AND nLog = enreg.nLog;
	  END IF;	
		  END IF;
	      END IF;
	END IF;
   END LOOP;
   COMMIT;
END calculTemps;
--
PROCEDURE installLogSeg (param1 IN VARCHAR2, param2 IN VARCHAR2, param3 IN VARCHAR2, 
 param4 IN DATE, param5 IN VARCHAR2, param6 IN VARCHAR2, param7 IN NUMBER) IS
 CURSOR  curseur IS SELECT p.nomPoste, p.nPoste, s.nomSalle
   FROM  Poste p, Salle s
   WHERE p.indIP  = param1 AND p.typePoste = param6
   AND   p.nSalle = s.nSalle;
 p_nomSegment Segment.nomSegment%TYPE;
 toutsePasseBien BOOLEAN := TRUE;
 date_fausse          EXCEPTION;
 pas_install_possible EXCEPTION;
 enfant_sans_parent   EXCEPTION;
 PRAGMA EXCEPTION_INIT(enfant_sans_parent,-2291);
 nbrInstall  NUMBER := 0;
BEGIN
 BEGIN
   --  numro de segment inconnu?
  SELECT nomSegment INTO p_nomSegment FROM Segment WHERE indIP  = param1 ;
  EXCEPTION
      WHEN NO_DATA_FOUND THEN
	toutsePasseBien := FALSE;
        DBMS_OUTPUT.PUT_LINE('Segment inconnu!');
      WHEN OTHERS THEN
	toutsePasseBien := FALSE;
        DBMS_OUTPUT.PUT_LINE('Erreur d''Oracle ' || SQLERRM  || '(' || SQLCODE || ')');
 END;
 IF param4 > SYSDATE THEN RAISE date_fausse;
 END IF;
 IF toutsePasseBien THEN
  INSERT INTO Logiciel VALUES (param2,param3,param4,param5,param6,param7,0);
  DBMS_OUTPUT.PUT_LINE(param3 || ' stock dans la table Logiciel');
  FOR enreg IN curseur LOOP
   nbrInstall  := nbrInstall + 1;
   INSERT INTO Installer VALUES(enreg .nPoste, param2, sequenceIns.NEXTVAL ,SYSDATE, 
	NUMTODSINTERVAL(SYSDATE-param4,'DAY'));
   DBMS_OUTPUT.PUT_LINE('Installation sur '|| enreg.nomPoste ||' dans ' || enreg.nomSalle);
  END LOOP;
  COMMIT;
  IF nbrInstall = 0 THEN 
    RAISE pas_install_possible;
  ELSE
    DBMS_OUTPUT.PUT_LINE(nbrInstall  || ' installations ont t faites.');
  END IF;
 END IF;
EXCEPTION
  WHEN enfant_sans_parent THEN
    --  leve de  type inconnu
    DBMS_OUTPUT.PUT_LINE('Type de logiciel inconnu!');
  WHEN DUP_VAL_ON_INDEX THEN
    --  logiciel dja prsent
    DBMS_OUTPUT.PUT_LINE('Logiciel dja prsent!');
  WHEN date_fausse THEN
    -- date d'achat > date_jour  : date_fausse
    DBMS_OUTPUT.PUT_LINE('Date d''achat suprieure  celle du jour!');
  WHEN pas_install_possible THEN
    -- aucune installation posssible sur ce segment
  DBMS_OUTPUT.PUT_LINE('Pas de poste de ce type sur le segment');
  WHEN OTHERS THEN
       DBMS_OUTPUT.PUT_LINE('Erreur d''Oracle ' ||
                 SQLERRM  || '(' || SQLCODE || ')');
 END installLogSeg ;
END paquetageParcInfo;
/
SET SERVEROUT ON
EXECUTE paquetageParcInfo.calculTemps;

--Mauvais segment
EXECUTE paquetageParcInfo.installLogSeg('130.120.87', 'log99','Blaster', '05-09-2003', '9.9', 'PCWS', 999.9 )

