
--XML DB Repository

SET LONG 10000
SET PAGESIZE 100

--vidage des rpertoires (ventuellement  faire en tests)

DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU')) THEN
      DBMS_XDB.DELETERESOURCE('/home/SOUTOU',4);
  END IF;
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/xsd')) THEN
      DBMS_XDB.DELETERESOURCE('/home/SOUTOU/xsd',4);
  END IF;
  IF (DBMS_XDB.EXISTSRESOURCE('/sys/schemas/SOUTOU')) THEN
     DBMS_XDB.DELETERESOURCE('/sys/schemas/SOUTOU',4);
  END IF;
  COMMIT;
END;
/


--copie d'une ressource
DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (NOT DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU')) THEN
     v_resultat := DBMS_XDB.CREATEFOLDER('/home/SOUTOU');
  END IF;
  IF (NOT DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/general')) THEN
     v_resultat := DBMS_XDB.CREATEFOLDER('/home/SOUTOU/general');
  END IF;
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/general/note.txt')) THEN
     DBMS_XDB.DELETERESOURCE('/home/SOUTOU/general/note.txt',4);
  END IF;
  v_resultat := DBMS_XDB.CREATERESOURCE('/home/SOUTOU/general/note.txt',
   BFILENAME('REPXML', 'A-Faire.txt'),NLS_CHARSET_ID('AL32UTF8'));
  COMMIT;
END;
/


--chargement de la grammaire ayant xdb:schemaURL  et xdb:defaultTable="TABCOMPREPO"

DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (NOT DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU')) THEN
     v_resultat := DBMS_XDB.CREATEFOLDER('/home/SOUTOU');
  END IF;
  IF (NOT DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/xsd')) THEN
     v_resultat := DBMS_XDB.CREATEFOLDER('/home/SOUTOU/xsd');
  END IF;
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd')) THEN
     DBMS_XDB.DELETERESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd',4);
  END IF;
  v_resultat := DBMS_XDB.CREATERESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd',
   BFILENAME('REPXML', 'compagniesRepository.xsd'),NLS_CHARSET_ID('AL32UTF8'));
  COMMIT;
END;
/

---dtail on rejoue l'ajout seul de la grammaire
DECLARE
BEGIN
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd')) THEN
     DBMS_XDB.DELETERESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd',4);
  END IF;
END;
/
DECLARE
  v_resultat BOOLEAN;
BEGIN
  v_resultat := DBMS_XDB.CREATERESOURCE('/home/SOUTOU/xsd/compagniesRepository.xsd',
   BFILENAME('REPXML', 'compagniesRepository.xsd'),NLS_CHARSET_ID('AL32UTF8'));
END;
/

--enregistrement de la grammaire telle que <xsd:schema 
--   xmlns:xsd="http://www.w3.org/2001/XMLSchema"
--   xdb:storeVarrayAsTable="true"
--   xmlns:xdb="http://xmlns.oracle.com/xdb"
--   xdb:schemaURL="http://www.soutou.net/compRepository.xsd" >

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/compRepository.xsd',DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
     SCHEMAURL =>'http://www.soutou.net/compRepository.xsd',
     SCHEMADOC => XDBURITYPE('/home/SOUTOU/xsd/compagniesRepository.xsd').GETCLOB(),
     LOCAL => TRUE,GENTYPES =>TRUE,GENTABLES=>TRUE,FORCE=>TRUE);
END;
/

SELECT TABLE_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TABLES;

SELECT TABLE_NAME, SCHEMA_OWNER FROM USER_XML_TABLES;

SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='TYPE';

--Casse pas utile
SELECT * FROM TABcomprepo;

DESC TABCOMPREPO;

--copie de 2 ressources ayant 

--<compagnie  
--   xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
--   xsi:noNamespaceSchemaLocation="http://www.soutou.net/compRepository.xsd">
-- ...

DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/general/comp1.xml')) THEN
     DBMS_XDB.DELETERESOURCE('/home/SOUTOU/general/comp1.xml',4);
  END IF;
  IF (DBMS_XDB.EXISTSRESOURCE('/home/SOUTOU/comp2.xml')) THEN
     DBMS_XDB.DELETERESOURCE('/home/SOUTOU/comp2.xml',4);
  END IF;
  v_resultat := DBMS_XDB.CREATERESOURCE('/home/SOUTOU/general/comp1.xml',
     BFILENAME('REPXML','compagnieRepository.xml'),NLS_CHARSET_ID('AL32UTF8'));
  v_resultat := DBMS_XDB.CREATERESOURCE('/home/SOUTOU/comp2.xml',
   BFILENAME('REPXML','compagnieRepository2.xml'),NLS_CHARSET_ID('AL32UTF8'));
  COMMIT;
END;
/

--RESOURSE_VIEW


SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES,'/sys/schemas/PUBLIC/xmlns.oracle.com/xdb/XDBResource.xsd') = 1;


SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES, '/home/SOUTOU/general/note.txt') = 1;

SELECT XDBURIType('/home/SOUTOU/general/note.txt').GETCLOB() 
  "A faire..." FROM DUAL;

SELECT COUNT(*)
  FROM RESOURCE_VIEW rv
  WHERE UNDER_PATH(rv.RES,'/home/SOUTOU/general') = 1;

SELECT ANY_PATH
  FROM RESOURCE_VIEW 
  WHERE EXTRACTVALUE(RES,'/Resource/DisplayName') LIKE '%.txt';

SELECT ANY_PATH FROM RESOURCE_VIEW
  WHERE under_path(RES, 2, '/home/SOUTOU') = 1
    AND existsNode(RES, '/Resource[@Container="true"]') = 1;

SELECT EXTRACT(rv.RES,'/Resource/CreationDate') "Date cration"
  FROM RESOURCE_VIEW rv
  WHERE EQUALS_PATH(rv.RES,'/home/SOUTOU/general/note.txt') = 1;

SELECT DBMS_XMLGEN.CONVERT(EXTRACT(rv.RES,
  '/Resource/Contents/text/text()',
  'xmlns="http://xmlns.oracle.com/xdb/XDBResource.xsd"').GETCLOBVAL(),1) "Contenu"
  FROM RESOURCE_VIEW rv
  WHERE EQUALS_PATH(rv.RES,'/home/SOUTOU/general/note.txt') = 1;

SELECT alias.nom FROM RESOURCE_VIEW rv,
  XMLTABLE(XMLNAMESPACES ('http://xmlns.oracle.com/xdb/XDBResource.xsd' AS "r"),
                '/r:Resource/r:Contents/compagnie/pilotes/pilote'
                PASSING rv.RES
                COLUMNS nom VARCHAR2(15) PATH 'nom') alias
  WHERE EQUALS_PATH(rv.RES,'/home/SOUTOU/comp2.xml') = 1;


---
SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES,'/home/SOUTOU/general/comp1.xml') = 1;

SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES,'/home/SOUTOU/comp2.xml') = 1;

---/Resource[SchemaElement...

SELECT ANY_PATH FROM RESOURCE_VIEW
  WHERE EXISTSNODE(RES,
  '/Resource[SchemaElement="http://www.soutou.net/compRepository.xsd#compagnie"]')=1;

--Resource/XMLRef ---------------------

select ANY_PATH, extract(value(c), '/compagnie/pilotes').getclobval() "CLOB"
      from RESOURCE_VIEW r, TABCOMPREPO c
     where extractValue(r.res,'/Resource/XMLRef') = ref(c)  AND ROWNUM < 3;

select extractValue(res,'Resource/XMLRef') from resource_view
 where any_path = '/home/SOUTOU/general/comp1.xml';

SELECT alias.NOM FROM RESOURCE_VIEW rv, TABCOMPREPO c,
       XMLTable('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE
                COLUMNS nom VARCHAR2(20) PATH 'nom') alias
  WHERE EQUALS_PATH(rv.RES,'/home/SOUTOU/comp2.xml') = 1
  AND REF(c) = EXTRACTVALUE(rv.RES,'/Resource/XMLRef');

-- PATH_VIEW

COL PATH(1) FORMAT A40
SELECT PATH(1), DEPTH(1) FROM PATH_VIEW 
  WHERE UNDER_PATH(RES,3,'/home/SOUTOU',1) = 1;

COL PATH FORMAT A40
SELECT PATH, DEPTH(1), DEPTH(2) FROM PATH_VIEW
  WHERE (UNDER_PATH(RES,3,'/sys/schemas/SOUTOU',1) = 1
      OR UNDER_PATH(RES,3,'/home/SOUTOU',2) = 1);

---MISES A JOUR

--RESSOURCES 


SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES, '/home/SOUTOU/general/note.txt') = 1;

UPDATE RESOURCE_VIEW r
  SET r.RES = UPDATEXML(r.RES,'/Resource/DisplayName/text()','Mom_memo')
    WHERE equals_path(r.RES, '/home/SOUTOU/general/note.txt') = 1;

SELECT r.RES.GETCLOBVAL()
  FROM RESOURCE_VIEW r
  WHERE EQUALS_PATH(r.RES, '/home/SOUTOU/general/note.txt') = 1;

DELETE FROM RESOURCE_VIEW WHERE EQUALS_PATH(RES,'/home/SOUTOU/general/note.txt') = 1;

UPDATE PATH_VIEW SET PATH = '/home/SOUTOU/comp1.xml' 
	WHERE PATH = '/home/SOUTOU/general/comp1.xml';

--CONTENUS

UPDATE RESOURCE_VIEW
  SET res = UPDATEXML(RES,'/r:Resource/r:Contents/compagnie/nomComp/text()',
 'Compagnie Euralair','xmlns:r="http://xmlns.oracle.com/xdb/XDBResource.xsd"')
  WHERE EQUALS_PATH(RES,'/home/SOUTOU/comp1.xml')=1;

UPDATE TABCOMPREPO c
  SET c.OBJECT_VALUE = UPDATEXML(c.OBJECT_VALUE,'/compagnie/nomComp/text()',
'Nouveau nom : Euralair')
    WHERE REF(c) =
      (SELECT EXTRACTVALUE(rv.RES,'/Resource/XMLRef')
         FROM RESOURCE_VIEW rv
         WHERE EQUALS_PATH(rv.RES,'/home/SOUTOU/comp1.xml')=1);
