--WITH


CREATE TABLE Compagnie
	(comp VARCHAR2(4), nomComp VARCHAR2(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), salaire NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie	VALUES ('AF', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 'Singapore AL');
INSERT INTO Compagnie   VALUES ('CAST', 'Castanet AL');

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 4500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 9000, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 10000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 10050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 16000, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 10000, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 15000, 'CAST');

WITH comp_charges AS (SELECT nomComp, SUM(salaire) total_sal_comp
 	        	FROM Pilote p, Compagnie c
	 	        WHERE p.compa  = c.comp
			GROUP BY nomComp),
     moy_charges AS (SELECT SUM(total_sal_comp)/COUNT(*) moyenne
  		        FROM comp_charges)

SELECT * 
	FROM comp_charges 
	WHERE total_sal_comp < (SELECT moyenne FROM moy_charges)
	ORDER BY nomComp;

DROP TABLE Pilote;
DROP TABLE Compagnie;


--WITH BUCKET

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), nbHVol NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 1050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 1600, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 1700, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 4000, 'CAST');
INSERT INTO Pilote VALUES ('PL-9', 'Patrick Baudry', 3999, 'CAST');
INSERT INTO Pilote VALUES ('PL-10', 'Daniel Viel', 5000, 'CAST');


SELECT brevet, nom, nbhvol  FROM Pilote ORDER BY nbHVol ;

SELECT brevet , nom, nbHVol "Heures de vol",
   WIDTH_BUCKET(nbHVol,600, 4000, 10) "Tranche Exprience"
   FROM Pilote
   ORDER BY nbHVol ;

DROP TABLE Pilote;