
--

CONNECT / AS SYSDBA
 
DROP USER testXML CASCADE;

CREATE USER testXML 
 IDENTIFIED BY testXML 
 DEFAULT TABLESPACE USERS
 TEMPORARY TABLESPACE TEMP
 QUOTA UNLIMITED ON USERS;
 
GRANT DBA, XDBADMIN TO testXML ;
 
CONNECT testXML / testXML 

--

SET LONG 10000
SET PAGESIZE 100

----
SELECT USERNAME,ACCOUNT_STATUS FROM DBA_USERS;
DESC RESOURCE_VIEW;
---

---

DROP DIRECTORY repxml;
CREATE DIRECTORY repxml AS 'C:\Donnees\Livres\Livres-Eyrolles\SQLpourOracle3\sourcesXML';

--

-----------Enreg grammaire

BEGIN
--  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/compagnies.xsd',DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/compagnies.xsd',
    SCHEMADOC => BFILENAME('REPXML','compagniesannote.xsd'),
    LOCAL => TRUE,    GENTYPES => TRUE,    GENTABLES => FALSE,  
    CSID =>      NLS_CHARSET_ID('AL32UTF8'));
END;
/


--aucune table cre
SELECT TABLE_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TABLES;

SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='TYPE';

DESCRIBE COMPAGNIE_TYPE;
DESCRIBE PILOTES_TYPE;
DESCRIBE PILOTE_TYPE; 
DESCRIBE PILOTE_VRY;                                                                                                                           

--mode structur OR----------------------

DROP TABLE compagnie_OR_xmlschema;
CREATE TABLE compagnie_OR_xmlschema OF XMLType
  XMLTYPE STORE AS OBJECT RELATIONAL
  XMLSCHEMA "http://www.soutou.net/compagnies.xsd"
  ELEMENT "compagnie"
  VARRAY "XMLDATA"."PILOTES"."PILOTE"
    STORE AS TABLE pilote_table 
             ((PRIMARY KEY (NESTED_TABLE_ID, SYS_NC_ARRAY_INDEX$)));

DESCRIBE compagnie_OR_xmlschema;

SELECT TABLE_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TABLES;

-----------------AJOUT EN BASE DE DOCUMENTS

--respect grammaire
INSERT INTO compagnie_OR_xmlschema  VALUES
	(XMLType(BFILENAME('REPXML','compagnie.xml'),NLS_CHARSET_ID('AL32UTF8')));

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AC</comp>	
	<pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		</pilote>
	</pilotes>
	<nomComp>Castanet Lines</nomComp>
</compagnie>'));

--respectent pas trop la grammaire

INSERT INTO compagnie_OR_xmlschema VALUES
	(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>NoPil</comp>	
	<pilotes></pilotes>
	<nomComp>No pilot</nomComp>
</compagnie>'));

INSERT INTO compagnie_OR_xmlschema VALUES
	(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>PasPil</comp>	
	<nomComp>Pas de pilote</nomComp>
</compagnie>'));

INSERT INTO compagnie_OR_xmlschema VALUES
	(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>seul!</comp>	
</compagnie>'));

--ne respectent pas la grammaire :

--controle 
-- SQL Error: ORA-30937:Absence de dfinition de schma
INSERT INTO compagnie_OR_xmlschema  VALUES
(XMLType(BFILENAME('REPXML','pilote.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
 <comp>PB</comp>	
  <pilote brevet="PL-5">
          <nom>L. Schneider</nom>
          <salaire>8000</salaire>
   </pilote>
 <nomComp>Manque lment pilotes</nomComp>
</compagnie>'));
-- SQL Error: ORA-30937:Absence de dfinition de schma

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>1234567</comp>	
	<pilotes></pilotes>
	<nomComp>Trop long le code comp!</nomComp>
</compagnie>'));
--SQL Error: ORA-30951: L'lment ou l'attribut (Xpath 1234567) dpasse la longueur maximale

SELECT * FROM compagnie_OR_xmlschema;

---Contraintes mode structur OR

SELECT EXTRACT(c.OBJECT_VALUE,'compagnie/comp') "Comp",
       c.ISSCHEMAVALID() FROM compagnie_OR_xmlschema c;

--full validation

ALTER TABLE compagnie_OR_xmlschema 
	ADD CONSTRAINT valide_compagnie
	CHECK (XMLIsValid(OBJECT_VALUE) = 1);
--

DELETE FROM compagnie_OR_xmlschema c WHERE c.ISSCHEMAVALID() = 0;

ALTER TABLE compagnie_OR_xmlschema 
	ADD CONSTRAINT valide_compagnie
	CHECK (XMLIsValid(OBJECT_VALUE) = 1);

--seules passeront les full validation dsormais 

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>	<comp>NoPil</comp>	<pilotes></pilotes>
	<nomComp>No pilot</nomComp> </compagnie>'));

ALTER TABLE compagnie_OR_xmlschema 
	DROP CONSTRAINT valide_compagnie;

CREATE OR REPLACE TRIGGER valide_compagnie
   BEFORE INSERT ON compagnie_OR_xmlschema 
   FOR EACH ROW
BEGIN
  IF (:NEW.OBJECT_VALUE IS NOT NULL) THEN 
	:NEW.OBJECT_VALUE.SCHEMAVALIDATE();
  END IF;
END;
/

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie><comp>NoPil</comp><pilotes></pilotes><nomComp>No pilot</nomComp>
</compagnie>'));

-- unique

ALTER TABLE compagnie_OR_xmlschema ADD CONSTRAINT unique_nomcomp UNIQUE (XMLDATA."NOMCOMP");

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>bis</comp><pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		</pilote>
	</pilotes><nomComp>Castanet Lines</nomComp>
</compagnie>'));

--possible aussi

ALTER TABLE compagnie_OR_xmlschema
   ADD CONSTRAINT pk_compagnie_OR PRIMARY KEY(XMLDATA."COMP");

INSERT INTO compagnie_OR_xmlschema  VALUES
	(XMLType(BFILENAME('REPXML','compagnie.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagnie_OR_xmlschema  VALUES
	(XMLType(BFILENAME('REPXML','compagnie.xml'),nls_charset_id('AL32UTF8')));


-- not null
ALTER TABLE compagnie_OR_xmlschema
 ADD CONSTRAINT nn_nomcomp CHECK ((XMLDATA."NOMCOMP") IS NOT NULL);

-- autre validation
ALTER TABLE compagnie_OR_xmlschema
 ADD CONSTRAINT debut_comp CHECK ((XMLDATA."COMP") LIKE 'A%'
 OR (XMLDATA."COMP") LIKE 'E%');

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>DA</comp>	
<pilotes>
	<pilote brevet="PL-3">
		  <nom>C. Soutou</nom>
		  <salaire>5000</salaire>
	</pilote>
	<pilote brevet="PL-4">
		  <nom>J. Marchesani</nom>
	</pilote>
</pilotes><nomComp>Mauvais code</nomComp>
</compagnie>'));

--FK

CREATE TABLE compagnie_R1 (codecomp VARCHAR2(6) PRIMARY KEY, budget NUMBER); 
INSERT INTO compagnie_R1 VALUES ('AB', 30090);
INSERT INTO compagnie_R1 VALUES ('AC', 500000);
INSERT INTO compagnie_R1 VALUES ('EA', 900000);
INSERT INTO compagnie_R1 VALUES ('EF', 700000);
INSERT INTO compagnie_R1 VALUES ('EG', 40000);

---

ALTER TABLE compagnie_OR_xmlschema
 ADD CONSTRAINT fk_comp FOREIGN KEY (XMLDATA."COMP") REFERENCES compagnie_R1 (codecomp);

--

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AG</comp>	
	<pilotes>
		<pilote brevet="Bug">
		   <nom>Bug</nom>
		   <salaire>10</salaire>
		</pilote>
	</pilotes>
	<nomComp>Inexistante dans la table compagnie_R</nomComp>
</compagnie>'));

--ALTER TABLE compagnie_OR_xmlschema DROP CONSTRAINT fk_comp;

-- test contrainte 2eme niveau
---COntrainte d'un attribut du 2eme niveau : passer par la table de stockage 

ALTER TABLE pilote_table ADD 
 CONSTRAINT un_brevet UNIQUE (NESTED_TABLE_ID, "BREVET");

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>EA</comp>	
	<pilotes>
		<pilote brevet="PL-7">
		   <nom>L. Schneider</nom>
		   <salaire>500</salaire>
		</pilote>
		<pilote brevet="PL-7">
		   <nom>A. Roux</nom>
                   <salaire>700</salaire>
		</pilote>
	</pilotes>
	<nomComp>Brevet en doublons</nomComp>
</compagnie>'));

--lment de la collection

ALTER TABLE pilote_table ADD CONSTRAINT ck_salaire 
  CHECK (SALAIRE IS NULL OR SALAIRE > 600);

-- brevet unique parmi tous les doc 
ALTER TABLE pilote_table ADD CONSTRAINT un_brevet_tous UNIQUE (BREVET);

--test : incorrect
INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>EA</comp>	
<pilotes>
	<pilote brevet="PL-1">
		   <nom>L. Schneider</nom>
		   <salaire>500</salaire>
	</pilote>
	<pilote brevet="PL-7">
		   <nom>A. Roux</nom>
                   <salaire>700</salaire>
	</pilote>
</pilotes>
<nomComp>Brevet en doublons</nomComp>
</compagnie>'));

--test correct
INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>EA</comp>	
<pilotes>
		<pilote brevet="PL-7">
		   <nom>A. Roux</nom>
                   <salaire>700</salaire>
		</pilote>
</pilotes><nomComp>Brevet en doublons</nomComp>
</compagnie>'));

SELECT EXTRACT(OBJECT_VALUE,'compagnie') FROM compagnie_OR_xmlschema;

--Elements composs

BEGIN
--  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/avions.xsd',
--             DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/avions.xsd',
    SCHEMADOC => BFILENAME('REPXML','avionannote.xsd'),
    LOCAL => TRUE,GENTYPES => TRUE,GENTABLES => FALSE,  
    CSID => NLS_CHARSET_ID('AL32UTF8'));
END;
/

CREATE TABLE avion_OR_xmlschema OF XMLType
  XMLTYPE STORE AS OBJECT RELATIONAL
  XMLSCHEMA "http://www.soutou.net/avions.xsd"
  ELEMENT "avion";
 
ALTER TABLE avion_OR_xmlschema  ADD CONSTRAINT unique_av UNIQUE (XMLDATA."IMMAT");
ALTER TABLE avion_OR_xmlschema  ADD CONSTRAINT ck_av CHECK (XMLDATA."IMMAT" IS NOT NULL);
ALTER TABLE avion_OR_xmlschema  ADD CONSTRAINT unique_nomav UNIQUE (XMLDATA."TYPEAV_T"."NOMAV");

INSERT INTO avion_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<avion>
 <immat>F-GOWW</immat>
 <typav>
   <nomAv>A320</nomAv>
   <prixAv>4000300</prixAv>
 </typav>
</avion>'));

INSERT INTO avion_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<avion>
 <immat>F-DOUB</immat>
 <typav>
   <nomAv>A320</nomAv>
   <prixAv>4000</prixAv>
 </typav>
</avion>'));

---------Enreg grammaire annote avec cration de la table et des contraintes


BEGIN
 -- DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/compagniedefauts.xsd',DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/compagniedefauts.xsd',
    SCHEMADOC => BFILENAME('REPXML','compagniesannoteTable.xsd'),
    LOCAL => TRUE, GENTYPES => TRUE, GENTABLES => TRUE,  
    CSID =>      NLS_CHARSET_ID('AL32UTF8'));
END;
/


--tests

INSERT INTO compagniedefaut VALUES
(XMLType(BFILENAME('REPXML','compagnie.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagniedefaut VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>AC</comp>	
<pilotes>
	<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
	</pilote>
	<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
	</pilote>
</pilotes><nomComp>Castanet Lines</nomComp>
</compagnie>'));


INSERT INTO compagniedefaut VALUES
(XMLType(BFILENAME('REPXML','compagnie.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagniedefaut VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>DA</comp>	
<pilotes>
	<pilote brevet="PL-3">
		  <nom>C. Soutou</nom>
		  <salaire>5000</salaire>
	</pilote>
	<pilote brevet="PL-4">
		  <nom>J. Marchesani</nom>
	</pilote>
</pilotes><nomComp>Mauvais code</nomComp>
</compagnie>'));


--EXTRACTIONS--------------------------------------

DELETE FROM compagnie_OR_xmlschema;

INSERT INTO compagnie_OR_xmlschema  VALUES
(XMLType(BFILENAME('REPXML','compagnie.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagnie_OR_xmlschema VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>AC</comp>	
<pilotes>
	<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
	</pilote>
	<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
	</pilote>
</pilotes><nomComp>Castanet Lines</nomComp>
</compagnie>'));

SELECT EXTRACT(OBJECT_VALUE,'compagnie/comp') FROM compagnie_OR_xmlschema;

--Nom de tous les pilotes
SELECT EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote/nom') 
"Nom de tous les pilotes" FROM compagnie_OR_xmlschema;

SELECT COUNT(EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote/nom')) FROM compagnie_OR_xmlschema;

--Dtails des deuximes pilotes
SELECT EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote[2]') 
"Deuximes pilotes"  FROM compagnie_OR_xmlschema;

--texte / attributs
SELECT  XMLCAST(XMLQUERY(
        '$obj/compagnie/comp/text()' PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Code comp"
  FROM compagnie_OR_xmlschema;

--liste des brevets
--pas terrible l'tat de sortie
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote/@brevet' 
  PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Brevet"
  FROM compagnie_OR_xmlschema;

SELECT EXTRACTVALUE(acoll.COLUMN_VALUE,'/pilote/@brevet') "Brev"
  FROM compagnie_OR_xmlschema c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;

SELECT SUM(TO_NUMBER(
       EXTRACTVALUE(acoll.COLUMN_VALUE,'/pilote/salaire'))) "Masse salariale"
  FROM compagnie_OR_xmlschema c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;

--Prdicats

--Nom du pilote de brevet PL-2
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote[@brevet="PL-2"]/nom/text()' 
  PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(15)) "Nom de PL-2"
  FROM compagnie_OR_xmlschema;
--
SELECT acoll.COLUMN_VALUE
  FROM compagnie_OR_xmlschema c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;
--
SELECT COUNT(*) "Nombre de compagnies" FROM compagnie_OR_xmlschema 
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()=5000]'
          PASSING OBJECT_VALUE AS "obj");
--
SELECT
EXTRACT(OBJECT_VALUE,'compagnie/comp') "comp",EXTRACT(OBJECT_VALUE,'compagnie/nomComp') "nom"
  FROM compagnie_OR_xmlschema 
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()<5000]'
          PASSING OBJECT_VALUE AS "obj");
--
SELECT EXTRACT(OBJECT_VALUE,'compagnie/comp') "comp"
  FROM compagnie_OR_xmlschema 
  WHERE EXISTSNODE(OBJECT_VALUE,'compagnie/pilotes/pilote/salaire[number()<5000]')=1;
--
SELECT acomp.colcmp,SUM(TO_NUMBER(li.sal))
  FROM compagnie_OR_xmlschema c,
   XMLTABLE('/compagnie' PASSING c.OBJECT_VALUE
	COLUMNS colcmp VARCHAR2(6) PATH 'comp',
	        pils    XMLType     PATH 'pilotes/pilote') acomp,
   XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS sal   NUMBER PATH 'salaire') li
  GROUP BY acomp.colcmp;
--
	
--Mises  jour

UPDATE compagnie_OR_xmlschema 
  SET OBJECT_VALUE = 
	XMLType(BFILENAME('REPXML','autrecompagnie.xml'),NLS_CHARSET_ID('AL32UTF8'))
  WHERE EXISTSNODE(OBJECT_VALUE, 'compagnie/comp[text()="AB"]') = 1;

--maj salaire

UPDATE compagnie_OR_xmlschema 
  SET OBJECT_VALUE = 
  UPDATEXML(OBJECT_VALUE, '/compagnie/pilotes/pilote/salaire/text()', '6000')
  WHERE EXISTSNODE(OBJECT_VALUE, '/compagnie/pilotes/pilote/nom[text() = "C. Soutou"]') = 1;

UPDATE compagnie_OR_xmlschema 
  SET OBJECT_VALUE = INSERTCHILDXML(OBJECT_VALUE,'/compagnie/pilotes','pilote', 
    XMLType('<pilote brevet="PL-5">
          <nom>L. Schneider</nom>
          <salaire>8000</salaire></pilote>'))
  WHERE EXISTSNODE(OBJECT_VALUE,
                   '/compagnie[comp="AC"]') = 1;

SELECT acoll.COLUMN_VALUE
  FROM compagnie_OR_xmlschema c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll
  WHERE EXISTSNODE(OBJECT_VALUE, '/compagnie[comp="AC"]') = 1;

UPDATE compagnie_OR_xmlschema 
  SET OBJECT_VALUE =  APPENDCHILDXML(OBJECT_VALUE,'/compagnie/pilotes/pilote[2]', 
    XMLType('<salaire>4000</salaire>'))
  WHERE EXISTSNODE(OBJECT_VALUE,'/compagnie[comp="AC"]') = 1;


SELECT EXTRACT(OBJECT_VALUE,'/compagnie/pilotes') "/compagnie/pilotes"
  FROM compagnie_OR_xmlschema;

UPDATE compagnie_OR_xmlschema 
  SET OBJECT_VALUE =  DELETEXML(OBJECT_VALUE,'/compagnie/pilotes/pilote[1]')
  WHERE EXISTSNODE(OBJECT_VALUE,'/compagnie[comp="AC"]') = 1;


SELECT EXTRACT(OBJECT_VALUE,'/compagnie/pilotes') "/compagnie/pilotes"
  FROM compagnie_OR_xmlschema;

--VUES relationnelles

DROP VIEW compagnie_detail_vue ;
CREATE VIEW compagnie_detail_vue AS
  SELECT acomp.colcmp, acomp.nomcmp, ligne.*
    FROM compagnie_OR_xmlschema c,
    XMLTABLE('/compagnie' PASSING c.OBJECT_VALUE
	COLUMNS colcmp VARCHAR2(6)  PATH 'comp',
	        nomcmp VARCHAR2(20) PATH 'nomComp',
	        pils   XMLType      PATH 'pilotes/pilote') acomp,
    XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS brevetpil VARCHAR2(4) PATH '@brevet',
                nompil    VARCHAR2(20) PATH 'nom',
	        salpil    NUMBER PATH 'salaire') ligne;

SELECT DISTINCT v.colcmp, v.nomcmp FROM compagnie_detail_vue v;

SELECT v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  WHERE v.colcmp = 'AC';

SELECT v.colcmp, v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  ORDER BY 1,2;

SELECT v.colcmp, COUNT(v.brevetpil) "Nombre de pilotes salaris"
  FROM compagnie_detail_vue v
  WHERE v.salpil IS NOT NULL
  GROUP BY v.colcmp
  ORDER BY 1;

-------------------------------mode non structur CLOB------------------------

--Autre grammaire 

BEGIN
--  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/compagnies2.xsd',
--      DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/compagnies2.xsd',
    SCHEMADOC => BFILENAME('REPXML','compagnies.xsd'),
    LOCAL => TRUE,    GENTYPES => TRUE,    GENTABLES => FALSE,  
    CSID =>      NLS_CHARSET_ID('AL32UTF8'));
END;
/


SELECT OBJECT_NAME FROM USER_OBJECTS WHERE OBJECT_TYPE='TYPE';

--DROP TABLE compagnie_col_xmlschema_CLOB;

CREATE TABLE compagnie_col_xmlschema_CLOB
 (cle VARCHAR2(10) PRIMARY KEY, col_clob_xml XMLType)
  XMLTYPE col_clob_xml STORE AS CLOB (TABLESPACE users
		STORAGE (INITIAL 100K NEXT 50K)
		CHUNK 800 CACHE LOGGING)
   XMLSCHEMA "http://www.soutou.net/compagnies2.xsd"
   ELEMENT "compagnie";


SELECT TABLE_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TABLES;

SELECT TABLE_NAME FROM USER_TABLES;

-----------------AJOUT EN BASE DE DOCUMENTS

DELETE FROM compagnie_col_xmlschema_CLOB ;

--respect grammaire

INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB1',XMLType(BFILENAME('REPXML','compagnie.xml'),NLS_CHARSET_ID('AL32UTF8')));

--respectent en partie la grammaire
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB2',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AC</comp>	
	<pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		</pilote>
	</pilotes>
	<nomComp>Castanet Lines</nomComp>
</compagnie>'));

INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB3',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie><comp>NoPil</comp><pilotes></pilotes><nomComp>No pilot</nomComp></compagnie>'));

--ne respectent pas la grammaire :

--passe!
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB4',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>  <nomredacChef>L. Schneider</nomredacChef> </compagnie>'
).CREATESCHEMABASEDXML('http://www.soutou.net/compagnies2.xsd'));

--racine diffrente de <compagnie>
--passe si pas CREATESCHEMABASEDXML() 
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB5',XMLType(BFILENAME('REPXML','pilote.xml'),nls_charset_id('AL32UTF8')));

--typage incorrect : passe!
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB6',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>1234567</comp>	
	<pilotes></pilotes>
	<nomComp>Trop long le code comp!</nomComp>
</compagnie>').CREATESCHEMABASEDXML('http://www.soutou.net/compagnies2.xsd'));

--racine diffrente de <compagnie>
--passe pas si pas CREATESCHEMABASEDXML() 
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB7',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
  <nomredacChef>L. Schneider</nomredacChef>').CREATESCHEMABASEDXML('http://www.soutou.net/compagnies2.xsd'));

INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB8',XMLType(BFILENAME('REPXML','pilote.xml')
,nls_charset_id('AL32UTF8')).CREATESCHEMABASEDXML('http://www.soutou.net/compagnies2.xsd'));
--ERREUR  ORA-31043: L'lment 'pilote_type' n'est pas dfini globalement dans le schma


SELECT c.cle, c.col_clob_xml.GETCLOBVAL() FROM compagnie_col_xmlschema_CLOB c;

--trs mal adapt
SELECT c.cle "Cle", c.col_clob_xml.ISSCHEMAVALID() FROM compagnie_col_xmlschema_CLOB c;

DELETE FROM compagnie_col_xmlschema_CLOB c WHERE cle > 'CleCLOB3';

SELECT c.cle "Cle", c.col_clob_xml.ISSCHEMAVALID() FROM compagnie_col_xmlschema_CLOB c;

ALTER TABLE compagnie_col_xmlschema_CLOB 
	ADD CONSTRAINT valide_compagnieCLOB
	CHECK (XMLIsValid(col_clob_xml) = 1);

DELETE FROM compagnie_col_xmlschema_CLOB c WHERE cle > 'CleCLOB1';

ALTER TABLE compagnie_col_xmlschema_CLOB 
	ADD CONSTRAINT valide_compagnieCLOB
	CHECK (XMLIsValid(col_clob_xml) = 1);

--test
INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB2',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AC</comp>	
	<pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		</pilote>
	</pilotes>
	<nomComp>Castanet Lines</nomComp>
</compagnie>'));

INSERT INTO compagnie_col_xmlschema_CLOB VALUES
('CleCLOB2',XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AC</comp>	
	<pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		 <salaire>4000</salaire>
		</pilote>
	</pilotes>
	<nomComp>Castanet Lines</nomComp>
</compagnie>'));


--EXTRACTIONS

--Nom de tous les pilotes
SELECT EXTRACT(c.col_clob_xml,'compagnie/pilotes/pilote/nom') 
"Nom de tous les pilotes" FROM compagnie_col_xmlschema_CLOB c;

SELECT COUNT(EXTRACT(c.col_clob_xml,'compagnie/pilotes/pilote/nom')) FROM compagnie_col_xmlschema_CLOB c;

--Dtails des deuximes pilotes
SELECT EXTRACT(c.col_clob_xml,'compagnie/pilotes/pilote[2]') 
"Deuximes pilotes"  FROM compagnie_col_xmlschema_CLOB c;

--texte / attributs
SELECT  XMLCAST(XMLQUERY(
        '$obj/compagnie/comp/text()' PASSING BY VALUE c.col_clob_xml 
  AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Code comp"
  FROM compagnie_col_xmlschema_CLOB c;

--liste des brevets
--pas terrible l'tat de sortie
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote/@brevet' 
  PASSING BY VALUE c.col_clob_xml AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Brevet"
  FROM compagnie_col_xmlschema_CLOB c;

SELECT EXTRACT(acoll.COLUMN_VALUE,'/pilote/@brevet') "Brev"
  FROM compagnie_col_xmlschema_CLOB c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.col_clob_xml) acoll;

SELECT SUM(TO_NUMBER(
       EXTRACTVALUE(acoll.COLUMN_VALUE,'/pilote/salaire'))) "Masse salariale"
  FROM compagnie_col_xmlschema_CLOB c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.col_clob_xml) acoll;

--Prdicats

--Nom du pilote de brevet PL-2
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote[@brevet="PL-2"]/nom/text()' 
  PASSING BY VALUE c.col_clob_xml AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(15)) "Nom de PL-2"
  FROM compagnie_col_xmlschema_CLOB c;

--
SELECT acoll.COLUMN_VALUE
  FROM compagnie_col_xmlschema_CLOB c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.col_clob_xml) acoll;

--
SELECT COUNT(*) "Nombre de compagnies" FROM compagnie_col_xmlschema_CLOB c
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()=5000]'
          PASSING c.col_clob_xml AS "obj");
--
SELECT
EXTRACT(c.col_clob_xml,'compagnie/comp') "comp",EXTRACT(c.col_clob_xml,'compagnie/nomComp') "nom"
  FROM compagnie_col_xmlschema_CLOB c
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()<5000]'
          PASSING c.col_clob_xml AS "obj");

SELECT EXTRACT(c.col_clob_xml,'compagnie/comp') "comp"
  FROM compagnie_col_xmlschema_CLOB c
  WHERE EXISTSNODE(c.col_clob_xml,'compagnie/pilotes/pilote/salaire[number()<5000]')=1;

SELECT acomp.colcmp,SUM(TO_NUMBER(li.sal))
  FROM compagnie_col_xmlschema_CLOB c,
   XMLTABLE('/compagnie' PASSING c.col_clob_xml
	COLUMNS colcmp VARCHAR2(6) PATH 'comp',
	        pils    XMLType     PATH 'pilotes/pilote') acomp,
   XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS sal   NUMBER PATH 'salaire') li
  GROUP BY acomp.colcmp;

---MISES A JOUR

SELECT c.cle, c.col_clob_xml.GETCLOBVAL() FROM compagnie_col_xmlschema_CLOB c;

UPDATE compagnie_col_xmlschema_CLOB c
  SET c.col_clob_xml = 
	XMLType(BFILENAME('REPXML','autrecompagnie.xml'),NLS_CHARSET_ID('AL32UTF8'))
  WHERE EXISTSNODE(c.col_clob_xml, 'compagnie/comp[text()="AB"]') = 1;

SELECT c.cle, c.col_clob_xml.GETCLOBVAL() FROM compagnie_col_xmlschema_CLOB c;

--VUES relationnelles DECONSEILLEES

DROP VIEW compagnie_detail_vue ;

CREATE VIEW compagnie_detail_vue AS
  SELECT acomp.colcmp, acomp.nomcmp, ligne.*
    FROM compagnie_col_xmlschema_CLOB c,
    XMLTABLE('/compagnie' PASSING c.col_clob_xml
	COLUMNS colcmp VARCHAR2(6)  PATH 'comp',
	        nomcmp VARCHAR2(20) PATH 'nomComp',
	        pils   XMLType      PATH 'pilotes/pilote') acomp,
    XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS brevetpil VARCHAR2(4) PATH '@brevet',
                nompil    VARCHAR2(20) PATH 'nom',
	        salpil    NUMBER PATH 'salaire') ligne;

SELECT DISTINCT v.colcmp, v.nomcmp FROM compagnie_detail_vue v;

SELECT v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  WHERE v.colcmp = 'AC';

SELECT v.colcmp, v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  ORDER BY 1,2;

SELECT v.colcmp, COUNT(v.brevetpil) "Nombre de pilotes salaris"
  FROM compagnie_detail_vue v
  WHERE v.salpil IS NOT NULL
  GROUP BY v.colcmp
  ORDER BY 1;
-----------------------------------mode non structur BINARY XML------------------

--sans grammaire 

DROP TABLE compagnie_binaryXML ;

CREATE TABLE compagnie_binaryXML OF XMLType
  XMLTYPE STORE AS BINARY XML
  VIRTUAL COLUMNS 
  (vircolcomp    AS (EXTRACTVALUE(OBJECT_VALUE,'/compagnie/comp')),
   vircolnomcomp AS (EXTRACTVALUE(OBJECT_VALUE,'/compagnie/nomComp')));

--   vircolnompil  AS (EXTRACT(OBJECT_VALUE,'/compagnie/pilotes/pilote/nom').GETSTRINGVAL()),
--   vircolbrevpil AS (EXTRACT(OBJECT_VALUE,'/compagnie/pilotes/pilote/@brevet').GETSTRINGVAL()));

SELECT TABLE_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TABLES;

INSERT INTO compagnie_binaryXML SELECT OBJECT_VALUE FROM compagnie_OR_xmlschema;

SELECT OBJECT_VALUE FROM compagnie_binaryXML ;

--Contraintes

--nom comp unique
ALTER TABLE compagnie_binaryXML ADD CONSTRAINT unnomcomp_compagnie_binaryXML UNIQUE(vircolnomcomp);

--PK 
ALTER TABLE compagnie_binaryXML ADD CONSTRAINT pk_compagnie_binaryXML PRIMARY KEY(vircolcomp);
--test
INSERT INTO compagnie_binaryXML VALUES
	(XMLType(BFILENAME('REPXML','compagnie.xml'),NLS_CHARSET_ID('AL32UTF8')));
--FK
ALTER TABLE compagnie_binaryXML 
 ADD CONSTRAINT fk_comp_binary FOREIGN KEY (vircolcomp) REFERENCES compagnie_R1(codecomp);
--test
INSERT INTO compagnie_binaryXML VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AG</comp>	
	<pilotes>
		<pilote brevet="Bug">
		   <nom>Bug</nom>
		   <salaire>10</salaire>
		</pilote>
	</pilotes>
	<nomComp>Inexistante dans la table compagnie_R1</nomComp>
</compagnie>'));


--non null ?
--ALTER TABLE compagnie_binaryXML ADD CONSTRAINT nnnomcomp_compagnie_binaryXML 
-- CHECK(vircolnomcomp IS NOT NULL);

--CHECK ?
--ALTER TABLE compagnie_binaryXML ADD CONSTRAINT 
--       cknomcomp_compagnie_binaryXML CHECK (vircolcomp LIKE 'A%' OR vircolcomp LIKE 'E%')

--non nul nom pilote  ?
--ALTER TABLE compagnie_binaryXML 
-- ADD CONSTRAINT cknompil_compagnie_binaryXML CHECK(vircolnompil IS NOT NULL);

---brevet unique ?
--ALTER TABLE compagnie_binaryXML 
--      ADD CONSTRAINT unbrevet_compagnie_binaryXML UNIQUE(vircolbrevpil);

--Ajout - drop virtual columns ??
--ALTER TABLE compagnie_binaryXML 
--   ADD vircolsalpil AS (EXTRACTVALUE(OBJECT_VALUE,'/compagnie/pilotes/pilote/salaire'));


--------------EXTRACTIONS

--Nom de tous les pilotes
SELECT EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote/nom') 
"Nom de tous les pilotes" FROM compagnie_binaryXML ;

SELECT COUNT(EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote/nom')) FROM compagnie_binaryXML ;

--Dtails des deuximes pilotes
SELECT EXTRACT(OBJECT_VALUE,'compagnie/pilotes/pilote[2]') 
"Deuximes pilotes"  FROM compagnie_binaryXML ;

--texte / attributs
SELECT  XMLCAST(XMLQUERY(
        '$obj/compagnie/comp/text()' PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Code comp"
  FROM compagnie_binaryXML ;

--liste des brevets
--pas terrible l'tat de sortie
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote/@brevet' 
  PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(9)) "Brevet"
  FROM compagnie_binaryXML ;

SELECT EXTRACTVALUE(acoll.COLUMN_VALUE,'/pilote/@brevet') "Brev"
  FROM compagnie_binaryXML c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;

SELECT SUM(TO_NUMBER(
       EXTRACTVALUE(acoll.COLUMN_VALUE,'/pilote/salaire'))) "Masse salariale"
  FROM compagnie_binaryXML c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;

--Nom du pilote de brevet PL-2
SELECT  XMLCAST(XMLQUERY('$obj/compagnie/pilotes/pilote[@brevet="PL-2"]/nom/text()' 
  PASSING BY VALUE OBJECT_VALUE AS "obj" RETURNING CONTENT) 
            AS VARCHAR2(15)) "Nom de PL-2"
  FROM compagnie_binaryXML ;

--
SELECT acoll.COLUMN_VALUE
  FROM compagnie_binaryXML c,
   XMLTABLE('/compagnie/pilotes/pilote' PASSING c.OBJECT_VALUE) acoll;
--
SELECT COUNT(*) "Nombre de compagnies" FROM compagnie_binaryXML 
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()=5000]'
          PASSING OBJECT_VALUE AS "obj");
--
SELECT
EXTRACT(OBJECT_VALUE,'compagnie/comp') "comp",EXTRACT(OBJECT_VALUE,'compagnie/nomComp') "nom"
  FROM compagnie_binaryXML 
  WHERE XMLEXISTS('$obj/compagnie/pilotes/pilote/salaire[number()<5000]'
          PASSING OBJECT_VALUE AS "obj");
--
SELECT EXTRACT(OBJECT_VALUE,'compagnie/comp') "comp"
  FROM compagnie_binaryXML 
  WHERE EXISTSNODE(OBJECT_VALUE,'compagnie/pilotes/pilote/salaire[number()<5000]')=1;
--
SELECT acomp.colcmp,SUM(TO_NUMBER(li.sal))
  FROM compagnie_binaryXML c,
   XMLTABLE('/compagnie' PASSING c.OBJECT_VALUE
	COLUMNS colcmp VARCHAR2(6) PATH 'comp',
	        pils    XMLType     PATH 'pilotes/pilote') acomp,
   XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS sal   NUMBER PATH 'salaire') li
  GROUP BY acomp.colcmp;

-----------------------------Mises  jour

UPDATE compagnie_binaryXML 
  SET OBJECT_VALUE = 
	XMLType(BFILENAME('REPXML','autrecompagnie.xml'),NLS_CHARSET_ID('AL32UTF8'))
  WHERE EXISTSNODE(OBJECT_VALUE, 'compagnie/comp[text()="AB"]') = 1;

--maj salaire

UPDATE compagnie_binaryXML 
  SET OBJECT_VALUE = 
  UPDATEXML(OBJECT_VALUE, '/compagnie/pilotes/pilote/salaire/text()', '6000')
  WHERE EXISTSNODE(OBJECT_VALUE, '/compagnie/pilotes/pilote/nom[text() = "C. Soutou"]') = 1;

UPDATE compagnie_binaryXML 
  SET OBJECT_VALUE = INSERTCHILDXML(OBJECT_VALUE,'/compagnie/pilotes','pilote', 
    XMLType('<pilote brevet="PL-5">
          <nom>L. Schneider</nom>
          <salaire>8000</salaire></pilote>'))
  WHERE EXISTSNODE(OBJECT_VALUE,
                   '/compagnie[comp="AC"]') = 1;

UPDATE compagnie_binaryXML 
  SET OBJECT_VALUE =  APPENDCHILDXML(OBJECT_VALUE,'/compagnie/pilotes/pilote[2]', 
    XMLType('<salaire>4000</salaire>'))
  WHERE EXISTSNODE(OBJECT_VALUE,'/compagnie[comp="AC"]') = 1;

UPDATE compagnie_binaryXML 
  SET OBJECT_VALUE =  DELETEXML(OBJECT_VALUE,'/compagnie/pilotes/pilote[1]')
  WHERE EXISTSNODE(OBJECT_VALUE,'/compagnie[comp="AC"]') = 1;

--VUES relationnelles

DROP VIEW compagnie_detail_vue ;
CREATE VIEW compagnie_detail_vue AS
  SELECT acomp.colcmp, acomp.nomcmp, ligne.*
    FROM compagnie_binaryXML c,
    XMLTABLE('/compagnie' PASSING c.OBJECT_VALUE
	COLUMNS colcmp VARCHAR2(6)  PATH 'comp',
	        nomcmp VARCHAR2(20) PATH 'nomComp',
	        pils   XMLType      PATH 'pilotes/pilote') acomp,
    XMLTABLE('pilote' PASSING acomp.pils
	COLUMNS brevetpil VARCHAR2(4) PATH '@brevet',
                nompil    VARCHAR2(20) PATH 'nom',
	        salpil    NUMBER PATH 'salaire') ligne;

SELECT DISTINCT v.colcmp, v.nomcmp FROM compagnie_detail_vue v;

SELECT v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  WHERE v.colcmp = 'AC';

SELECT v.colcmp, v.brevetpil, v.nompil, v.salpil
  FROM compagnie_detail_vue v
  ORDER BY 1,2;

SELECT v.colcmp, COUNT(v.brevetpil) "Nombre de pilotes salaris"
  FROM compagnie_detail_vue v
  WHERE v.salpil IS NOT NULL
  GROUP BY v.colcmp
  ORDER BY 1;

--binary XML avec grammaire ----------------------------------------


--grammaire annote sans SQLTYPE et VARCHAR2...
BEGIN
--  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/compagnies3.xsd',DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/compagnies3.xsd',
    SCHEMADOC => BFILENAME('REPXML','compagniesannotebinXML.xsd'),
    LOCAL => TRUE, GENTYPES => FALSE, 
    GENTABLES => FALSE, OPTIONS => DBMS_XMLSCHEMA.REGISTER_BINARYXML);
END;
/

DROP TABLE compagnie_binaryXML_grammaire ;

CREATE TABLE compagnie_binaryXML_grammaire OF XMLType
  XMLTYPE STORE AS BINARY XML
   XMLSCHEMA "http://www.soutou.net/compagnies3.xsd"
   ELEMENT "compagnie"
   DISALLOW NONSCHEMA
  VIRTUAL COLUMNS (vircolcomp AS (EXTRACTVALUE(OBJECT_VALUE,'/compagnie/comp')));


--respect grammaire

-- (XMLType instance).CREATESCHEMABASEDXML('http:.......') pas oprationnelle

INSERT INTO compagnie_binaryXML_grammaire 
VALUES (XMLType(BFILENAME('REPXML','compagnie.xml'),NLS_CHARSET_ID('AL32UTF8')));

INSERT INTO compagnie_binaryXML_grammaire VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
	<comp>AC</comp>	
	<pilotes>
		<pilote brevet="PL-3">
		   <nom>C. Soutou</nom>
		   <salaire>5000</salaire>
		</pilote>
		<pilote brevet="PL-4">
		   <nom>J. Marchesani</nom>
		</pilote>
	</pilotes>
	<nomComp>Castanet Lines</nomComp>
</compagnie>'));

INSERT INTO compagnie_binaryXML_grammaire VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
<comp>PasPil</comp>	
<nomComp>Elment pilotes absent</nomComp>
</compagnie>'));

--respectent pas la grammaire

INSERT INTO compagnie_binaryXML_grammaire VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>	
<pilotes></pilotes>
<nomComp>No comp!</nomComp>
</compagnie>'));

INSERT INTO compagnie_binaryXML_grammaire VALUES
(XMLType(BFILENAME('REPXML','pilote.xml'),nls_charset_id('AL32UTF8')));

INSERT INTO compagnie_binaryXML_grammaire VALUES
(XMLTYPE.CREATEXML('<?xml version="1.0" encoding="ISO-8859-1"?>
<compagnie>
 <comp>PB</comp>	
 <pilote brevet="PL-5">
     <nom>L. Schneider</nom>
     <salaire>8000</salaire>
 </pilote>
<nomComp>Manque lment pilotes</nomComp>
</compagnie>'));

DELETE FROM compagnie_binaryXML_grammaire ;

ALTER TABLE compagnie_binaryXML_grammaire 
	ADD CONSTRAINT valide_compagniebinaryXML
	CHECK (XMLIsValid(OBJECT_VALUE) = 1);

-----------------AUTRES FONCTIONNALITES---------------------------------------------------------------


--GENERATION DE CONTENUS XML

CREATE TABLE compagnie_R
(codec VARCHAR2(6) PRIMARY KEY, nomCompa VARCHAR2(30)); 

CREATE TABLE avion_R
(na CHAR(6), typav VARCHAR(6), capacite NUMBER(3), proprio VARCHAR2(6), 
CONSTRAINT pk_avion PRIMARY KEY(na), 
CONSTRAINT fk_avion_comp FOREIGN KEY(proprio)
		REFERENCES  compagnie_R(codec),
CONSTRAINT ck_cap_avion CHECK (capacite BETWEEN 50 AND 500));

CREATE TABLE affreter_R
(na CHAR(6), codec VARCHAR(6),date_a DATE,nb_passagers NUMBER,
CONSTRAINT pk_affreter PRIMARY KEY (na, codec, date_a),
CONSTRAINT fk_affreter_na FOREIGN KEY(na)
		REFERENCES avion_R(na),
CONSTRAINT fk_affreter_comp FOREIGN KEY(codec)
		REFERENCES  compagnie_R(codec),
CONSTRAINT ck_nb_p CHECK (nb_passagers BETWEEN 0 AND 500));


INSERT INTO compagnie_R VALUES ('AF','Air France');
INSERT INTO compagnie_R VALUES ('EJ','Easy Jet');
INSERT INTO compagnie_R VALUES ('AB','Air Blagnac');
--
INSERT INTO avion_R	VALUES ('F-GODF','A320',170,'AB');
INSERT INTO avion_R	VALUES ('F-PROG','A318',140,'AF');
INSERT INTO avion_R	VALUES ('F-WOWW','A380',490,'EJ');
--
INSERT INTO affreter_R	VALUES ('F-GODF','EJ','08-12-2007',120);
INSERT INTO affreter_R	VALUES ('F-GODF','AF','08-12-2007',150);
INSERT INTO affreter_R	VALUES ('F-PROG','AF','08-12-2007',130);
INSERT INTO affreter_R	VALUES ('F-PROG','AF','09-12-2007',110);
-- 
SELECT * FROM compagnie_R ;
SELECT * FROM avion_R	;
SELECT na,codec,to_char(date_a,'DD-MM-YYYY') "DATE_A", nb_passagers FROM affreter_R;
--
SELECT XMLElement
       ("Affretement",
         XMLAttributes(c.codec AS "comp"),
	 XMLForest(c.nomCompa AS "nomComp"), 
         XMLElement
           ( "Vols",
             (SELECT XMLAgg(XMLElement( "Vol",
                       XMLForest(TO_CHAR(af.date_a,'DD/MM/YYYY') AS "date", 
				av.typav        AS "avion", 
                                af.nb_passagers AS "passagers")))
              FROM  affreter_R	af, avion_R av
              WHERE af.codec = c.codec
	      AND   av.na   = af.na
              )
           )
         ) AS "Contenu_XML"
  FROM compagnie_R c
  ORDER BY nomCompa;

--Vues XMLType
DROP VIEW compagnie_xml;
CREATE VIEW compagnie_xml OF XMLType
  WITH OBJECT ID (SUBSTR(EXTRACTVALUE(OBJECT_VALUE,'/Affretement/nomComp'),1,30))
  AS SELECT XMLElement
       ("Affretement",
         XMLAttributes(c.codec AS "comp"),
	 XMLForest(c.nomCompa AS "nomComp"), 
         XMLElement
           ( "Vols",
             (SELECT XMLAgg(XMLElement( "Vol",
                       XMLForest(TO_CHAR(af.date_a,'DD/MM/YYYY') AS "date", 
				av.typav        AS "avion", 
                                af.nb_passagers AS "passagers")))
              FROM  affreter_R	af, avion_R av
              WHERE af.codec = c.codec
	      AND   av.na   = af.na
              )
           )
         ) AS "Contenu_XML"
  FROM compagnie_R c
  ORDER BY nomCompa;

DESC compagnie_xml;

SELECT COUNT(OBJECT_VALUE) FROM compagnie_xml ;

SELECT OBJECT_VALUE FROM compagnie_xml 
  WHERE EXISTSNODE(OBJECT_VALUE,'/Affretement[@comp="EJ"]') = 1;


--avec sys_XMLGen

DROP TYPE affreter_type;

CREATE TYPE affreter_type AS OBJECT 
("@na" CHAR(6), codec VARCHAR(6), date_a DATE, nb_passagers NUMBER);
/

DROP VIEW affreter_view_xml ;
CREATE VIEW affreter_view_xml OF XMLType
  WITH OBJECT ID (EXTRACT(OBJECT_VALUE, '/Affetement/@na').GETNUMBERVAL()) AS
  SELECT SYS_XMLGEN(affreter_type(a.na, a.codec, a.date_a, a.nb_passagers),XMLFORMAT('Affretement'))
       FROM affreter_R	a
       WHERE a.nb_passagers > 110;
 
SELECT * FROM affreter_view_xml ;

SELECT OBJECT_VALUE  FROM affreter_view_xml 
WHERE EXISTSNODE(OBJECT_VALUE,'Affretement/CODEC[text()="EJ"]') = 1;


--avec grammaire sans collection

BEGIN
 -- DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/Avioncomps.xsd',
 --            DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/Avioncomps.xsd',
    SCHEMADOC => BFILENAME('REPXML','Avioncomps.xsd'),
    LOCAL => TRUE,    GENTYPES => TRUE,    GENTABLES => FALSE,  
    CSID =>      NLS_CHARSET_ID('AL32UTF8'));
END;
/

CREATE VIEW avicomp_view_xml OF XMLType 
  XMLSCHEMA "http://www.soutou.net/Avioncomps.xsd" ELEMENT "avioncomp"
   WITH OBJECT ID (EXTRACT(OBJECT_VALUE,   
                           '/AvionComp/@immat').GETNUMBERVAL()) AS 
   SELECT XMLElement
       ("AvionComp",
         XMLAttributes(av.na AS "immat"),
	 XMLForest(av.typav AS "nomav",av.capacite AS "nbplaces"),
         XMLElement
           ("compav",XMLForest(c.codec AS "comp", c.nomcompa AS "nomcomp")))
  FROM avion_R av, compagnie_R c
  WHERE av.proprio = c.codec;


SELECT OBJECT_VALUE FROM avicomp_view_xml;

--PAS FAIT
--avec grammaire avec collection
--annotation grammaire !

BEGIN
--  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.soutou.net/AvionComp.xsd',
--             DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
  DBMS_XMLSCHEMA.REGISTERSCHEMA(
    SCHEMAURL => 'http://www.soutou.net/Affretements.xsd',
    SCHEMADOC => BFILENAME('REPXML','Affretements.xsd'),
    LOCAL => TRUE,    GENTYPES => TRUE,    GENTABLES => FALSE,  
    CSID =>      NLS_CHARSET_ID('AL32UTF8'));
END;
/

SELECT OBJECT_VALUE AS RESULT FROM emp_simple_xml WHERE ROWNUM < 2;

--------------Gnration de grammaire


DROP TYPE adresse_type ;
DROP TYPE societe_type;

CREATE TYPE adresse_type AS OBJECT
 (nrue CHAR(3), nomrue VARCHAR2(20), ville VARCHAR2(20))
/
CREATE TYPE societe_type AS OBJECT
 (siret VARCHAR2(15), creation DATE, 
  adresse_t adresse_type, effectif NUMBER)
/

SELECT DBMS_XMLSCHEMA.GENERATESCHEMA('SOUTOU','SOCIETE_TYPE') FROM DUAL;

------------------------------------Dico donnes

COL ANYSCHEMA FORMAT A10 HEADING "Any schema"
COL NONSCHEMA FORMAT A10 HEADING "Non schema"

DESC USER_XML_TABLES;


SELECT TABLE_NAME FROM USER_TABLES;

SELECT TABLE_NAME, XMLSCHEMA, STORAGE_TYPE FROM USER_XML_TABLES;

SELECT TABLE_NAME, ELEMENT_NAME, ANYSCHEMA,NONSCHEMA  FROM USER_XML_TABLES;


SELECT TABLE_NAME, COLUMN_NAME, STORAGE_TYPE FROM USER_XML_TAB_COLS ;

SELECT COLUMN_NAME, XMLSCHEMA, ELEMENT_NAME,STORAGE_TYPE FROM USER_XML_TAB_COLS ;


DESC USER_XML_SCHEMAS;

SELECT SCHEMA_URL, LOCAL, BINARY FROM USER_XML_SCHEMAS;


DESC USER_XML_VIEWS;

SELECT VIEW_NAME, XMLSCHEMA, ELEMENT_NAME FROM USER_XML_VIEWS;

----