---Projection

CREATE TABLE Pilote
	(brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
	 nom VARCHAR(16), nbHVol NUMBER(7,2), compa CHAR(4));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez', 0, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle', NULL, 'AF');

SELECT * FROM Pilote;

--col

SELECT compa, brevet FROM Pilote;

--alias

SELECT compa AS c1, nom AS NometPrnom, brevet c3 FROM Pilote;

SELECT aliasDesPilotes.compa AS c1, aliasDesPilotes.nom FROM Pilote aliasDesPilotes;

--duplicatas

SELECT compa FROM Pilote;

SELECT DISTINCT(compa) FROM Pilote;

SELECT DISTINCT compa FROM Pilote;

SELECT UNIQUE(compa) FROM Pilote;

SELECT UNIQUE compa FROM Pilote;

--expression


SELECT brevet, nbHVol, nbHVol*nbHVol AS auCarr, 10*nbHVol+5/2 FROM Pilote;

--null

SELECT brevet, nbHVol FROM Pilote;

--odrer

SELECT brevet, nom FROM Pilote ORDER BY nom;

SELECT brevet,nbHVol FROM Pilote ORDER BY nbHvol DESC NULLS LAST;

--concatnation

SELECT brevet, nom||' vole pour '||compa AS "Embauche" FROM Pilote;

-- ROWID 

SELECT ROWID, brevet, nom FROM Pilote;

--insertion multilignes

CREATE TABLE NomsetHVoldesPilotes 
	AS SELECT nom, nbHVol, compa FROM Pilote;
SELECT ROWID, p.* FROM NomsetHVoldesPilotes p;


--autre possibilit

DROP TABLE NomsetHVoldesPilotes ;
CREATE TABLE NomsetHVoldesPilotes 
	(nom VARCHAR(16), nbHVol NUMBER(7,2), compa CHAR(4));
INSERT INTO NomsetHVoldesPilotes 
	SELECT nom, nbHVol, compa FROM Pilote;
SELECT ROWID, p.* FROM NomsetHVoldesPilotes p;
DROP TABLE NomsetHVoldesPilotes ;

--ROWNUM

SELECT ROWNUM, brevet, nom FROM Pilote;


DROP TABLE Pilote;
