--

SET SERVEROUTPUT ON

CREATE TABLE Compagnie
	(comp VARCHAR2(4), nrue NUMBER(3), rue VARCHAR2(20), ville VARCHAR2(15), nomComp VARCHAR2(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), nbHVol NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Compagnie	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie   VALUES ('CAST', 1, 'G. Brassens', 'Blagnac', 'Castanet AL');

INSERT INTO Pilote VALUES ('PL-4', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-1', 'Pierre Lamothe', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Thierry Albaric', 900, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Christian Soutou', 1000, 'SING');
commit;

SELECT * FROM Pilote;
SELECT * FROM Compagnie;
--
VARIABLE g_nom CHAR(20);
DECLARE
   rty_pilote  Pilote%ROWTYPE;
   v_compa     Pilote.compa%TYPE;
BEGIN
--charger l'enreg
 SELECT *      INTO rty_pilote FROM Pilote WHERE brevet='PL-1';
 SELECT compa  INTO v_compa    FROM Pilote WHERE brevet='PL-2';
 SELECT nom    INTO :g_nom     FROM Pilote WHERE brevet='PL-2';
END;
/
PRINT g_nom

--fct
--mono
DECLARE 
   v_nomEnMAJUSCULES Pilote.nom%TYPE;  
BEGIN 
SELECT UPPER(nom) INTO v_nomEnMAJUSCULES
  FROM Pilote WHERE brevet = 'PL-1';
END;
/

--multi
VARIABLE g_plusGrandHVol NUMBER;
DECLARE   
BEGIN 
SELECT MAX(nbHVol) INTO :g_plusGrandHVol 
  FROM Pilote;
END;
/
PRINT g_plusGrandHVol 

--manips

--insert
DECLARE
   rty_pilote  Pilote%ROWTYPE;
   v_brevet    Pilote.brevet%TYPE;
BEGIN
  INSERT INTO Pilote VALUES ('PL-5', 'Jos Bov', 500, 'AF');
  v_brevet := 'PL-6';   
  INSERT INTO Pilote VALUES (v_brevet, 'Richard Virenque', 100, 'AF');
  rty_pilote.brevet := 'PL-7';
  rty_pilote.nom    := 'Serge Miranda';
  rty_pilote.nbHVol :=  1340.90;
  rty_pilote.compa  := 'AF';
  INSERT INTO Pilote (brevet, nom, nbHVol, compa)
   VALUES (rty_pilote.brevet , rty_pilote.nom, rty_pilote.nbHVol, rty_pilote.compa);
 END;
/
SELECT * FROM Pilote;

--update
DECLARE					
  v_dureVol NUMBER(3,1) := 4.8;   
BEGIN
  UPDATE Pilote SET nbHVol= nbHVol + v_dureVol WHERE brevet= 'PL-6';
--
  UPDATE Pilote SET nbHVol= nbHVol + 10 WHERE  compa = 'AF';
END;
/
SELECT * FROM Pilote;

--delete
DECLARE					
  v_hVolMini NUMBER(4) := 1000;   
BEGIN
  DELETE FROM Pilote WHERE nbHVol < v_hVolMini;
--rowcount
  DELETE FROM Pilote WHERE brevet = '$*';
END;
/
SELECT * FROM Pilote;
ROLLBACK;

--Curseurs implicites
ROLLBACK;

VARIABLE g_pilotesAFDtruits NUMBER
BEGIN  
  DELETE FROM Pilote WHERE compa = 'AF';
  :g_pilotesAFDtruits  := SQL%ROWCOUNT;
END;
/
PRINT g_pilotesAFDtruits
ROLLBACK;

---dbms_output
--putline

SET SERVEROUTPUT ON
--BLoc PL/SQL
DECLARE
  v_nbrPil NUMBER;
BEGIN
  DBMS_OUTPUT.ENABLE;
  DBMS_OUTPUT.PUT_LINE('Nous sommes le  : ' || SYSDATE);
  DBMS_OUTPUT.PUT_LINE('La racine de 2 = ' || SQRT(2));
  SELECT COUNT(*) INTO v_nbrPil FROM Pilote;
  DBMS_OUTPUT.PUT_LINE('Il y a ' || v_nbrPil || ' pilotes dans la table');
END;
/

BEGIN
  DBMS_OUTPUT.DISABLE;
  DBMS_OUTPUT.PUT_LINE('Rien ne peut s''afficher');
END;
/
-- getline

CREATE TABLE trace (ligne VARCHAR2(255));

SET SERVEROUTPUT ON
DECLARE
  v_nbrPil     NUMBER;
  v_ligne      VARCHAR2(255);
  v_rsultat   INTEGER;
BEGIN
  DBMS_OUTPUT.ENABLE;
  SELECT COUNT(*) INTO v_nbrPil FROM Pilote;
  DBMS_OUTPUT.PUT_LINE('Premiere ligne');
  DBMS_OUTPUT.PUT_LINE('Il y a ' || v_nbrPil || ' pilotes dans la table');
  DBMS_OUTPUT.GET_LINE(v_ligne, v_rsultat);
  IF (v_rsultat = 0) THEN
     INSERT INTO trace VALUES(v_ligne);
  ELSE
     INSERT INTO trace VALUES('Aucune ligne dans le buffer');
  END IF;
 END;
/

SELECT * FROM TRACE;

--getlines

DECLARE
  tab DBMS_OUTPUT.CHARARR;
  v_resultat  INTEGER := 3;
  v_nbrPil    NUMBER;
BEGIN
  SELECT COUNT(*) INTO v_nbrPil FROM Pilote;
  DBMS_OUTPUT.PUT_LINE('Premire ligne');
  DBMS_OUTPUT.PUT_LINE('Deuxime ligne');
  DBMS_OUTPUT.PUT_LINE('Il y a ' || v_nbrPil || ' pilotes dans la table');
  DBMS_OUTPUT.PUT_LINE('Quatrime ligne');
  DBMS_OUTPUT.GET_LINES(tab, v_resultat);

  FOR v_entier IN 1 ..v_resultat LOOP
     DBMS_OUTPUT.PUT_LINE ('Ligne ' || v_entier || tab(v_entier));
  END LOOP;    
  
 END;
/


DROP TABLE trace;
DROP TABLE Pilote;
DROP TABLE Compagnie;

