
---Manipulation des donnes

DROP TABLE Pilote;
DROP TABLE Compagnie;


CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT nn_nom    CHECK (nom IS NOT NULL),
	 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
	 CONSTRAINT un_nom    UNIQUE (nom),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
--DEFAULT explicite
INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');
--NULL explicite
INSERT INTO Compagnie
	VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');


--utilise DEFAULT implicite
INSERT INTO Compagnie(comp, nrue, rue, nomComp)
	VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');
--NULL sur nrue implicite
INSERT INTO Compagnie(comp, rue, ville, nomComp)
	VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');




INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');


--pk
INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');

--
INSERT INTO Pilote
 VALUES ('NomNul', NULL, 450, 'AF');

--
INSERT INTO Pilote
 VALUES ('PbHvol', 'Trop vol!', 20000.01, 'AF');

INSERT INTO Pilote
 VALUES ('Unique', 'Amlie Sulpice', 450, 'AF');

INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'TOTO');

SELECT * FROM Pilote;
SELECT * FROM Compagnie;

DROP TABLE Pilote;
DROP TABLE Compagnie;

---Dates

DROP TABLE Pilote;
CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATE, nbHVol NUMBER(7,2),
         dateEmbauche DATE, compa VARCHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote
	VALUES ('PL-10', 'Christian Soutou', '05-02-65', 900, SYSDATE, 'AF');

INSERT INTO Pilote
	VALUES ('PL-10a', 'Christian Soutou', '05-02-1965', 900, SYSDATE, 'AF');

INSERT INTO Pilote
	VALUES ('PL-10b', 'Christian Soutou', '05/02/65', 900, SYSDATE, 'AF');

INSERT INTO Pilote
	VALUES ('PL-10c', 'Christian Soutou', TO_DATE ('Fvrier 5, 1965', 'MONTH DD, YYYY') ,
	 900, SYSDATE, 'AF');

INSERT INTO Pilote
	VALUES ('PL-10d', 'Christian Soutou', TO_DATE ('5 Fvrier 1965', 'DD MONTH YYYY') ,
	 900, SYSDATE, 'AF');

INSERT INTO Pilote
	VALUES ('PL-10e', 'Christian Soutou', TO_DATE ('5 02 1965', 'DD MM YYYY') ,
	 900, SYSDATE, 'AF');

SELECT * FROM Pilote;

'05-02-65'
'05-02-1965'
'05/02/65'
 TO_DATE ('Fvrier 5, 1965', 'MONTH DD, YYYY') 
TO_DATE ('5 Fvrier 1965', 'DD MONTH YYYY')
TO_DATE ('5 02 1965', 'DD MM YYYY') 

DROP TABLE Pilote;

SELECT TO_DATE('05-02-1965:06:30','DD-MM-YYYY:HH24:MI') FROM DUAL;

--
DROP TABLE MmesvnementNol;
CREATE TABLE MmesvnementNol (colonne CHAR);
----


CREATE TABLE Evnements
	(arriv TIMESTAMP, arrivLocalement TIMESTAMP WITH TIME ZONE);

NLS_TIME_TZ_FORMAT
NLS_TIMESTAMP_FORMAT 'YYYY-MM-DD HH:MM:SS.d' d : dcimales
NLS_TIMESTAMP_TZ_FORMAT 'YYYY-MM-DD HH:MM:SS.d x 02:00' x + ou - par rapport  Greenwitch

INSERT INTO Evnements
	VALUES (TIMESTAMP '1965-02-05 09:30:02.12345', TIMESTAMP '1965-01-16 12:30:05.98 + 4:30');
DROP TABLE Evnements;


CREATE TABLE Dures
	(dureAnnesMois INTERVAL YEAR TO MONTH, dureJourSecondes INTERVAL DAY TO SECOND);

INSERT INTO Dures
	VALUES ('1-7', '5 15:13:56.97');

DROP TABLE Dures;

SELECT CURRENT_DATE, LOCALTIMESTAMP, SYSTIMESTAMP, DBTIMEZONE, SESSIONTIMEZONE FROM DUAL;

----NCHAR




DROP TABLE CaractresUnicode;

CREATE TABLE CaractresUnicode (unCHARde15 CHAR(15), unNCHARde1 NCHAR(1));


SELECT UNISTR('\0345') FROM DUAL;

INSERT INTO CaractresUnicode VALUES('Quid Espagnol',UNISTR('\0345'));

INSERT INTO CaractresUnicode VALUES('Quid Toulousain', N'?');

SELECT * FROM CaractresUnicode;



Quid Espagnol 
SQL> SELECT * FROM ex_nchar WHERE col2 LIKE N'%%';

COL1                 COL2
-------------------- ----------
Enregistrement 2 :   |


DROP TABLE CaractresUnicode;

---------BLOB


--sous SYSTEM
connect system/manager@cxbdsoutou

GRANT CREATE ANY DIRECTORY TO soutou;

connect soutou/ingres@cxbdsoutou

CREATE TABLE Trombinoscope (nomEtudiant VARCHAR(30), photo BFILE);

CREATE DIRECTORY repertoire_etudiants AS 'D:\PhotosEtudiant';

INSERT INTO Trombinoscope
   VALUES ('Soutou', BFILENAME('repertoire_etudiants', 'photoCS.jpg'));

--pas de contrle ni d'existence ni si le rpertoire ou le fichier est supprim
INSERT INTO Trombinoscope
   VALUES ('Soutou', BFILENAME('repertoire_etudiants', 'ttt.jpg'));

DROP TABLE Trombinoscope;



---UPDATE
DROP TABLE Compagnie;
CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));


INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
--DEFAULT explicite
INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');
--NULL explicite
INSERT INTO Compagnie
	VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');


--utilise DEFAULT implicite
INSERT INTO Compagnie(comp, nrue, rue, nomComp)
	VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');
--NULL sur nrue implicite
INSERT INTO Compagnie(comp, rue, ville, nomComp)
	VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');


SELECT * FROM Compagnie;

UPDATE  Compagnie
	SET nrue = 50
	WHERE comp = 'AN1';


SELECT * FROM Compagnie;

UPDATE  Compagnie
	SET nrue = 14, ville = DEFAULT
	WHERE comp = 'AN2';

SELECT * FROM Compagnie WHERE comp = 'AN2';


CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT nn_nom    CHECK (nom IS NOT NULL),
	 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
	 CONSTRAINT un_nom    UNIQUE (nom),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');



--pk
UPDATE  Pilote
	SET   brevet = 'PL-2' WHERE brevet = 'PL-1';

--nn
UPDATE  Pilote
	SET nom = NULL WHERE brevet = 'PL-1';

--ck
UPDATE  Pilote
	SET  nbHVol= 20000.01 WHERE brevet = 'PL-1';

--un
UPDATE  Pilote
	SET nom= 'Paul Soutou' WHERE brevet = 'PL-1';

--fk
UPDATE  Pilote
	SET compa = 'TOTO' WHERE brevet = 'PL-1';

SELECT * FROM Pilote;

UPDATE  Pilote
	SET compa = 'SING' WHERE brevet = 'PL-2';

UPDATE  Pilote
	SET brevet = 'PL3bis' WHERE brevet = 'PL-3';
SELECT * FROM Pilote;

--maj pk du pre pas possible
UPDATE  Compagnie
	SET comp = 'SIN2'
	WHERE comp = 'SING';


DROP TABLE Pilote;
DROP TABLE Compagnie;


---dates

DROP TABLE Pilote;
CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATE, dernierVol DATE,
	 dateEmbauche DATE, prochainVolControle DATE, nombreJoursNaisBoulot NUMBER,
	 intervalleNaisBoulot       INTERVAL DAY(7) TO SECOND(3), 
	 intervalleVolExterieur     INTERVAL DAY(2) TO SECOND(0),
	 intervalleEntreVols        INTERVAL DAY(2) TO SECOND(2),
	 intervalleEmbaucheControle INTERVAL DAY(2) TO SECOND(1),
	 compa VARCHAR(4), CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote
	VALUES ('PL-1', 'Thierry Albaric', '25-03-1967', '10-04-2003', SYSDATE, 
	TO_DATE('13-05-2003 15:30:00','DD:MM:YYYY HH24:MI:SS'), NULL, NULL, NULL, NULL, NULL, 'AF');

--et le thme astral...
UPDATE  Pilote
	SET dateNaiss = TO_DATE('25-03-1967 12:35:00', 'DD:MM:YYYY HH24:MI:SS') 
	WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateNaiss,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

--revenez la semaine prochaine + 10minutes , on vous crira srement d'ici l
UPDATE  Pilote
	SET dateEmbauche = dateEmbauche+7+(10/(24*60))  WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT dateEmbauche-dateNaiss FROM Pilote;

--Attendre avant la premire paye
UPDATE  Pilote
	SET nombreJoursNaisBoulot = dateEmbauche-dateNaiss WHERE brevet = 'PL-1';


SELECT nombreJoursNaisBoulot  FROM Pilote;

--au format intervalle

UPDATE  Pilote
	SET intervalleNaisBoulot = NUMTODSINTERVAL(dateEmbauche-dateNaiss,'DAY'),
             intervalleEntreVols = NUMTODSINTERVAL(prochainVolControle-dernierVol,'DAY'),
		intervalleVolExterieur =  NUMTODSINTERVAL(dateEmbauche-dernierVol,'DAY')
	 WHERE brevet = 'PL-1';

SELECT intervalleNaisBoulot FROM Pilote;

--au format intervalle entre vol

SELECT intervalleEntreVols FROM Pilote;


--intervalleVolExterieur     

SELECT intervalleVolExterieur FROM Pilote;

--intervalleEmbaucheControle     
UPDATE  Pilote
SET intervalleEmbaucheControle =   intervalleEntreVols - intervalleVolExterieur
	 WHERE brevet = 'PL-1';

SELECT intervalleEmbaucheControle FROM Pilote;


TO_CHAR ( colonneDate [, format , ['NLS_DATE_LANGUAGE = Langue'] ] )

SELECT TO_CHAR(dateNaiss ,'J')  FROM Pilote;

SELECT TO_CHAR(dateNaiss ,'DAY - MONTH - YEAR')  FROM Pilote;

SELECT TO_CHAR(dateEmbauche ,'DDD')  FROM Pilote;

Using Julian Dates
A Julian date is the number of days since January 1, 4712 bc. Julian dates allow continuous dating from a common reference. You can use the date format model "J" with date functions TO_DATE and TO_CHAR to convert between Oracle DATE values and their Julian equivalents.


TO_DATE ( chaineCaractres [, format , ['NLS_DATE_LANGUAGE = Langue'] ] )


SELECT TO_DATE('May 13, 1995, 12:30 A.M.','MONTH DD, YYYY, HH:MI A.M.','NLS_DATE_LANGUAGE = American')
     FROM DUAL;

SELECT TO_DATE('13 Mai, 1995, 12:30','DD MONTH, YYYY, HH24:MI','NLS_DATE_LANGUAGE = French')
     FROM DUAL;

EXTRACT 

EXTRACT ( {YEAR | MONTH | DAY | HOUR | MINUTE | SECOND} FROM { expressionDATE | expressionINTERVAL })

SELECT EXTRACT(DAY FROM intervalleVolExterieur) FROM Pilote;
SELECT EXTRACT(MONTH FROM dateNaiss) FROM Pilote;


NUMTOYMINTERVAL (expression, { 'YEAR' | 'MONTH' } )
NUMTOYMINTERVAL converts number n to an INTERVAL YEAR TO MONTH

SELECT NUMTOYMINTERVAL (1.54, 'YEAR') FROM DUAL;

SELECT NUMTOYMINTERVAL (1.54, 'MONTH') FROM DUAL;


NUMTODSINTERVAL (expression, { 'DAY' | 'HOUR' | 'MINUTE' | 'SECOND' } )
NUMTODSINTERVAL converts expression to an INTERVAL DAY TO SECOND 

SELECT NUMTODSINTERVAL(1.54,'DAY') FROM DUAL;

SELECT NUMTODSINTERVAL(1.54,'HOUR') FROM DUAL;


DROP TABLE Pilote;

-----DELETE


CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), 
	rue CHAR(20), ville CHAR(15) DEFAULT 'Paris', nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT nn_nom    CHECK (nom IS NOT NULL),
	 CONSTRAINT ck_nbHVol CHECK (nbHVol BETWEEN 0 AND 20000),
	 CONSTRAINT un_nom    UNIQUE (nom),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
--DEFAULT explicite
INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', DEFAULT, 'Air France');
--NULL explicite
INSERT INTO Compagnie
	VALUES ('AN1', NULL, 'Hoche', 'Blagnac', 'Air Nul1');


--utilise DEFAULT implicite
INSERT INTO Compagnie(comp, nrue, rue, nomComp)
	VALUES ('AC', 8, 'Champs Elyses', 'Castanet Air');
--NULL sur nrue implicite
INSERT INTO Compagnie(comp, rue, ville, nomComp)
	VALUES ('AN2', 'Foch', 'Blagnac', 'Air Nul2');


SELECT * FROM Compagnie;

INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

SELECT * FROM Pilote;
SELECT * FROM Compagnie;

DELETE FROM Pilote WHERE compa = 'AF';

DELETE Compagnie WHERE comp = 'AF';

DELETE FROM Compagnie WHERE comp = 'SING';


DROP TABLE Pilote;
DROP TABLE Compagnie;

