
-- DBMS_XMLGEN

SELECT af.na, af.codec, to_char(af.date_a,'DD-MM-YYYY') AS date_vol, 
       (av.capacite - af.nb_passagers) AS nb_places
FROM   affreter_R af, avion_R av
WHERE  af.na = av.na
ORDER BY date_vol, af.na;

set serverout on

DECLARE
   v_xmltype XMLTYPE;
   v_varchar2 varchar2(1000);
   v_ctx     DBMS_XMLGEN.ctxhandle;
BEGIN
   v_ctx := DBMS_XMLGEN.newcontext(
    'SELECT af.na AS "immat", af.codec AS "comp", 
            TO_CHAR(af.date_a,''DD-MM-YYYY'') AS "date_vol", 
            (av.capacite - af.nb_passagers)   AS "nb_places"
     FROM   affreter_R af, avion_R av
     WHERE  af.na = av.na
     ORDER BY "date_vol", "immat"');
   DBMS_XMLGEN.setrowsettag(v_ctx, 'vols'); 
   DBMS_XMLGEN.setrowtag(v_ctx, 'vol');

   v_xmltype := DBMS_XMLGEN.getXmlType(v_ctx) ;
   DBMS_OUTPUT.PUT_LINE('nbre lignes : '||DBMS_XMLGEN.GETNUMROWSPROCESSED(v_ctx));

   DBMS_XMLGEN.closeContext(v_ctx);
   DBMS_OUTPUT.PUT_LINE(v_xmltype.getClobVal);

SELECT XMLSERIALIZE (DOCUMENT v_xmltype AS VARCHAR2(1000) NO INDENT) 
into v_varchar2 from dual;

   DBMS_OUTPUT.PUT_LINE(v_varchar2);
END;
/


--  DBMS_XMLSTORE

ALTER SESSION SET NLS_DATE_FORMAT = 'DD-MM-YYYY';

DROP TABLE pils;

CREATE TABLE pils(num NUMBER(4), nom VARCHAR2(20), date_nais DATE);

DECLARE
 v_insCtx DBMS_XMLSTORE.ctxType;
 v_rows   NUMBER;
 v_xml    CLOB := '<ROWSET>
                   <ROW>
                     <num>101</num><nom>Roche</nom><date_nais>31-12-1986</date_nais>
                   </ROW>
                   <ROW>
                     <NUM>401</NUM><NOM>Alquie</NOM>
                   </ROW>
                   <ROW>
                     <NUM mail="asayag@orange.fr">801</NUM>
                     <NOM>Sayag</NOM>
                     <DATE_NAIS>30-12-1988</DATE_NAIS>
                   </ROW>
                   <ROW>
                     <NUM>901</NUM>
                     <NOM>Levade</NOM>
                     <DATE_NAIS></DATE_NAIS>
                  </ROW>
                  </ROWSET>';
BEGIN
  v_insCtx := DBMS_XMLSTORE.newContext('pils');
  DBMS_XMLSTORE.setUpdateColumn(v_insCtx, 'NUM');
  DBMS_XMLSTORE.setUpdateColumn(v_insCtx, 'NOM');
  DBMS_XMLSTORE.setUpdateColumn(v_insCtx, 'DATE_NAIS');
  v_rows := DBMS_XMLSTORE.insertXML(v_insCtx, v_xml);
  DBMS_OUTPUT.PUT_LINE('Lignes insres : ' || v_rows);
  DBMS_XMLSTORE.closeContext(v_insCtx);
END;
/

-- 

SELECT ROWNUM, num, nom, date_nais FROM pils;

-- deletexml

DECLARE
 v_insCtx DBMS_XMLSTORE.ctxType;
 v_rows   NUMBER;
 v_xml    CLOB := '<ROWSET>
                   <ROW>
                     <NUM>101</NUM>             
                     <NOM>V. Sigude</NOM>
                     <mail/>
                   </ROW>
                   <ROW>
                     <NUM>901</NUM>             
                     <NOM>T. Nielsen</NOM>
                   </ROW>
                  </ROWSET>';
BEGIN
  v_insCtx := DBMS_XMLSTORE.newContext('oxm.pils');
  DBMS_XMLSTORE.setUpdateColumn(v_insCtx, 'NUM');
  DBMS_XMLSTORE.setUpdateColumn(v_insCtx, 'NOM');
  v_rows := DBMS_XMLSTORE.deleteXML(v_insCtx, v_xml);
  DBMS_OUTPUT.PUT_LINE('Lignes supprimes : ' || v_rows);
  DBMS_XMLSTORE.closeContext(v_insCtx);
END;
/


SELECT ROWNUM, num, nom FROM pils;

DROP TABLE pils;


-- DBMS_XMLPARSER


CREATE OR REPLACE DIRECTORY REP_LOB_DIR AS 'C:\temp\lobs';

-- mettre  cv2.doc et compagnie.xml dans dans C:\temp\lobs

DROP TABLE table_CLOB purge; 

CREATE TABLE table_CLOB (num NUMBER, fic VARCHAR2(40), texte CLOB);

CREATE OR REPLACE PROCEDURE insere_lob(p1 IN NUMBER, p2 IN VARCHAR2) AS
  dest_CLOB    CLOB;
  source_BFILE  BFILE := BFILENAME('REP_LOB_DIR', p2);
BEGIN 
 INSERT INTO table_CLOB VALUES(p1, p2, EMPTY_CLOB())
        RETURNING texte INTO dest_CLOB;
 DBMS_LOB.OPEN(source_BFILE, DBMS_LOB.FILE_READONLY);
 DBMS_LOB.LOADFROMFILE(
          DEST_LOB => dest_CLOB,
          SRC_LOB  => source_BFILE,
          AMOUNT   => DBMS_LOB.GETLENGTH(source_BFILE));
 DBMS_LOB.CLOSE(source_BFILE);
 COMMIT;
END;
/

--

EXEC insere_lob (1, 'compagnie.xml');
EXEC insere_lob (2, 'cv2.doc');


CREATE OR REPLACE PROCEDURE parse_clob(p1 IN NUMBER) AS
    v_clob     CLOB;
    v_nomfic   VARCHAR2(40);
    v_parser   DBMS_XMLPARSER.parser;
    v_domdoc DBMS_XMLDOM.DOMDocument;
    v_node   DBMS_XMLDOM.DOMNode;
    mauvais_format_XML EXCEPTION;
    PRAGMA EXCEPTION_INIT(mauvais_format_XML,-31011);
BEGIN
 SELECT texte,fic INTO v_clob,v_nomfic FROM table_CLOB WHERE num = p1;
  v_parser := DBMS_XMLPARSER.newParser;
  DBMS_XMLPARSER.PARSECLOB(p => v_parser , doc => v_clob);

  v_domdoc := DBMS_XMLPARSER.getDocument(v_parser);
  v_node   := DBMS_XMLDOM.makeNode(v_domdoc);

  DBMS_XMLPARSER.freeParser(p => v_parser);
  DBMS_OUTPUT.PUT_LINE('Format XML correct : ' || v_nomfic);
EXCEPTION
   WHEN mauvais_format_XML THEN
     DBMS_OUTPUT.PUT_LINE('Probleme format XML : ' || v_nomfic);
END;
/
show err


EXEC parse_clob(1);
EXEC parse_clob(2);

-- DBMS_XSLPROCESSOR

CREATE OR REPLACE DIRECTORY repxsl AS 'C:\***';

DECLARE
    v_domdoc        DBMS_XMLDOM.domdocument;
    v_xsltdomdoc    DBMS_XMLDOM.domdocument;
    v_xsl           DBMS_XSLPROCESSOR.stylesheet;
    v_resultdomfrag DBMS_XMLDOM.domdocumentfragment;
    v_resultnode    DBMS_XMLDOM.domnode;
    v_procxsl       DBMS_XSLPROCESSOR.processor;
    buf varchar2(2000);
BEGIN
    v_domdoc := DBMS_XMLDOM.NEWDOMDOCUMENT(XMLTYPE.CREATEXML(
             xmlData => BFILENAME('REPXSL','comp_attribut.xml'),
             csid    => NLS_CHARSET_ID('AL32UTF8'),
             schema  => NULL));
    v_xsltdomdoc := DBMS_XMLDOM.NEWDOMDOCUMENT(XMLTYPE.CREATEXML(
             xmlData => BFILENAME('REPXSL','compagnie_attribut.xsl'),
             csid    => NLS_CHARSET_ID('AL32UTF8'),
             schema  => NULL));

    v_xsl           := DBMS_XSLPROCESSOR.newstylesheet( v_xsltdomdoc,NULL);
    v_procxsl       := DBMS_XSLPROCESSOR.newProcessor;
    v_resultdomfrag := DBMS_XSLPROCESSOR.processxsl(v_procxsl, v_xsl, v_domdoc);
    v_resultnode    := DBMS_XMLDOM.makenode(v_resultdomfrag);

    DBMS_XMLDOM.writeToBuffer(v_resultnode, buf );
    DBMS_OUTPUT.PUT_LINE( 'Taille du buffer : ' || LENGTH(buf));
    DBMS_OUTPUT.PUT_LINE(buf);
END;
/
show err

--- DBMS_XMLDOM

DECLARE
   v_xmltype XMLTYPE;
   v_domdoc DBMS_XMLDOM.DOMDocument;
   v_root_node DBMS_XMLDOM.DOMNode;
   v_vols_element DBMS_XMLDOM.DOMElement;
   v_vols_node    DBMS_XMLDOM.DOMNode;
   v_vol_element DBMS_XMLDOM.DOMElement;
   v_vol_node    DBMS_XMLDOM.DOMNode;
   v_immat_element DBMS_XMLDOM.DOMElement;
   v_immat_node DBMS_XMLDOM.DOMNode;
   v_immat_text DBMS_XMLDOM.DOMText;
   v_immat_textnode DBMS_XMLDOM.DOMNode;
BEGIN
   -- document XML vide
   v_domdoc := DBMS_XMLDOM.newDomDocument;
   -- racine
   v_root_node := DBMS_XMLDOM.makeNode(v_domdoc);
   -- noeud racine
   v_vols_element := DBMS_XMLDOM.createElement(v_domdoc, 'vols' );
   v_vols_node    := DBMS_XMLDOM.appendChild(v_root_node,
                                       DBMS_XMLDOM.makeNode(v_vols_element));
   FOR c_enreg IN (SELECT c.codec, c.nom_comp, af.na, af.date_a, af.nb_passagers 
                  FROM   compagnie_R c, affreter_R af
                  WHERE  c.codec = af.codec)
   LOOP
      -- pour chaque ligne ajout d'un lment complexe
      v_vol_element := DBMS_XMLDOM.createElement(v_domdoc, 'vol' );
      DBMS_XMLDOM.setAttribute(v_vol_element, 'comp', c_enreg.nom_comp);
      v_vol_node := DBMS_XMLDOM.appendChild(v_vols_node,
                               DBMS_XMLDOM.makeNode(v_vol_element));
      v_immat_element := DBMS_XMLDOM.createElement(v_domdoc, 'immat' );
      v_immat_node    := DBMS_XMLDOM.appendChild(v_vol_node,
                                             DBMS_XMLDOM.makeNode(v_immat_element));
      v_immat_text     := DBMS_XMLDOM.createTextNode(v_domdoc, c_enreg.na);
      v_immat_textnode := DBMS_XMLDOM.appendChild(v_immat_node,
                                             DBMS_XMLDOM.makeNode(v_immat_text));
      DBMS_XMLDOM.setAttribute(v_vol_element, 'date_vol', 
                                               TO_CHAR(c_enreg.date_a,'YYYY-MM-DD')||'T'||
                                               TO_CHAR(c_enreg.date_a,'HH24:MI:SS'));
      DBMS_XMLDOM.setAttribute(v_vol_element, 'passagers',c_enreg.nb_passagers);
   END LOOP;
   v_xmltype := DBMS_XMLDOM.getXmlType(v_domdoc);
   DBMS_XMLDOM.freeDocument(v_domdoc);
   DBMS_OUTPUT.PUT_LINE(v_xmltype.getClobVal());
END;
/

-- 

DROP TABLE affreter_R	PURGE;
DROP TABLE avion_R	PURGE;
DROP TABLE compagnie_R PURGE;
