
SET LONG 10000
set pagesize 100

-- XMLQUERY

-- 1 lment

COL "/compagnie/comp" FORMAT A20
COL nom_doc           FORMAT A15

SELECT XMLQuery('/compagnie/comp' 
                PASSING BY VALUE OBJECT_VALUE 
                RETURNING CONTENT) AS "/compagnie/comp"
FROM  t_documents_xml;

SELECT nom_doc , XMLQuery('/compagnie/comp' 
                PASSING BY VALUE col_xml 
                RETURNING CONTENT) AS "/compagnie/comp"
FROM  t_col_xml;


-- lments

SELECT XMLQuery('/compagnie/pilotes' 
                PASSING BY VALUE OBJECT_VALUE 
                RETURNING CONTENT) AS "/compagnie/pilotes"
FROM  t_documents_xml
WHERE  ROWNUM = 1;

SELECT XMLQuery('/compagnie/pilotes' 
                PASSING BY VALUE col_xml 
                RETURNING CONTENT) AS "/compagnie/pilotes"
FROM  t_col_xml 
WHERE nom_doc = 'compagnie3.xml';


-- 1 attribut

COL "/compagnie/@date_crea" FORMAT A22

SELECT XMLQuery('/compagnie/@date_crea' 
                PASSING BY VALUE OBJECT_VALUE 
                RETURNING CONTENT) AS "/compagnie/@date_crea"
FROM  t_documents_xml;

SELECT nom_doc, XMLQuery('/compagnie/@date_crea' 
                PASSING BY VALUE col_xml 
                RETURNING CONTENT) AS "/compagnie/@date_crea"
FROM  t_col_xml;

-- prdicat

alter session set nls_numeric_characters = ".,";

COL "plus de 5000" FORMAT A20

SELECT XMLQuery('/compagnie/pilotes/pilote[salaire<5000]/nom' 
                PASSING BY VALUE OBJECT_VALUE 
                RETURNING CONTENT) AS "plus de 5000"
FROM  t_documents_xml;

SELECT nom_doc , XMLQuery('/compagnie/pilotes/pilote[salaire<5000]/nom' 
                PASSING BY VALUE col_xml 
                RETURNING CONTENT) AS "plus de 5000"
FROM  t_col_xml;

       
--  XMLCAST


-- 1 lment

COL nom_comp FORMAT A20

SELECT nom_doc, XMLCAST(
        XMLQUERY('/compagnie/nomComp' 
           PASSING col_xml RETURNING CONTENT) 
       AS VARCHAR2(30)) AS nom_comp
FROM  t_col_xml;

-- lments

-- 1 attribut

COL date_crea FORMAT A15

SELECT nom_doc, XMLCAST(
        XMLQUERY('/compagnie/@date_crea' 
           PASSING col_xml RETURNING CONTENT) 
       AS DATE) AS date_crea
FROM  t_col_xml;

-- prdicat

COL nom FORMAT A20

COL resultat FORMAT A40

SELECT nom_doc, XMLCAST(
        XMLQUERY('/compagnie/pilotes/pilote[@brevet="PL-25"]/nom' 
            PASSING col_xml RETURNING CONTENT)
        AS VARCHAR2(20)) AS nom
FROM  t_col_xml;

-- lment non terminal : tout en texte non format

SELECT XMLCAST(
        XMLQUERY('/compagnie/pilotes' 
        PASSING col_xml RETURNING CONTENT)
      AS VARCHAR2(80)) AS resultat
FROM  t_col_xml
WHERE nom_doc = 'compagnie2.xml';

-- si plusieurs valeurs retournes : pb -> XMLTABLE

SELECT XMLCAST(
        XMLQUERY('/compagnie/pilotes/pilote/nom' 
        PASSING col_xml RETURNING CONTENT)
      AS VARCHAR2(80)) AS resultat
FROM  t_col_xml
WHERE nom_doc = 'compagnie2.xml';

-- XMLTABLE

-- plusieurs lments non terminaux

COL pilote FORMAT A30

SELECT a2.COLUMN_VALUE AS pilote
FROM   t_col_xml a1, XMLTABLE('/compagnie/pilotes/pilote' 
                                PASSING a1.col_xml) a2
WHERE  a1.nom_doc= 'compagnie2.xml';

-- plusieurs lments terminaux

SELECT   a1.nom_doc, a2.COLUMN_VALUE AS nom
FROM     t_col_xml a1, XMLTABLE('/compagnie/pilotes/pilote/nom' 
                                PASSING a1.col_xml) a2;

-- plusieurs lments terminaux avec COLUMNS

COL brevetp FORMAT A10
COL nomp    FORMAT A15

SELECT   a1.nom_doc,a2.brevetp, a2.nomp
FROM     t_col_xml a1,
         XMLTABLE('/compagnie/pilotes/pilote' 
                  PASSING a1.col_xml 
                  COLUMNS nomp    VARCHAR2(20) PATH 'nom',
                          brevetp VARCHAR2(10) PATH '@brevet') a2
ORDER BY a2.nomp;


-- plusieurs XMLTABLE

COL nomc FORMAT A15 

SELECT a1.nom_doc, a2.nomc, SUM(TO_NUMBER(a3.sal)) AS salaires
FROM   t_col_xml a1, XMLTABLE('/compagnie' PASSING a1.col_xml
	                    COLUMNS nomc VARCHAR2(20) PATH 'nomComp', 
	                            pils XMLType      PATH 'pilotes/pilote') a2,
       XMLTABLE('pilote' PASSING a2.pils
	                 COLUMNS sal NUMBER PATH 'salaire') a3
GROUP BY a1.nom_doc, a2.nomc;

-- XMLEXISTS


SELECT XMLCAST(
        XMLQUERY('/compagnie/nomComp' 
           PASSING col_xml RETURNING CONTENT) 
       AS VARCHAR2(30)) AS nom_comp
FROM   t_col_xml 
WHERE  XMLEXISTS('/compagnie[@date_crea=xs:date("2013-04-01")]' PASSING col_xml);


SELECT XMLCAST(
        XMLQUERY('/compagnie[nomComp="Air Castanet"]/comp' 
           PASSING col_xml RETURNING CONTENT) 
       AS VARCHAR2(6)) AS comp
FROM   t_col_xml 
WHERE  XMLEXISTS('/compagnie[@date_crea=xs:date("2012-09-01")]' PASSING col_xml);


SELECT a3.nomp
FROM   t_col_xml a1, XMLTABLE('/compagnie' PASSING a1.col_xml
	                    COLUMNS nomc VARCHAR2(20) PATH 'nomComp', 
	                            pils XMLType      PATH 'pilotes/pilote') a2,
       XMLTABLE('pilote' PASSING a2.pils
                         COLUMNS brev VARCHAR2(6) PATH '@brevet',
                                 nomp VARCHAR2(20) PATH 'nom',
	                         sal  NUMBER PATH 'salaire') a3
WHERE a3.sal  = 5000
AND   a3.brev = 'PL-25'  ;


INSERT INTO t_documents_xml VALUES
  (XMLType
      (xmlData    => BFILENAME('REPXML','vol1.xml'),
       csid       => NLS_CHARSET_ID('AL32UTF8')));

INSERT INTO t_col_xml (nom_doc,col_xml) VALUES
 ('vol1.xml',
  (XMLType
      (xmlData    => BFILENAME('REPXML','vol1.xml'),
       csid       => NLS_CHARSET_ID('AL32UTF8'))));


INSERT INTO t_documents_xml VALUES
  (XMLType
      (xmlData    => BFILENAME('REPXML','vol2.xml'),
       csid       => NLS_CHARSET_ID('AL32UTF8')));

INSERT INTO t_col_xml (nom_doc,col_xml) VALUES
 ('vol2.xml',
  (XMLType
      (xmlData    => BFILENAME('REPXML','vol2.xml'),
       csid       => NLS_CHARSET_ID('AL32UTF8'))));

commit;

SELECT t.isSchemaValid(schurl => 'http://www.actmp.fr/compagnies.xsd',
                                   elem   => 'compagnie') AS validation
FROM   t_documents_xml t;

SELECT t.nom_doc,
       t.col_xml.isSchemaValid(schurl => 'http://www.actmp.fr/compagnies.xsd',
                             elem   => 'compagnie') AS validation
FROM  t_col_xml t;


set serverout on


DECLARE
 var_xml  XMLTYPE;
 resultat NUMBER;
BEGIN
var_xml :=
  XMLType(xmlData    => BFILENAME('REPXML','compagnie.xml'),
          csid       => NLS_CHARSET_ID('AL32UTF8'));
 resultat  := 
  var_xml.isSchemaValid(schurl => 'http://www.actmp.fr/compagnies.xsd',
                        elem   => 'compagnie');
 IF resultat = 0 THEN
   dbms_output.put_line('document non valide');
 ELSE 
   dbms_output.put_line('document valide');
 END IF;
END;
/




