
-- Mode objet avec grammaire annote et VARRAY 

-- lment 

CREATE UNIQUE INDEX idx_comp_xml_col ON t_documents_xml
       (CAST ("XMLDATA"."COMP" AS VARCHAR2(6)));

CREATE UNIQUE INDEX idx_comp_xml ON t_col_xml
       (CAST (col_xml."XMLDATA"."COMP" AS VARCHAR2(6)));

-- sur binary XML depuis 11

CREATE UNIQUE INDEX idx_nomcomp_xml ON t_documents_xml
 (XMLCast(
     XMLQuery('/compagnie/nomComp' 
              PASSING OBJECT_VALUE RETURNING CONTENT) 
  AS VARCHAR2(20)));

CREATE UNIQUE INDEX idx_nomcomp_xml_col ON t_col_xml
 (XMLCast(
     XMLQuery('/compagnie/nomComp' 
              PASSING col_xml RETURNING CONTENT) 
  AS VARCHAR2(20)));

-- attribut 

CREATE INDEX idx_date_crea_xml ON t_documents_xml
(CAST ("XMLDATA"."DATE_CREA" AS DATE));

CREATE INDEX idx_date_crea_xml_col ON t_col_xml
(CAST (col_xml."XMLDATA"."DATE_CREA" AS DATE));

DROP INDEX idx_date_crea_xml_col ;
DROP INDEX idx_date_crea_xml ;

-- sur binary XML depuis 11

CREATE INDEX idx_date_crea_xml ON t_documents_xml
 (XMLCast(
     XMLQuery('/compagnie/@date_crea' 
              PASSING OBJECT_VALUE RETURNING CONTENT) 
  AS DATE));

CREATE INDEX idx_date_crea_xml_col ON t_col_xml
 (XMLCast(
     XMLQuery('/compagnie/@date_crea' 
              PASSING col_xml RETURNING CONTENT) 
  AS DATE));


-- nomcomp

SET AUTOTRACE ON
SELECT col_xml
FROM   t_col_xml
WHERE XMLCast(XMLQuery('/compagnie/nomComp'
               PASSING col_xml RETURNING CONTENT)
      AS VARCHAR2(20)) = 'Toulouse Air';
SET AUTOTRACE OFF


-- collections 

-- @brevet et nom

-- table XMLType

CREATE INDEX idx_coll_nompil_xml 
ON           pilote_table p (p."NOM", p.NESTED_TABLE_ID);

CREATE INDEX idx_coll_brevet_xml 
ON           pilote_table p (p."BREVET", p.NESTED_TABLE_ID);

DROP INDEX idx_coll_nompil_xml ;
DROP INDEX idx_coll_brevet_xml ;

-- col XMLType

CREATE INDEX idx_coll_brevet_xml 
ON           pilote_col_table p (p."BREVET", p.NESTED_TABLE_ID);

CREATE INDEX idx_coll_nompil_xml 
ON           pilote_col_table p (p."NOM", p.NESTED_TABLE_ID);


DROP INDEX idx_date_crea_xml_col ;
DROP INDEX idx_date_crea_xml ;

DROP INDEX idx_nomcomp_xml_col ;
DROP INDEX idx_nomcomp_xml;

DROP INDEX idx_comp_xml;
DROP INDEX idx_comp_xml_col ;

DROP INDEX idx_coll_nompil_xml ;
DROP INDEX idx_coll_brevet_xml ;


-- unstructured

-- utiliser une table binary XML

CREATE INDEX compagnie_xmlindex ON t_col_xml(col_xml)
INDEXTYPE IS XDB.XMLINDEX  
PARAMETERS 
  ('PATH TABLE      compagnie_path_table (TABLESPACE USERS)
    PATH ID INDEX   compagnie_idx        (TABLESPACE USERS)
    ORDER KEY INDEX compagnie_ok_idx     (TABLESPACE USERS)
    VALUE INDEX     compagnie_value_idx  (TABLESPACE USERS)');


COL index_name FORMAT A25
COL index_type FORMAT A25

COL table_name FORMAT A20


SELECT index_name, index_type, table_name
FROM   user_indexes;


drop index compagnie_xmlindex;

-- XMLIndex structured component

CREATE INDEX compagnie_xmlindex ON t_col_xml(col_xml)
INDEXTYPE IS XDB.XMLINDEX  
PARAMETERS 
  ('GROUP grp_pilote
       XMLTable tab_compa_xml 
         (TABLESPACE USERS COMPRESS FOR OLTP) 
         ''/compagnie''
         COLUMNS lineitem  XMLType PATH ''pilotes/pilote'' VIRTUAL
       XMLTable tab_comp_pilote_xml 
         (TABLESPACE USERS COMPRESS FOR OLTP)
         ''/pilote'' PASSING lineitem
          COLUMNS numpil   VARCHAR2(6)  PATH ''@brevet'',
                  sal      NUMBER(9)    PATH ''salaire'',
                  nompil   VARCHAR2(20) PATH ''nom''');


ALTER INDEX compagnie_xmlindex 
  PARAMETERS('ADD_GROUP GROUP grp_compagnie
         XMLTable tab_comp_xml ''/compagnie''
         COLUMNS date_crea DATE PATH ''@date_crea'',
                 comp  VARCHAR2(6)  PATH ''comp'',
                 nomc VARCHAR2(30) PATH ''nomComp''');
   

------ mixte

drop index compagnie_xmlindex ;

CREATE INDEX compagnie_xmlindex ON t_col_xml(col_xml)
INDEXTYPE IS XDB.XMLINDEX  
PARAMETERS ('PATH TABLE compagnie_path_table 
                  PATHS (EXCLUDE (/compagnie/pilotes /compagnie/nomComp))');

BEGIN
  DBMS_XMLINDEX.DROPPARAMETER ('param_compagnie');
end;
/

BEGIN
  DBMS_XMLINDEX.registerParameter('param_compagnie',
    'ADD_GROUP GROUP grp_pilote
       XMLTable tab_compa_xml ''/compagnie''
         COLUMNS lineitem XMLType PATH ''pilotes/pilote'' VIRTUAL
       XMLTable tab_comp_pilotes_xml ''/pilote'' PASSING lineitem
         COLUMNS numpil    VARCHAR2(6)  PATH ''@brevet'',
                 nompil    VARCHAR2(20) PATH ''nom''');
END;
/

ALTER INDEX compagnie_xmlindex 
      PARAMETERS('PARAM param_compagnie');

/*
SET AUTOTRACE ON
SELECT acoll.COLUMN_VALUE
FROM  oxm.compagnie_col_bin_xml c,
      XMLTABLE('/compagnie/pilotes/pilote/nom/text()'
               PASSING c.comp_xml) acoll
WHERE XMLExists('/compagnie[@nc = "KB04-3"]'
                  PASSING c.comp_xml);
SET AUTOTRACE OFF

SET AUTOTRACE ON
SELECT acoll.nc, aligne.nomp
FROM   oxm.compagnie_col_bin_xml c, XMLTABLE('/compagnie' PASSING c.comp_xml
	                 COLUMNS nc VARCHAR2(6) PATH 'comp', 
	                       pils XMLType     PATH 'pilotes/pilote') acoll,
       XMLTABLE('pilote' PASSING acoll.pils
	                 COLUMNS nomp VARCHAR2(15) PATH 'nom') aligne
ORDER BY aligne.nomp;

SET AUTOTRACE OFF

-- nom des comp qui embauchent V. Sigude

SET AUTOTRACE ON
SELECT XMLCast(XMLQuery('/compagnie/nomComp'
      PASSING c.comp_xml RETURNING CONTENT) AS VARCHAR2(20))
FROM   oxm.compagnie_col_bin_xml c
WHERE XMLExists('/compagnie/pilotes/pilote[nom = "V. Sigude"]'
                  PASSING c.comp_xml);
SET AUTOTRACE OFF








