
--XML DB Repository

--dos

C:\app\csoutou\product\12.1.0\dbhome_1\BIN\lsnrctl status 

SET LONG 10000
SET PAGESIZE 100

SET SERVEROUT ON

-- DBMS_XDB_REPOS

--reset du rpertoire /home/OXM (avec tous ses sous-rep)

DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (DBMS_XDB_REPOS.EXISTSRESOURCE('/home/OXM')) THEN
      DBMS_XDB_REPOS.DELETERESOURCE('/home/OXM',
          DBMS_XDB_REPOS.DELETE_RECURSIVE_FORCE);
      COMMIT;
  END IF;
END;
/


DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF (DBMS_XDB_REPOS.EXISTSRESOURCE('/home/OXM/acls')) THEN
      DBMS_XDB_REPOS.DELETERESOURCE('/home/OXM/acls',
           DBMS_XDB_REPOS.DELETE_RECURSIVE_FORCE);
      COMMIT;
  END IF;
END;
/

DECLARE
  v_resultat BOOLEAN;
BEGIN
  v_resultat := DBMS_XDB_REPOS.CREATEFOLDER('/home/OXM');
  IF v_resultat THEN 
           DBMS_OUTPUT.PUT_LINE('/home/OXM OK.');
           v_resultat := DBMS_XDB_REPOS.CREATEFOLDER('/home/OXM/general');
           IF v_resultat THEN 
             DBMS_OUTPUT.PUT_LINE('/home/OXM/general OK.');
             COMMIT;
           ELSE
             DBMS_OUTPUT.PUT_LINE('bug creation /home/OXM/general');
           END IF;
        ELSE  
          DBMS_OUTPUT.PUT_LINE('bug creation /home/OXM');
  END IF;
END;
/

-- dpot d'un doc

DECLARE
  v_resultat BOOLEAN;
BEGIN
  IF NOT (DBMS_XDB_REPOS.EXISTSRESOURCE('/home/OXM/general/compagnie.xml')) THEN
       v_resultat := DBMS_XDB_REPOS.CREATERESOURCE(
                    abspath =>'/home/OXM/general/compagnie.xml',
                    data    => BFILENAME('REPXML', 'compagnie.xml'),
                    csid    => NLS_CHARSET_ID('AL32UTF8'));
      IF v_resultat THEN COMMIT;
                          DBMS_OUTPUT.PUT_LINE('dpot OK.');
      ELSE              DBMS_OUTPUT.PUT_LINE('bug dpot...');
      END IF;
   END IF;
END;
/

-- extraction clob/xmltype

DECLARE
   v_nom    VARCHAR2(15);
   v_xml    XMLTYPE;
   v_clob   CLOB;
   v_path   VARCHAR2(40) := '/home/OXM/general/compagnie.xml';
BEGIN
   v_clob   := DBMS_XDB_REPOS.GETCONTENTCLOB(v_path);
   DBMS_OUTPUT.PUT_LINE('Taille CLOB : ' || DBMS_LOB.GETLENGTH(v_clob));
   v_xml    := XMLTYPE.createXML(xmlData=>v_clob);
   SELECT XMLCAST(
          XMLQUERY('/compagnie/pilotes/pilote[@brevet="PL-2"]/nom' 
                  PASSING BY VALUE v_xml RETURNING CONTENT) 
          AS VARCHAR2(15)) INTO v_nom
   FROM  DUAL;
   DBMS_OUTPUT.PUT_LINE('nom pilote PL-2 : ' || v_nom);
END;
/

--RESOURCE_VIEW

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/schemas/PUBLIC/xmlns.oracle.com/xdb/XDBResource.xsd') = 1;

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/general/compagnie.xml') = 1;

SELECT COUNT(*) AS "Nombre grammaires www.actmp.fr"
FROM   RESOURCE_VIEW rv
WHERE  under_path(rv.RES,'/sys/schemas/OXM/www.actmp.fr') = 1;

SELECT COUNT(*)
FROM   RESOURCE_VIEW rv
WHERE  under_path(rv.RES,'/home/OXM/general') = 1;


SELECT a.nom AS "Date cration"
FROM   RESOURCE_VIEW rv,
       XMLTABLE(
         XMLNAMESPACES('http://xmlns.oracle.com/xdb/XDBResource.xsd' 
                      AS "e"),
            '/e:Resource' PASSING rv.RES
             COLUMNS nom VARCHAR2(20) PATH 'e:CreationDate') a
WHERE  equals_path(rv.RES,'/home/OXM/general/compagnie.xml') = 1;


COL ANY_PATH FORMAT A40
SELECT ANY_PATH 
FROM   RESOURCE_VIEW rv,
       XMLTABLE(
         XMLNAMESPACES('http://xmlns.oracle.com/xdb/XDBResource.xsd' AS "e"),
                      '/e:Resource' PASSING rv.RES
                      COLUMNS nom  VARCHAR2(20) PATH 'e:DisplayName',
                              proprio VARCHAR2(30) PATH 'e:Owner') a
WHERE  a.nom LIKE '%.xml'
AND    a.proprio = 'OXM';


SELECT a.brev AS brevet, a.nom 
FROM   RESOURCE_VIEW rv,
       XMLTABLE(
        XMLNAMESPACES('http://xmlns.oracle.com/xdb/XDBResource.xsd' 
                       AS "r"),
            '/r:Resource/r:Contents/compagnie/pilotes/pilote'
             PASSING rv.RES
             COLUMNS nom  VARCHAR2(15) PATH 'nom',
                     brev VARCHAR2(6)  PATH '@brevet') a
WHERE equals_path(rv.RES,'/home/OXM/general/compagnie.xml') = 1;


-- PATH_VIEW

COL path(1) FORMAT A40

SELECT path(1) AS "path(1)", depth(1) AS "depth(1)"
FROM   PATH_VIEW 
WHERE  under_path(RES,3,'/home/OXM',1) = 1;

COL PATH FORMAT A50
SELECT PATH, depth(1) AS "depth(1)", depth(2) AS "depth(2)" 
FROM   PATH_VIEW
WHERE (under_path(RES,3,'/sys/schemas/OXM',1) = 1
OR     under_path(RES,3,'/home/OXM',2) = 1);

-- ACL -----------

SELECT DBMS_XDB_REPOS.getACLDocument('/home/OXM/general/compagnie.xml')
FROM   DUAL;

-- grammaire gnrale

SELECT PATH 
FROM   PATH_VIEW
WHERE  under_path(res, '/sys/schemas') = 1;

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/schemas/PUBLIC/xmlns.oracle.com/xdb/acl.xsd') = 1;

-- listes des acls

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/acls/all_all_acl.xml') = 1;

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/acls/bootstrap_acl.xml') = 1;

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/acls/all_owner_acl.xml') = 1;

SELECT r.RES.getClobVal() 
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/sys/acls/ro_all_acl.xml') = 1;

-- quelle est l'ACL 

SELECT DBMS_XDB_REPOS.getACLDocument('/home/OXM/general/compagnie.xml')
FROM   DUAL;

--> par dfaut : bootstrap_acl.xml

-- changer par read only pour tout le monde

BEGIN
    DBMS_XDB_REPOS.setACL(res_path => '/home/OXM/general/compagnie.xml',
                          acl_path => '/sys/acls/ro_all_acl.xml');
    COMMIT;
END;
/

-- nouvelle ACL

SELECT DBMS_XDB_REPOS.getACLDocument('/home/OXM/general/compagnie.xml')
FROM   DUAL;

-- accs avec oxm2 possible en lecture

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/general/compagnie.xml') = 1;

-- ACL pour accs au propritaire seul : all_owner_acl.xml
/*
 <ace>
   <grant>true</grant>
   <principal>dav:owner</principal>
   <privilege>
     <all/>
   </privilege>
 </ace>
*/

BEGIN
    DBMS_XDB_REPOS.setACL('/home/OXM/general/compagnie.xml',
                           '/sys/acls/all_owner_acl.xml');
    COMMIT;
END;
/

-- accs avec oxm2 impossible en lecture

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/general/compagnie.xml') = 1;


SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/general/compagnie.xml') = 1;

-- Add an ACE giving privileges to user OXM2

DECLARE
  r       PLS_INTEGER;
  v_ace   XMLType;
  v_char  VARCHAR2(2000);
BEGIN
  v_char  := '<ace xmlns="http://xmlns.oracle.com/xdb/acl.xsd"
                   xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                   xsi:schemaLocation="http://xmlns.oracle.com/xdb/acl.xsd
                                        http://xmlns.oracle.com/xdb/acl.xsd
                   DAV:http://xmlns.oracle.com/xdb/dav.xsd">
                 <principal>OXM2</principal>
                 <grant>true</grant>
                 <privilege><all/></privilege>
               </ace>';
  v_ace := XMLType.createXML(v_char);
  r := DBMS_XDB_REPOS.changePrivileges(
                res_path=>'/home/OXM/general/compagnie.xml', 
                ace     => v_ace);
 COMMIT;
END;
/


SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/general/compagnie.xml') = 1;


--> modif par OXM2 possible

-- cration d'une ACL (exo)

DECLARE
  v_resultat BOOLEAN;
BEGIN
  v_resultat := DBMS_XDB_REPOS.CREATEFOLDER('/home/OXM/acls');
  IF v_resultat THEN 
           DBMS_OUTPUT.PUT_LINE('/home/OXM/acls OK.');
        ELSE  
          DBMS_OUTPUT.PUT_LINE('bug creation /home/OXM/acls');
  END IF;
END;
/

DECLARE
  v_resultat BOOLEAN;
BEGIN
 v_resultat  := DBMS_XDB_REPOS.createResource(
         abspath => '/home/OXM/acls/acl_oxm2.xml', 
         data    => 
           '<acl description="exemple acl"
               xmlns="http://xmlns.oracle.com/xdb/acl.xsd"
               xmlns:dav="DAV:"
               xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
               xsi:schemaLocation="http://xmlns.oracle.com/xdb/acl.xsd
                                   http://xmlns.oracle.com/xdb/acl.xsd">
            <ace>
              <grant>true</grant>
              <principal>OXM2</principal>
              <privilege>
                <read-contents/>  
                <dav:lock/>
                <dav:unlock/>            
              </privilege>
            </ace>
          </acl>',
         schemaurl => 'http://xmlns.oracle.com/xdb/acl.xsd',
         elem      => 'acl');
  IF v_resultat  THEN  
     DBMS_OUTPUT.PUT_LINE('dpot ACL OK.');
     COMMIT;
  ELSE       
     DBMS_OUTPUT.PUT_LINE('Problme au dpot ACL...');
  END IF;
END;
/


SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/acls/acl_oxm2.xml') = 1;

SELECT DBMS_XDB_REPOS.getACLDocument('/home/OXM/general/compagnie.xml')
FROM   DUAL;

BEGIN
    DBMS_XDB_REPOS.setACL('/home/OXM/general/compagnie.xml',
                           '/home/OXM/acls/ex1_acl.xml');
    COMMIT;
END;
/

--  all privileges granted to the current user on a specified resource.
--  pour OXM

SELECT DBMS_XDB_REPOS.getPrivileges('/home/OXM/general/compagnie.xml')
FROM DUAL;

SELECT DBMS_XDB_REPOS.getACLDocument('/home/OXM/general/compagnie.xml')
FROM   DUAL;

-- suppression d'une ACL
-- If a resource is being protected by an ACL that you want to delete, change the ACL -- of that resource before deleting the ACL.

BEGIN
    DBMS_XDB_REPOS.setACL('/home/OXM/general/compagnie.xml',
                           '/sys/acls/all_owner_acl.xml');
    COMMIT;
END;
/

BEGIN
  IF (DBMS_XDB_REPOS.EXISTSRESOURCE('/home/OXM/acls/ex1_acl.xml')) THEN
      DBMS_XDB_REPOS.DELETERESOURCE('/home/OXM/acls/ex1_acl.xml',
                                     DBMS_XDB_REPOS.DELETE_RECURSIVE_FORCE);
      COMMIT;
             DBMS_OUTPUT.PUT_LINE('ACL supprime');
      else
          DBMS_OUTPUT.PUT_LINE('ACL existante');
  END IF;
END;
/

SELECT r.RES.getClobVal()
FROM   RESOURCE_VIEW r
WHERE  equals_path(r.RES,'/home/OXM/acls/ex1_acl.xml') = 1;

-- DD



COL view_name   FORMAT A20
COL column_name   FORMAT A20
COL table_name   FORMAT A20
COL xmlschema    FORMAT A35
COL element_name FORMAT A15
COL schema_url   FORMAT A40

SELECT table_name, storage_type
FROM USER_XML_TABLES;

SELECT table_name,xmlschema,element_name
FROM   USER_XML_TABLES;

SELECT column_name,element_name,storage_type
FROM   USER_XML_TAB_COLS;

SELECT schema_url, local, binary
FROM   USER_XML_SCHEMAS;

SELECT view_name,xmlschema,element_name
FROM USER_XML_VIEWS;





