---Projection

CREATE TABLE Pilote
	(brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
         prenom VARCHAR2(20), nom VARCHAR2(20), nbHVol NUMBER(7,2), 
         compa VARCHAR2(4));

INSERT INTO Pilote VALUES ('PL-1', 'Benoit', 'Sarda',   4500, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Aime','Giaconne',   2000, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Pierre','Calac',    1500, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Jean Phi','Ferrage',2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Jean','Gazagnes',   NULL, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Arnaud', 'Sayag',   2450, 'AF');

COL compa FORMAT A5

SELECT * FROM Pilote;

-- col

SELECT compa, brevet FROM Pilote;

--alias

COL num_pilote FORMAT A11

SELECT compa AS compagnie, nom AS name, brevet num_pilote FROM Pilote;

SELECT a_pilotes.compa AS compagnie, a_pilotes.nom 
FROM   Pilote a_pilotes;

-- duplicatas

SELECT DISTINCT compa FROM Pilote;

SELECT UNIQUE compa FROM Pilote;

SELECT UNIQUE nbhvol,compa FROM Pilote;

-- null

INSERT INTO Pilote VALUES ('PL-9', 'Jean','999', NULL, NULL);

SELECT UNIQUE nbhvol FROM Pilote order by 1 desc;

rollback;


--expression


SELECT brevet, nbHVol*1.75 AS prime, nbHVol||nom AS heure_nom
FROM   Pilote;

--null

SELECT brevet, nbHVol FROM Pilote;

--odrer

SELECT brevet, nom FROM Pilote ORDER BY nom;

SELECT brevet,nbHVol FROM Pilote ORDER BY nbHvol DESC NULLS LAST;

-- case

SELECT    nom,
          DECODE(compa,      
                'AF',   'Air France',
                'SING', 'Singapore Air',
                'CAST', 'Trans Casta',
                        'Autre ou aucune') AS compagnie
FROM     Pilote
ORDER BY nom;


SELECT    nom,
          CASE compa    
                WHEN 'AF'    THEN 'Air France'
                WHEN 'SING'  THEN 'Singapore Air'
                WHEN 'CAST'  THEN 'Trans Casta'
                ELSE              'Autre ou aucune'
          END 
          AS compagnie
FROM     Pilote
ORDER BY nom;


-- ROWID 

SELECT ROWID, brevet, nom FROM Pilote;

--insertion multilignes

CREATE TABLE NomsetHVoldesPilotes 
	AS SELECT nom, nbHVol, compa FROM Pilote;
SELECT ROWID, p.* FROM NomsetHVoldesPilotes p;


--autre possibilit

DROP TABLE NomsetHVoldesPilotes ;
CREATE TABLE NomsetHVoldesPilotes 
	(nom VARCHAR(16), nbHVol NUMBER(7,2), compa CHAR(4));
INSERT INTO NomsetHVoldesPilotes 
	SELECT nom, nbHVol, compa FROM Pilote;
SELECT ROWID, p.* FROM NomsetHVoldesPilotes p;
DROP TABLE NomsetHVoldesPilotes ;

--ROWNUM

SELECT ROWNUM, brevet, nom FROM Pilote;


DROP TABLE Pilote;
