

conn system/***@pdborcl

alter pluggable database PDBORCL open;
alter session set container=PDBORCL;

CREATE USER christian_soutou
 IDENTIFIED BY christian_soutou
 DEFAULT TABLESPACE USERS
    QUOTA 10M ON USERS
    TEMPORARY TABLESPACE TEMP;

CREATE USER laurent_navarro 
 IDENTIFIED BY laurent_navarro 
 DEFAULT TABLESPACE USERS
    QUOTA 10M ON USERS
    TEMPORARY TABLESPACE TEMP;

CREATE USER president
 IDENTIFIED BY president
 DEFAULT TABLESPACE USERS
    QUOTA 10M ON USERS
    TEMPORARY TABLESPACE TEMP;

GRANT CONNECT, RESOURCE TO christian_soutou, laurent_navarro ;

CONNECT laurent_navarro/laurent_navarro@pdborcl

CREATE TABLE pilote
(brevet CHAR(6), nom VARCHAR2(10), age NUMBER(2), ville VARCHAR2(16),
CONSTRAINT pk_pilote PRIMARY KEY(brevet));

INSERT INTO pilote VALUES ('P1', 'Sarda', 46, 'Balma');
INSERT INTO pilote VALUES ('P2', 'Giaconne', 64, 'Toulouse');
INSERT INTO pilote VALUES ('P3', 'Calac', 53, 'Cugnaux');
INSERT INTO pilote VALUES ('P4', 'Gazagne', 63, 'Toulouse');


SELECT * FROM Pilote;

GRANT REFERENCES (brevet), UPDATE (ville), 
      SELECT ON Pilote 
TO christian_soutou; 

     
-- sous christian_soutou

CONNECT christian_soutou/christian_soutou@pdborcl

UPDATE  laurent_navarro.Pilote
SET     ville = 'Castanet'
WHERE   brevet = 'P3';

SELECT  brevet, nom, ville
FROM    laurent_navarro.Pilote
WHERE   ville = 'Castanet';

CREATE TABLE Qualifications 
(typeQualif  VARCHAR2(10), pil CHAR(6) NOT NULL,
       CONSTRAINT pk_Qualifications  PRIMARY KEY(typeQualif,pil));

INSERT INTO Qualifications VALUES ('PL','P1');
INSERT INTO Qualifications VALUES ('FI/A','P1');
INSERT INTO Qualifications VALUES ('FI/A','P2');
INSERT INTO Qualifications VALUES ('PPL','P4');
INSERT INTO Qualifications VALUES ('CPL','P4');
INSERT INTO Qualifications VALUES ('IR','P3');

select * from Qualifications ;

ALTER TABLE Qualifications 
	ADD CONSTRAINT dans_Pilote_laurent_navarro 
           FOREIGN KEY(pil) 
           REFERENCES laurent_navarro.Pilote(brevet);

--pb

INSERT INTO Qualifications VALUES ('IR', NULL);

INSERT INTO Qualifications VALUES ('IR', 'XXXX');


--Rvocation objet


CONNECT laurent_navarro/laurent_navarro@pdborcl

REVOKE UPDATE, SELECT  ON Pilote  FROM christian_soutou; 

REVOKE REFERENCES ON Pilote FROM christian_soutou; 

REVOKE  REFERENCES ON Pilote FROM christian_soutou CASCADE CONSTRAINTS; 


conn system/***@pdborcl

-- roles

-- GRANT CONNECT TO christian_soutou,  laurent_navarro, president;

CREATE ROLE Voir_Base        NOT IDENTIFIED;
CREATE ROLE Modif_Pilotes    NOT IDENTIFIED;
CREATE ROLE Voir_et_Modifier NOT IDENTIFIED;

GRANT SELECT	ON laurent_navarro.Pilote	TO Voir_Base;
GRANT SELECT	ON christian_soutou.Qualifications	TO Voir_Base;

GRANT UPDATE(ville) ON laurent_navarro.Pilote	TO Modif_Pilotes;

--rle qui hrite d'autres

GRANT Voir_Base, Modif_Pilotes TO Voir_et_Modifier;

--affectation

GRANT Modif_Pilotes TO christian_soutou;
GRANT Voir_Base     TO christian_soutou, laurent_navarro;
GRANT Voir_et_Modifier TO president;

--Rvocation 

REVOKE SELECT ON christian_soutou.Qualifications FROM Voir_Base;

REVOKE Voir_Base FROM laurent_navarro;

REVOKE Voir_Base FROM Voir_et_Modifier;


DROP USER christian_soutou CASCADE;

DROP USER laurent_navarro CASCADE;

DROP USER president CASCADE;


--


 




	





DROP USER christian_soutou CASCADE;

DROP USER laurent_navarro CASCADE;
