
-- tablespaces

set linesize 120

COL file_name format a50
col espace format a12
COL autoextensible format A15

-- 12c -------------

conn sys/*** AS sysdba

alter pluggable database PDBORCL open;

SELECT   tablespace_name AS espace, block_size, 
         initial_extent, status, contents 
FROM     dba_tablespaces
ORDER BY tablespace_name;

-- fichiers physiques


SELECT tablespace_name AS espace, file_name
FROM   dba_data_files;

SELECT tablespace_name AS espace,
       bytes/1024/1024      AS "Taille en Mo",
       user_bytes/1024/1024 AS "Dispo en Mo"
FROM   dba_data_files;

-- cration ts

drop tablespace ts_eyrolles including contents and datafiles;

CREATE SMALLFILE TABLESPACE ts_eyrolles
  DATAFILE 'C:\APP\CSOUTOU\ORADATA\ORCL\tblspc_eyrolles.data' 
  SIZE 4 M REUSE
  AUTOEXTEND ON NEXT 1 M
  MAXSIZE 1 G;

-- users

CREATE USER          dev1
IDENTIFIED BY        dev1
DEFAULT TABLESPACE   users
QUOTA 10M ON         users
QUOTA 1M  ON         ts_eyrolles
TEMPORARY TABLESPACE temp
PASSWORD EXPIRE;

CREATE USER          dev2
IDENTIFIED BY        dev2
DEFAULT TABLESPACE   users
QUOTA 10M ON         users
TEMPORARY TABLESPACE temp
ACCOUNT LOCK;

--

ALTER USER         dev1
IDENTIFIED BY      mdp_dev1
QUOTA UNLIMITED ON ts_eyrolles;

ALTER USER         dev2
QUOTA 2M ON        ts_eyrolles
ACCOUNT UNLOCK;


-- 2 tables dans ts2

SELECT   tablespace_name, sum(bytes)/1024/1024 as "Extents en Mo"
FROM     dba_extents 
WHERE    tablespace_name IN ('TS1','TS2','TS3')
group by tablespace_name
order by 1;


COL      segment_name FORMAT A30

SELECT     segment_name,extent_id,block_id, COUNT(*)
FROM       dba_extents
GROUP BY   segment_name, extent_id, block_id
HAVING COUNT(*) > 1;

SELECT COUNT(*)
FROM   dba_extents 
WHERE  owner = 'HR'; 

col SEGMENT_NAME format A30
COL SEGMENT_type format a10
col tablespace_name format a15

SELECT segment_name,segment_type,
       tablespace_name,extent_id,block_id
FROM   dba_extents 
WHERE  owner='HR'
ORDER BY extent_id,block_id;

COL owner FORMAT A30
SELECT   owner, COUNT(extent_id)
FROM     dba_extents
GROUP BY owner
ORDER BY 2; 

SELECT   segment_name,segment_type,extent_id,block_id,
         file_id,bytes
FROM     dba_extents 
WHERE    owner='HR'
ORDER BY block_id;

SELECT   tablespace_name,SUM(bytes)/1024/1024 AS 
          "Taille en Mo"
FROM     dba_extents 
GROUP BY tablespace_name
ORDER BY 2;

SELECT   owner "Schma",COUNT(block_id) "Extents" 
FROM     dba_extents 
GROUP BY owner
ORDER BY 2 DESC;

--
