﻿

-- Implicit Statement Results 

CREATE OR REPLACE PROCEDURE liste_adh(p1 IN adherent.civilite%TYPE,
                                      p2 IN pratique.spid%TYPE) IS
   v_cursor   SYS_REFCURSOR;
BEGIN
   OPEN v_cursor FOR SELECT prenom, nom
                 FROM adherent WHERE civilite = p1 
ORDER BY nom ;
   DBMS_SQL.RETURN_RESULT(v_cursor);
   OPEN v_cursor FOR SELECT a.prenom,a.nom
                 FROM   pratique p, adherent a 
                 WHERE  p.adhid = a.adhid
                 AND    p.spid = p2;
   DBMS_SQL.RETURN_RESULT(v_cursor);
END liste_adh;
/ 


EXEC liste_adh('Mr.', 12);

-- DBMS_SQL.GET_NEXT_RESULT

DECLARE
  v_cur     PLS_INTEGER;
  v_refcur  SYS_REFCURSOR;
  v_ret     PLS_INTEGER;
  v_col1     VARCHAR2(30);
  v_col2     VARCHAR2(30);
BEGIN
  v_cur := DBMS_SQL.OPEN_CURSOR(treat_as_client_for_results => TRUE);
  DBMS_SQL.PARSE (c => v_cur, statement => 'BEGIN liste_adh(''Mr.'', 12); END;', 
                  language_flag => DBMS_SQL.NATIVE);
  v_ret := DBMS_SQL.EXECUTE(v_cur);
  LOOP
    BEGIN
     DBMS_SQL.GET_NEXT_RESULT(v_cur, v_refcur);
       EXCEPTION
        WHEN NO_DATA_FOUND THEN EXIT;
    END;
    DBMS_OUTPUT.PUT_LINE('----- jeu de resultat ---');
    LOOP
      FETCH v_refcur INTO v_col1, v_col2;
      EXIT  WHEN v_refcur%NOTFOUND;
    END LOOP;
    DBMS_OUTPUT.PUT_LINE('le dernier ' || v_col1 || ' ' || v_col2);
    CLOSE v_refcur;
  END LOOP;
END;
/
