--Avant chaque programe Java de la section Curseurs

DROP TABLE Avion;
DROP TABLE Compagnie;

CREATE TABLE Compagnie
	(comp VARCHAR(4), nomComp VARCHAR(25),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Avion (immat CHAR(6), typeAvion VARCHAR(15), cap NUMBER(3), 
comp VARCHAR(4) REFERENCES Compagnie(comp), CONSTRAINT pk_Avion PRIMARY KEY(immat)) ;


INSERT INTO Compagnie VALUES ('AF', 'Air France');
INSERT INTO Compagnie VALUES ('TAT', 'Transport Air Tour');
INSERT INTO Compagnie VALUES ('AERI', 'Air Aeris Tlse');

INSERT INTO Avion VALUES ('F-WTSS', 'Concorde', 90, 'AF');
INSERT INTO Avion VALUES ('F-FGFB', 'Concorde', 95, 'AF');
INSERT INTO Avion VALUES ('F-GLFS', 'A320', 140, 'TAT');
INSERT INTO Avion VALUES ('F-GLKT', 'A340', 300, 'AERI');
INSERT INTO Avion VALUES ('F-GKUB', 'A330', 240, 'AERI');
INSERT INTO Avion VALUES ('F-GLZV', 'A330', 250, 'AERI');
COMMIT;

SELECT * FROM Avion;
SELECT * FROM Compagnie ;
----



CREATE OR REPLACE FUNCTION LeNomCompagnieEst(p_immat IN VARCHAR) RETURN VARCHAR IS
  rsultat Compagnie.nomComp%TYPE;
BEGIN
    SELECT nomComp INTO rsultat 
 	FROM Compagnie WHERE comp = (SELECT comp FROM Avion WHERE immat = p_immat);
    RETURN rsultat;
EXCEPTION
	WHEN NO_DATA_FOUND THEN RETURN NULL;
END;
/

DECLARE
n VARCHAR(25);
BEGIN
 n := LeNomCompagnieEst('F-GLFS');
END;
/


CREATE OR REPLACE PROCEDURE AugmenteCapacit(p_immat IN VARCHAR, p_n IN NUMBER) IS
BEGIN
    UPDATE Avion SET cap = cap + p_n
	WHERE immat = p_immat;
END;
/

CREATE OR REPLACE PACKAGE GestionAvs AS
 TYPE Comp_Curtype IS REF CURSOR;
--
FUNCTION retourneCompagnies RETURN Comp_Curtype;
--
END GestionAvs;
/

CREATE OR REPLACE PACKAGE BODY GestionAvs AS
--
FUNCTION retourneCompagnies RETURN Comp_Curtype IS
 rsultat Comp_Curtype;
 BEGIN
  OPEN rsultat FOR SELECT comp, nomComp FROM Compagnie;
  RETURN rsultat;
 END;
--
END GestionAvs;
/

DROP TABLE Avion2;
CREATE TABLE Avion2 (immat VARCHAR(6), typeAvion VARCHAR(15), cap NUMBER(3), comp VARCHAR(4)) ;

DROP  PACKAGE GestionAvs;
DROP FUNCTION LeNomCompagnieEst;
DROP PROCEDURE AugmenteCapacit;
DROP TABLE Avion;
DROP TABLE Compagnie;

 

