
SET LONG 10000
SET PAGESIZE 100

-- GENERATION DE CONTENUS XML


CREATE TABLE compagnie_R
(codec VARCHAR2(6) PRIMARY KEY, nom_comp VARCHAR2(30)); 

CREATE TABLE avion_R
(na CHAR(6), typav VARCHAR(6), capacite NUMBER(3), proprio VARCHAR2(6), 
CONSTRAINT pk_avion PRIMARY KEY(na), 
CONSTRAINT fk_avion_comp FOREIGN KEY(proprio)
		REFERENCES  compagnie_R(codec),
CONSTRAINT ck_cap_avion CHECK (capacite BETWEEN 50 AND 500));

CREATE TABLE affreter_R
(na CHAR(6), codec VARCHAR(6),date_a DATE,nb_passagers NUMBER,
CONSTRAINT pk_affreter PRIMARY KEY (na, codec, date_a),
CONSTRAINT fk_affreter_na FOREIGN KEY(na)
		REFERENCES avion_R(na),
CONSTRAINT fk_affreter_comp FOREIGN KEY(codec)
		REFERENCES  compagnie_R(codec),
CONSTRAINT ck_nb_p CHECK (nb_passagers BETWEEN 0 AND 500));


INSERT INTO compagnie_R VALUES ('AF','Air France');
INSERT INTO compagnie_R VALUES ('EJ','Easy Jet');
INSERT INTO compagnie_R VALUES ('AB','Air Blagnac');
--
INSERT INTO avion_R	VALUES ('F-GODF','A320',170,'AB');
INSERT INTO avion_R	VALUES ('F-PROG','A318',140,'AF');
INSERT INTO avion_R	VALUES ('F-HGFT','A319',120,'AF');
INSERT INTO avion_R	VALUES ('F-WOWW','A380',490,'EJ');
--
INSERT INTO affreter_R	VALUES 
('F-GODF','EJ',TO_DATE('12-08-2014 14:30:00','DD-MM-YYYY HH24:MI:SS'),120);
INSERT INTO affreter_R	VALUES 
('F-GODF','AF',TO_DATE('12-08-2014 14:45:00','DD-MM-YYYY HH24:MI:SS'),150);
INSERT INTO affreter_R	VALUES 
('F-PROG','AF',TO_DATE('12-08-2014 14:45:00','DD-MM-YYYY HH24:MI:SS'),130);
INSERT INTO affreter_R	VALUES 
('F-PROG','AF',TO_DATE('12-09-2014 16:30:00','DD-MM-YYYY HH24:MI:SS'),110);
INSERT INTO affreter_R	VALUES 
('F-WOWW','AB',TO_DATE('12-09-2014 16:30:00','DD-MM-YYYY HH24:MI:SS'),450);

COMMIT;

-- 
SELECT * FROM compagnie_R ;
SELECT * FROM avion_R	;
SELECT na,codec,to_char(date_a,'DD-MM-YYYY') "DATE_A", nb_passagers FROM affreter_R;

-- XMLELEMENT and XMLATTRIBUTES SQL/XML Functions

SELECT XMLElement(NAME "flotte",
         XMLAttributes(c.codec AS "comp"),
	 XMLElement(NAME "nomcomp", c.nom_comp), 
         XMLElement(NAME "avions",
             (SELECT XMLAgg(
                       XMLElement(NAME "avion", 
                               XMLAttributes(av.na AS "immat"),
                               XMLForest(                           
                                 av.typav    AS "type_avi", 
                                 av.capacite AS "nb_pax"
                                 )
                               )
                       ORDER BY av.capacite DESC)
              FROM  avion_R av
              WHERE  av.proprio = c.codec))
         )
FROM   compagnie_R c
WHERE  c.codec = 'AF';
  


DECLARE 
 var_xml XMLTYPE;
 CURSOR curs IS SELECT codec,nom_comp FROM compagnie_R ORDER BY nom_comp;
BEGIN
 FOR enreg IN curs LOOP
    SELECT XMLElement(
        "affretements",
         XMLAttributes(enreg.codec AS "comp"),
	 XMLElement(NAME "nomcomp", enreg.nom_comp), 
         XMLElement(
             "vols",
             (SELECT XMLAgg(
                       XMLElement(
                              "vol",
                               XMLForest(
                                 TO_CHAR(af.date_a,'YYYY-MM-DD') AS "date_vol", 
                                 av.typav                       AS "avion", 
                                 af.nb_passagers                AS "nb_passagers"
                                 )
                               )
                       ORDER BY af.date_a DESC)
              FROM  affreter_R	af, avion_R av
              WHERE af.codec = enreg.codec
	      AND   av.na    = af.na)
           )
         ) INTO var_xml FROM DUAL;
     DBMS_OUTPUT.PUT_LINE(var_xml.getClobVal());
   END LOOP;  
END;
/

-- XMLFOREST SQL/XML Function

CREATE OR REPLACE TYPE aircraf_t AS OBJECT 
  ("@immat"  VARCHAR2(6),
   "type_av" VARCHAR2(6),
   "nb_p"    NUMBER(3),
   "comp"    VARCHAR2(6));
/


SELECT XMLForest(aircraf_t (na,typav,capacite,proprio) AS "avion")
AS    avion_xml
FROM  avion_R
ORDER BY na;

--> pour une racine : XMLAAGG

SELECT XMLElement("avions",
             (SELECT XMLAgg(
                       XMLElement(
                              "avion", XMLAttributes(av.na AS "immat"),
                               XMLForest(                           
                                 av.typav    AS "type_avi", 
                                 av.capacite AS "nb_pax"
                                 )
                            )
                       ORDER BY av.capacite)
              FROM  avion_R av)
         )
FROM   DUAL;

-- mieux avec le type

SELECT XMLElement("avions",
             (SELECT XMLAgg(
                            XMLForest(aircraf_t (na,typav,capacite,proprio) AS "avion")
                            )
              FROM  avion_R av)
         )
FROM   DUAL;


--avec un ordre XMLAgg

SELECT XMLElement("avions",
             (SELECT XMLAgg(
                            XMLForest(aircraf_t (na,typav,capacite,proprio) AS "avion")
                            ORDER BY capacite DESC
                            )
              FROM  avion_R av)
         )
FROM   DUAL;


-- pas possible sur le SELECT
SELECT XMLElement("avions",
             (SELECT XMLAgg(
                            XMLForest(aircraf_t (na,typav,capacite,proprio) AS "avion")
                            )
              FROM  avion_R av ORDER BY capacite DESC)
         )
FROM   DUAL;

-- XMLSerialize 

COL resultat FORMAT A30

SELECT XMLSerialize
      (DOCUMENT 
       XMLElement(
                   NAME "avions",
                   (
                    SELECT XMLAgg(
                                  XMLForest(aircraf_t(na,typav,capacite,proprio) AS "avion")
                                 )
                    FROM  avion_R
                    WHERE capacite > 300
                   )
                  )
        AS VARCHAR2(400)
        INDENT SIZE=1  
       ) AS resultat
FROM   DUAL;

set serverout on
      
DECLARE
 var_CLOB CLOB;
 taille   NUMBER;
BEGIN
 SELECT XMLSerialize(DOCUMENT col_xml AS CLOB)
        INTO var_CLOB 
 FROM   t_col_xml
 WHERE  XMLEXISTS('/compagnie/comp[text()="AC"]' PASSING BY VALUE col_xml);
 taille:= DBMS_LOB.GETLENGTH(var_CLOB);
 DBMS_OUTPUT.PUT_LINE('taille CLOB :'|| taille);
END;
/

-- PARSE

SELECT XMLParse(CONTENT '<vehicule immat="508-BAX-31"/><km>234567</km><vehicule/>') AS fragment
FROM DUAL;

SELECT XMLParse(CONTENT 'AF<vehicule immat="508-BAX-31"><km>245647</km><vehicule>')
FROM DUAL;

SELECT XMLParse(CONTENT 'AF<vehicule immat="508-BAX-31"><km>245647</km><vehicule>' WELLFORMED) 
FROM DUAL;

DECLARE
 var_string VARCHAR2(300) := 
    'AF<vehicule immat="508-BAX-31"><km>245647</km><vehicule>';
 var_xml XMLTYPE;
BEGIN
    SELECT XMLParse(CONTENT var_string WELLFORMED) INTO var_xml FROM DUAL;
    DBMS_OUTPUT.PUT_LINE('contenu mal form...');
    DBMS_OUTPUT.PUT_LINE(var_xml.getClobVal());
END;
/


-- XMLROOT

SELECT 
   XMLRoot(
       XMLElement(NAME "avions",
               (SELECT XMLAgg(XMLForest
                     (aircraf_t (na,typav,capacite,proprio) AS "avion")
                    ORDER BY capacite DESC)
               FROM  avion_R WHERE typav = 'A320')),
    VERSION NO VALUE, STANDALONE YES) 
FROM DUAL;


-- attention Serialize enlve le prologue

SELECT XMLSerialize(DOCUMENT 
   XMLRoot(
       XMLElement(NAME "avions",
               (SELECT XMLAgg(XMLForest
                     (aircraf_t (na,typav,capacite,proprio) AS "avion")
                    ORDER BY capacite DESC)
               FROM  avion_R av)),
    VERSION NO VALUE, STANDALONE YES) 
  AS CLOB NO INDENT)
FROM DUAL;


-- XMLColAttVal

SELECT XMLSerialize(DOCUMENT 
(SELECT XMLElement(NAME "aircraft", XMLAttributes(na AS "immat"),
        XMLColAttVal(typav    AS "type_aircraft", 
                     capacite AS "pax_num", 
                     proprio  AS "compagnie"))
FROM   avion_R
WHERE  typav = 'A318'
) AS CLOB INDENT) AS "doc_xml" 
FROM DUAL;

-- XMLCDATA 

set define off
SELECT XMLELEMENT(NAME "compagnies",
           XMLAGG(
             XMLELEMENT("compagnie",
               XMLFOREST(codec AS "comp",
                         XMLCDATA(nom_comp || '->' || 'pre & fils.') AS "nom_comp")
                         )
                        )
                  ) AS resultet
FROM   compagnie_R;


SELECT XMLSerialize(DOCUMENT 
(
...
) AS CLOB INDENT) AS "doc_xml" 
FROM DUAL;

COl resultat FORMAT A35
SELECT XMLSerialize(DOCUMENT 
(
SELECT XMLELEMENT(NAME "compagnies",
           XMLAGG(
             XMLELEMENT("compagnie",
               XMLFOREST(codec AS "comp",
                         XMLCDATA(nom_comp || '->' || 'pre & fils.') AS "nom_comp")
                         )
                        )
                  ) AS resultet
FROM   compagnie_R WHERE codec LIKE 'A%'
) AS CLOB INDENT) AS resultat
FROM DUAL;


-- SYS_XMLAGG

SELECT SYS_XMLAGG(
                 XMLForest(na    AS "immat", 
                           typav AS "type_aircraft")
                 ) 
FROM   oxm.avion_r
WHERE  proprio = 'AF';


SELECT SYS_XMLAGG(
                 XMLForest(na    AS "immat", 
                           typav AS "type_aircraft", 
                           capacite AS "pax_num", 
                           proprio AS "comp_owner"),
                   XMLFormat (enclTag => 'aircraft')
                 ) 
FROM   oxm.avion_r
WHERE  proprio = 'AF';


SELECT SYS_XMLAGG(
                 XMLForest(na    AS "immat", 
                           typav AS "type_aircraft", 
                           capacite AS "pax_num", 
                           proprio AS "comp_owner"),
                 XMLFormat (enclTag => 'aircraft', 
                            schemaType=> 'USE_GIVEN_SCHEMA',
                            schemaName=> 'http://sante.lu')
                 ) 
FROM   oxm.avion_r
WHERE  proprio = 'AF';


