
-- Vues relationnelles

CREATE OR REPLACE VIEW comp_master_vue AS
SELECT a.*
FROM   t_col_xml, 
       XMLTable('/compagnie' 
          PASSING col_xml
          COLUMNS code_c VARCHAR2(6)   PATH 'comp',
                  nom_c  VARCHAR2(30)  PATH 'nomComp',
                  date_c DATE          PATH '@date_crea') a;

COL nom_c FORMAT A15

SELECT * FROM comp_master_vue;

-- collection

CREATE or replace VIEW comp_detail_vue AS
SELECT a.comp, b.*
FROM   t_col_xml,
       XMLTABLE('/compagnie' PASSING col_xml
	COLUMNS comp    VARCHAR2(6)  PATH 'comp',
	        pils    XMLType      PATH 'pilotes/pilote') a,
       XMLTABLE('pilote' PASSING a.pils
        COLUMNS brevet  VARCHAR2(6)  PATH '@brevet',
                prepil  VARCHAR2(20) PATH 'prenom',
                nompil  VARCHAR2(20) PATH 'nom',
	        salaire NUMBER       PATH 'salaire') b;


col nompil FORMAT A12
ALTER SESSION SET nls_numeric_characters = ".,";

SELECT * FROM comp_detail_vue ;

-- indexation


SELECT DBMS_XMLSTORAGE_MANAGE.getSIDXDefFromView('COMP_MASTER_VUE')
FROM   DUAL;

-- bug
-- EXEC DBMS_XMLINDEX.DROPPARAMETER(name => 'param_vue_comp_master');

EXEC DBMS_XMLINDEX.DROPPARAMETER('param_vue_comp_master');


BEGIN 
 DBMS_XMLINDEX.registerParameter(
        'param_vue_comp_master',
        DBMS_XMLSTORAGE_MANAGE.getSIDXDefFromView(
            'COMP_MASTER_VUE'));
END;
/
CREATE INDEX idx_comp on t_col_xml
     (col_xml) INDEXTYPE IS XDB.XMLIndex
      PARAMETERS ('PARAM param_vue_comp_master');


SET AUTOTRACE ON
SELECT * 
FROM   comp_master_vue v
WHERE  v.code_c = 'AC';
SET AUTOTRACE OFF

/*
Bug en 12.1, collection ?

ERROR:
ORA-06502: PL/SQL : erreur numrique ou erreur sur une valeur: tampon de chane de caractres trop
petit
ORA-06512:  "XDB.DBMS_XMLSTORAGE_MANAGE", ligne 2667
ORA-06512:  "XDB.DBMS_XMLSTORAGE_MANAGE", ligne 2969


SELECT DBMS_XMLSTORAGE_MANAGE.getSIDXDefFromView('COMP_DETAIL_VUE')
FROM   DUAL;

BEGIN 
 DBMS_XMLINDEX.registerParameter('param_vue_comp_detail',
      DBMS_XMLSTORAGE_MANAGE.getSIDXDefFromView(
            'COMP_DETAIL_VUE'));
END;
/
CREATE INDEX idx_comp on t_col_xml
     (OBJECT_VALUE) INDEXTYPE IS XDB.XMLIndex
      PARAMETERS ('PARAM param_vue_comp_detail');

SET AUTOTRACE ON
SELECT * 
FROM   comp_detail_vue v
WHERE  v.brevetpil = 'PL-2';
SET AUTOTRACE OFF

*/


DROP INDEX idx_comp;
DROP VIEW compagnie_detail_vue ;
DROP VIEW comp_master_vue ;


--Vues XMLType.

-- sans grammaire

DROP VIEW compagnie_vue_xml;

CREATE OR REPLACE VIEW compagnie_vue_xml OF XMLType
WITH OBJECT IDENTIFIER 
 (XMLCast(XMLQuery('/compagnie/@comp' 
          PASSING OBJECT_VALUE RETURNING CONTENT)
  AS VARCHAR2(6))) 
AS SELECT 
    XMLRoot(
       XMLElement
       (NAME "compagnie", XMLAttributes(c.codec AS "comp"),
	 XMLForest(c.nom_comp AS "nom_comp"),
         XMLElement( "vols",
             (SELECT XMLAGG(XMLElement( "vol",
                             XMLForest(TO_CHAR(af.date_a,'DD-MM-YYYY') AS "date_vol", 
				       av.typav        AS "avion", 
                                       af.nb_passagers AS "passagers")))
              FROM  affreter_R	af, avion_R av
              WHERE af.codec = c.codec
	      AND   av.na    = af.na))
        ), 
       VERSION NO VALUE, 
       STANDALONE YES)
FROM  compagnie_R c
WHERE c.codec = 'AF';

DESC compagnie_vue_xml 

SELECT REF(v), v.OBJECT_VALUE 
FROM   compagnie_vue_xml v;


--avec grammaire 


BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA('http://www.orsys.com/demo/avioncomp.xsd',
             DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
END;
/

-- sans targetNamespace=
--sans ns  'http://www.orsys.com/demo/avioncomp.xsd'  AS "xmlns" ,

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA(
    schemaurl     => 'http://www.actmp.fr/avioncomp.xsd',
    delete_option => DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE);
--
  DBMS_XMLSCHEMA.REGISTERSCHEMA
  (schemaurl => 'http://www.actmp.fr/avioncomp.xsd',
   schemadoc => 
   '<?xml version="1.0" encoding="UTF-8"?>
    <schema xmlns="http://www.w3.org/2001/XMLSchema"
     version="1.0" xmlns:xdb="http://xmlns.oracle.com/xdb">
    <element name="avioncomp">
    <complexType>
      <sequence>
        <element name="typeav" type="string"/>
        <element name="capacite" type="int"/>
        <element name="compav">
          <complexType>
            <sequence>
              <element name="comp" type="string"/>
              <element name="nomcomp" type="string"/>
            </sequence>
          </complexType>
        </element>
      </sequence>
      <attribute name="immat" type="string"/>
    </complexType>
    </element>
  </schema>',
  local     => TRUE,
  gentypes  => FALSE);
END;
/



CREATE OR REPLACE VIEW avicomp_vue_xml OF XMLType 
          XMLSCHEMA "http://www.actmp.fr/avioncomp.xsd" 
          ELEMENT "avioncomp"
WITH OBJECT IDENTIFIER 
    (XMLCast(XMLQuery('/avioncomp/@immat' 
              PASSING OBJECT_VALUE RETURNING CONTENT) 
     AS VARCHAR2(6)))
AS 
SELECT XMLElement(NAME "avioncomp",
               XMLAttributes(
                  'http://www.w3.org/2001/XMLSchema-instance' AS "xmlns:xsi",
                  'http://www.actmp.fr/avioncomp.xsd' AS "xsi:noNamespaceSchemaLocation",
                  av.na AS "immat"),
	 XMLForest(av.typav AS "typeav", av.capacite AS "capacite"),
         XMLElement(NAME "compav", XMLForest(c.codec AS "comp", c.nom_comp AS "nomcomp")))
FROM avion_R av, compagnie_R c
WHERE av.proprio = c.codec;

SELECT REF(a), a.OBJECT_VALUE FROM avicomp_vue_xml a;

SELECT  OBJECT_VALUE 
FROM    avicomp_vue_xml 
WHERE   XMLEXISTS('/avioncomp[@immat="F-GODF"]'
                  PASSING BY VALUE OBJECT_VALUE);

COL avion_F_GODF FORMAT A40
SELECT XMLSerialize
      (DOCUMENT 
         (
          SELECT OBJECT_VALUE FROM avicomp_vue_xml 
          WHERE XMLEXISTS('/avioncomp[@immat="F-GODF"]' PASSING BY VALUE OBJECT_VALUE)          
          ) AS VARCHAR2(400) INDENT SIZE=1  
       ) AS avion_F_GODF
FROM   DUAL;




DROP TABLE affreter_R	PURGE;
DROP TABLE avion_R	PURGE;
DROP TABLE compagnie_R PURGE;

