
conn eod@pdborcl/eod

-- RESULT_CACHE  

col name      FORMAT A30
col value     FORMAT A20
SELECT name, value/1024
FROM   v$parameter
WHERE  name LIKE 'result_cache%';

ALTER SYSTEM FLUSH shared_pool;
ALTER SYSTEM FLUSH buffer_cache;

--  exo voir temps + plan excution
--  adhrents inscrits aux mmes sports que l'adhrent 777 
--> numro 27000

SET TIMING ON
SELECT a.adhid,a.civilite,a.prenom,a.nom FROM adherent a
	WHERE NOT EXISTS
	 (SELECT spid FROM pratique WHERE adhid = 777
	  MINUS
	  SELECT spid FROM pratique WHERE adhid = a.adhid)
	AND NOT EXISTS
	 (SELECT spid FROM pratique WHERE adhid = a.adhid
	  MINUS
         SELECT spid FROM pratique WHERE adhid = 777)
	AND NOT (a.adhid = 777);
SET TIMING OFF


-- SELECT /*+ RESULT_CACHE */ 
-- ou 

ALTER SESSION SET RESULT_CACHE_MODE = FORCE;

SET TIMING ON
SET AUTOTRACE ON
SELECT a.adhid,a.civilite,a.prenom,a.nom FROM adherent a
	WHERE NOT EXISTS
	 (SELECT spid FROM pratique WHERE adhid = 777
	  MINUS
	  SELECT spid FROM pratique WHERE adhid = a.adhid)
	AND NOT EXISTS
	 (SELECT spid FROM pratique WHERE adhid = a.adhid
	  MINUS
         SELECT spid FROM pratique WHERE adhid = 777)
	AND NOT (a.adhid = 777);
SET AUTOTRACE OFF
SET TIMING OFF




-- refaire la requte aprs sa mise en cache

--

cOL NAME FORMAT A500
SELECT ID, TYPE, CREATION_TIMESTAMP, STATUS, NAME
FROM V$RESULT_CACHE_OBJECTS
WHERE CACHE_ID = 'fhkjr4ajmfcx8d17r1w6c22hm6';

-- ALTER SESSION SET RESULT_CACHE_MODE = MANUAL;



-- fonction PL cache

CREATE OR REPLACE PACKAGE compteur AS
   PROCEDURE initialise;
   PROCEDURE incremente;
   FUNCTION  affiche RETURN PLS_INTEGER;
   PROCEDURE reset;
END compteur ;
/

CREATE OR REPLACE PACKAGE BODY compteur AS
   g_compteur PLS_INTEGER := 0;
   --------------------------------------------------------
   PROCEDURE initialise IS
   BEGIN
      g_compteur := 0;
   END initialise;
   --------------------------------------------------------
   PROCEDURE incremente IS
   BEGIN
      g_compteur := g_compteur + 1;
   END incremente;
   --------------------------------------------------------
   FUNCTION affiche     RETURN PLS_INTEGER IS
    BEGIN
     RETURN g_compteur;
   END affiche;
   --------------------------------------------------------
   PROCEDURE reset IS
   BEGIN
      g_compteur := 0;
   END reset;
END compteur;
/

exec compteur.initialise();

CREATE OR REPLACE FUNCTION f_adhlu_cache(p1 IN adherent_big.adhid%TYPE) 
       RETURN VARCHAR2
       RESULT_CACHE 
--     RELIES_ON(adherent_big)
IS
   result   VARCHAR2(100);
   BEGIN
     SELECT nom||'-'||tel INTO result
            FROM  adherent_big
            WHERE adhid = p1;
     compteur.incremente();
     RETURN result;
END f_adhlu_cache;
/

--

set serverout on

DECLARE
 adhid_in    adherent_big.adhid%TYPE := 27342; -- georges LE BOUTEILLER
 v_res       VARCHAR2(100);
BEGIN
   FOR i IN 1 .. 100
   LOOP
      v_res  := f_adhlu_cache(adhid_in);
   END LOOP;
-- changer numro au 2eme appel (27486  27496 par exemple)
   v_res  := f_adhlu_cache(27504);
   DBMS_OUTPUT.PUT_LINE('Compteur : ' || compteur.affiche());  
END;
/


-- exo RELIES_ON implice depuis 11.2

-- lancer la fonction pendant qu'une autre session modifie 
--  le tel de 27342 (02.31.84.47.83) et commite
/*
BEGIN
 UPDATE adherent_big SET tel = '02.31.84.47.83' WHERE adhid = 27342;
 COMMIT;
END;
/
*/


exec compteur.initialise();

set serverout on

DECLARE
 adhid_in    adherent_big.adhid%TYPE := 27342; -- georges LE BOUTEILLER
 v_res       VARCHAR2(100);
BEGIN
   FOR i IN 1 .. 50
   LOOP
      DBMS_LOCK.sleep(1);
      DBMS_OUTPUT.PUT_LINE(f_adhlu_cache(adhid_in));  
   END LOOP;
   -- changer numro  chaque appel si possible (27486  27496 par exemple)
   v_res  := f_adhlu_cache(***);
   DBMS_OUTPUT.PUT_LINE('Compteur : ' || compteur.affiche());  
END;
/

-- 2 eme session

BEGIN
 UPDATE adherent_big SET tel = '06-06-06-00-00' WHERE adhid = 27342;
 COMMIT;
END;
/

--au final le cache est regnr

LE BOUTEILLER-02.31.84.47.83
LE BOUTEILLER-02.31.84.47.83
LE BOUTEILLER-06-06-06-00-00
LE BOUTEILLER-06-06-06-00-00
LE BOUTEILLER-06-06-06-00-00
LE BOUTEILLER-06-06-06-00-00
LE BOUTEILLER-06-06-06-00-00
...


-- exo
--Compare performance of repeated querying of data to
--caching in the PGA (packaged collection) and the 11g Result Cache.

SET SERVEROUTPUT ON

DECLARE
 adhid_in    adherent_big.adhid%TYPE := 27342; -- georges LE BOUTEILLER
 v_nbr_appel NUMBER := 100;                    --  100 accs
 v_res       VARCHAR2(100);
 t1   NUMBER;
 t2   NUMBER;
 t3   NUMBER;
 t4   NUMBER;
BEGIN
   DBMS_OUTPUT.put_line ('Solution 1, 1 fetch par appel');
   t1 := DBMS_UTILITY.get_time;
   FOR i IN 1 .. v_effectif 
   LOOP
     v_adh_rec  := adhlu1.onerow (adhid_in);
   END LOOP;
   t2 := DBMS_UTILITY.get_time;
   DBMS_OUTPUT.PUT_LINE('1 fetch par appel : '||TO_CHAR((t2-t1)/100)); 
--
   DBMS_OUTPUT.put_line ('Solution 2, Tableau en PGA');
   FOR i IN 1 .. v_effectif 
   LOOP
      v_adh_rec := adhlu2.onerow (adhid_in);
   END LOOP;
   t3 := DBMS_UTILITY.get_time;
   DBMS_OUTPUT.PUT_LINE('Tableau en PGA : ' || TO_CHAR((t3-t2)/100)); 
--
   DBMS_OUTPUT.put_line ('Solution 3, Result function CACHE');  
   FOR i IN 1 .. v_effectif 
   LOOP
      v_adh_rec := adhlu_cache.onerow (adhid_in);
   END LOOP;
   t4 := DBMS_UTILITY.get_time;
  DBMS_OUTPUT.PUT_LINE('Result function CACHE : ' || TO_CHAR((t4-t3)/100));  
END;
/

--

CREATE OR REPLACE PACKAGE adhlu1
IS
   FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE;
END;
/

CREATE OR REPLACE PACKAGE adhlu2
IS
   FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE;
END;
/

CREATE OR REPLACE PACKAGE BODY adhlu1 IS
   FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE
   IS
      onerow_rec   adherent_big%ROWTYPE;
   BEGIN
       EXECUTE IMMEDIATE 
     'SELECT *  FROM adherent_big WHERE adhid=:a'
      INTO onerow_rec USING adhid_in;
      RETURN onerow_rec;
   END;
END;
/

CREATE OR REPLACE PACKAGE BODY adhlu2 IS
   TYPE adh_tt IS TABLE OF adherent_big%ROWTYPE
      INDEX BY PLS_INTEGER;
   adh_cache  adh_tt ;
   -- Assumes entire table is already loaded into the collection.
  FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE IS
   BEGIN
      RETURN adh_cache (adhid_in);
   END onerow;
   PROCEDURE load_cache IS
   BEGIN
      FOR rec IN (SELECT * FROM adherent_big ORDER BY nom)
      LOOP
         adh_cache(rec.adhid) := rec;
      END LOOP;
   END load_cache;
BEGIN
   load_cache;
END adhlu2;
/

CREATE OR REPLACE PACKAGE adhlu_cache IS
  FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE RESULT_CACHE;
END adhlu_cache;
/

CREATE OR REPLACE PACKAGE BODY adhlu_cache IS
   FUNCTION onerow (adhid_in IN adherent_big.adhid%TYPE)
      RETURN adherent_big%ROWTYPE RESULT_CACHE RELIES_ON(adherent_big)
   IS
      onerow_rec   adherent_big%ROWTYPE;
   BEGIN
      SELECT * INTO onerow_rec
        FROM adherent_big
       WHERE adhid = adhid_in;
      RETURN onerow_rec;
   END onerow ;
END adhlu_cache;
/

-- update for 11g release 2: table-level result cache mode

ALTER TABLE adherent RESULT_CACHE (MODE FORCE);
ALTER TABLE pratique RESULT_CACHE (MODE FORCE);

SET AUTOTRACE ON
SELECT   a.prenom,a.nom, p.spid 
FROM     adherent a, pratique p
WHERE    a.adhid = 777
AND      a.adhid = p.adhid
ORDER BY p.spid ;
SET AUTOTRACE OFF

-- DD

ALTER TABLE sport RESULT_CACHE (MODE DEFAULT);

ALTER TABLE pratique RESULT_CACHE (MODE DEFAULT);

col table_name   FORMAT A10
col result_cache FORMAT A15

SELECT table_name, result_cache
FROM   user_tables
WHERE  table_name IN ('PRATIQUE','SPORT', 'ADHERENT');

ALTER TABLE pratique CACHE ;

--> In a CREATE TABLE statement, NOCACHE is the default.
--> In an ALTER TABLE statement, the existing value is not changed.

ALTER TABLE sport RESULT_CACHE (MODE FORCE);

SELECT table_name, result_cache
FROM   user_tables
WHERE  table_name IN ('PRATIQUE','SPORT');

SET AUTOTRACE TRACEONLY
SELECT  s.splibelle, p.adhid
FROM    pratique p, sport s
WHERE   p.adhid = 777
AND     p.spid=p.spid;
SET AUTOTRACE OFF

--> cache pas utilis car pratique pas en cache

ALTER TABLE pratique RESULT_CACHE (MODE FORCE);

SET AUTOTRACE TRACEONLY
SELECT  s.splibelle, p.adhid
FROM    pratique p, sport s
WHERE   p.adhid = 777
AND     p.spid=p.spid;
SET AUTOTRACE OFF

--> cache utilis  partir de 2 appels : 0 gets

CREATE TABLE adherentes
RESULT_CACHE (MODE FORCE)
AS    SELECT * 
      FROM   adherent
      WHERE  civilite IN ('Mme.','Mlle.');


SET AUTOTRACE TRACEONLY
SELECT  nom, prenom
FROM    adherentes
WHERE   adhid < 777;
SET AUTOTRACE OFF

-- ou

CREATE TABLE adherentes_bis CACHE
AS    SELECT * 
      FROM   adherent
      WHERE  civilite IN ('Mme.','Mlle.');


SET AUTOTRACE TRACEONLY
SELECT  nom, prenom
FROM    adherentes_bis 
WHERE   adhid < 777;
SET AUTOTRACE OFF

--> cache pas utilis ?

DROP TABLE adherentes_bis ;

DROP TABLE adherentes ;



---DD

desc V$RESULT_CACHE_STATISTICS
	
SELECT * FROM V$RESULT_CACHE_STATISTICS;

Captures the server cache performance stats, including block count and create count values.

SELECT * FROM V$RESULT_CACHE_MEMORY;
	
Captures the server cache memory stats

desc V$RESULT_CACHE_OBJECTS
	
SELECT * FROM V$RESULT_CACHE_OBJECTS;
	

Captures the cached result sets information, including status

SELECT * FROM V$RESULT_CACHE_DEPENDENCY;

Captures the dependencies of a result cache