
-- Clusters

-- Operateurs2 (40000) et Adherent_cluster (180000)

CREATE TABLE Operateurs2
 (opeid       CHAR(4) NOT NULL,
  nomope      VARCHAR(25) NOT NULL, 
  creaope     DATE NOT NULL,
  siegesocial VARCHAR(15) NOT NULL,
  nbclients   NUMBER(7) NOT NULL);

ALTER TABLE Operateurs2
      ADD CONSTRAINT pk_Operateurs2 
      PRIMARY KEY(opeid);

--  peu prs 40000 oprateurs alatoires

DECLARE
 i NUMBER;
BEGIN
 FOR i IN 1..40000 LOOP
  BEGIN
     INSERT INTO Operateurs2 VALUES 
            (DBMS_RANDOM.STRING('a',4),
             DBMS_RANDOM.STRING('l',25), (SYSDATE - i), 
             DBMS_RANDOM.STRING('l',15),0);
  EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN CONTINUE;
  END;
 END LOOP;
 COMMIT;
END;
/

SELECT COUNT(opeid) FROM Operateurs2;

--pour avoir 2 noms connus...
UPDATE Operateurs2 SET nomope='Orange',siegesocial='Toulouse'
       WHERE nomope=(select max(nomope) from operateurs2);
UPDATE Operateurs2 SET nomope='SFR',siegesocial='Toulouse'
       WHERE nomope=(select max(nomope) from operateurs2);
SELECT * FROM Operateurs2 WHERE nomope='SFR' OR nomope='Orange';

-- cration d'1.8 milion d'adhrents 

DELETE FROM temp;
COMMIT;

DECLARE
 i NUMBER;
BEGIN
 FOR i in 49..77 LOOP
   UPDATE temp SET 
       tel= TO_CHAR('+'||i||'-'||tel)
       WHERE tel IS NOT NULL;
   IF (MOD(i,2)=1) THEN
       UPDATE temp SET adhid =  adhid+i*27000;
   ELSE
       UPDATE temp SET adhid =  (i+1)*27000 - adhid;
   END IF;
   INSERT /*+ APPEND */ INTO Adherentbis SELECT * FROM temp;
   DELETE FROM temp;
   INSERT /*+ APPEND */ INTO temp SELECT * FROM Adherent;
   COMMIT;
 END LOOP; 
END;
/

SELECT COUNT(adhid),MAX(adhid),MIN(adhid) FROM Adherentbis;
SELECT COUNT(DISTINCT adhid) FROM Adherentbis;

CREATE CLUSTER ope_adh_cluster
   (opeid_cle CHAR(4)) 
   PCTFREE 5
   TABLESPACE tbs_cluster;

CREATE INDEX idx_ope_adh_cluster
      ON CLUSTER ope_adh_cluster
      TABLESPACE tbs_index;
 
CREATE TABLE Adherent_cluster
 (adhid      NUMBER(10), 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(20), 
  solde      NUMBER(8,2),
  opeid_cle  CHAR(4))
  CLUSTER ope_adh_cluster(opeid_cle);

CREATE TABLE Operateurs_cluster
 (opeid_cle    CHAR(4),
  nomope      VARCHAR(25) NOT NULL, 
  creaope     DATE NOT NULL,
  siegesocial VARCHAR(15) NOT NULL,
  nbclients   NUMBER(7) NOT NULL)
  CLUSTER ope_adh_cluster(opeid_cle);

SELECT cluster_name,key_size FROM USER_CLUSTERS;

INSERT /*+ APPEND */ INTO Operateurs_cluster SELECT * FROM Operateurs2;

INSERT /*+ APPEND */ INTO Adherent_cluster
       (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis;

ALTER TABLE Adherent_cluster ADD
      CONSTRAINT pk_Adherent_cluster 
      PRIMARY KEY (adhid)
      USING INDEX TABLESPACE tbs_index;

ALTER TABLE Operateurs_cluster ADD 
      CONSTRAINT pk_Operateurs_cluster 
      PRIMARY KEY (opeid_cle)
      USING INDEX TABLESPACE tbs_index;

-- Affectation des oprateurs2 aux Adherent_cluster
-- attention a dure...

DECLARE
 TYPE ope_tytab IS TABLE OF Operateurs2%ROWTYPE INDEX BY BINARY_INTEGER;
 tabope ope_tytab;
 CURSOR c1 IS SELECT adhid FROM Adherent_cluster FOR UPDATE; 
 i NUMBER;
BEGIN
 SELECT * BULK COLLECT INTO tabope FROM Operateurs2;
 i := tabope.COUNT;
 FOR v IN c1 LOOP
  UPDATE Adherent_cluster 
     SET opeid_cle = tabope(ABS(MOD(DBMS_RANDOM.RANDOM,i-1))+1).opeid
     WHERE CURRENT OF c1;
 END LOOP;
 UPDATE Operateurs2 o
   SET o.nbclients =
   (SELECT COUNT(adhid) FROM Adherent_cluster WHERE opeid_cle=o.opeid);
 COMMIT;
END;
/

-- nombre d'adhrents par oprateur en moyenne (45)

SELECT AVG(COUNT(adhid)),MAX(COUNT(adhid)),MIN(COUNT(adhid)) 
       FROM Adherent_cluster 
       GROUP BY opeid_cle;

-- Ajout de l'oprateur  Adherentbis

ALTER TABLE Adherentbis
      ADD opeid_cle  CHAR(4);

UPDATE Adherentbis a
     SET a.opeid_cle = 
           (SELECT opeid_cle 
                   FROM Adherent_cluster
                   WHERE adhid = a.adhid); 
COMMIT;

-- taille en Mo du cluster et de l'index 

SET PAGESIZE 100
COL segment_name FORMAT A30
SELECT  segment_name,segment_type,bytes/1024/1024 "Taille en Mo"
  FROM  dba_segments
  WHERE owner='SOUTOU' 
  AND   NOT (segment_name LIKE '%CLUSTER')
  ORDER BY 3 DESC;

COL segment_name FORMAT A30
SELECT  segment_name,segment_type,bytes/1024/1024 "Taille en Mo"
  FROM  dba_segments
  WHERE owner='SOUTOU' 
  AND   segment_name LIKE '%CLUSTER'
  ORDER BY 3 DESC;


-- Proximit des blocs

SELECT opeid_cle FROM Operateurs_cluster WHERE nomope = 'SFR';
--> bceu

COL siegesocial FORMAT A20
SELECT opeid_cle,siegesocial, ROWID, DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) bloc
       FROM Operateurs_cluster 
       WHERE opeid_cle = (SELECT opeid_cle FROM Operateurs_cluster WHERE nomope = 'SFR')
       ORDER BY opeid_cle;

SELECT opeid_cle, nom, ROWID, DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) bloc
       FROM Adherent_cluster
       WHERE opeid_cle = (SELECT opeid_cle FROM Operateurs_cluster WHERE nomope = 'SFR')
       ORDER BY opeid_cle;

SELECT opeid_cle, nom, ROWID, DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) bloc
       FROM Adherent_cluster
       WHERE opeid_cle = 'bceu'
       ORDER BY opeid_cle;

-- Rpartition des lignes dans les blocs

-- nbre de lignes

SELECT COUNT(DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID)) nbre_total_de_lignes
        FROM Operateurs_cluster ;

SELECT COUNT(DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID)) nbre_total_de_lignes
        FROM Adherent_cluster;

--> nombre de blocs utiliss dans Operateurs_cluster 

SELECT COUNT(COUNT(DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))) nbre_blocs
        FROM Operateurs_cluster 
        GROUP BY DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID);

SELECT nbre_de_lignes, COUNT(*) nbre_de_blocs
  FROM (SELECT DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) blocs, COUNT(*) nbre_de_lignes
        FROM Operateurs_cluster 
        GROUP BY  DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))
  GROUP BY nbre_de_lignes ORDER BY 1 DESC;

--> nombre de blocs utiliss dans Adherent_cluster 

SELECT COUNT(COUNT(DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))) nbre_blocs
        FROM Adherent_cluster
        GROUP BY DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID);

SELECT nbre_de_lignes, COUNT(*) nbre_de_blocs
  FROM (SELECT DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) blocs, COUNT(*) nbre_de_lignes
        FROM Adherent_cluster
        GROUP BY  DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))
  GROUP BY nbre_de_lignes ORDER BY 1 DESC;


SELECT nbre_de_lignes*nbre_de_blocs 
  FROM (SELECT nbre_de_lignes, COUNT(*) nbre_de_blocs
        FROM (SELECT DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) blocs, COUNT(*) nbre_de_lignes
              FROM Adherent_cluster
              GROUP BY  DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))
        GROUP BY nbre_de_lignes);

SELECT SUM (nl) nbre_total_de_lignes
  FROM (SELECT nbre_de_lignes*nbre_de_blocs nl
        FROM (SELECT nbre_de_lignes, COUNT(*) nbre_de_blocs
              FROM (SELECT DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID) blocs, COUNT(*) nbre_de_lignes
                    FROM Adherent_cluster
                    GROUP BY  DBMS_ROWID.ROWID_BLOCK_NUMBER(ROWID))
               GROUP BY nbre_de_lignes));

-- collecte des stats
-- modifier 'SOUTOU' par votre user en majuscules

EXEC DBMS_STATS.gather_schema_stats('SOUTOU', cascade=>TRUE);

-- 

SET AUTOTRACE TRACEONLY
SELECT    a.nom, a.tel, o.opeid, a.date_nais
    FROM  Adherentbis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    ORDER BY o.opeid DESC;
SELECT    a.nom, a.tel, o.opeid_cle, a.date_nais
    FROM  Adherent_cluster a, Operateurs_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    ORDER BY o.opeid_cle DESC;
--
SELECT    o.opeid, COUNT(a.adhid)
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    GROUP BY o.opeid;
SELECT    o.opeid_cle, COUNT(a.adhid_cle)
    FROM  Adherent_cluster a, Operateurs_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    GROUP BY o.opeid_cle;
--  
SELECT    o.nomope
    FROM  Adherentbis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   a.adhid     = 23456;
SELECT    o.nomope
   FROM  Adherent_cluster a, Operateurs_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   a.adhid     = 23456;
--
SELECT    o.nomope
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   a.prenom    = 'CELINE';
SELECT    o.nomope
   FROM  Adherent_cluster a, Operateurs_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   a.prenom    = 'CELINE';
--
SELECT    o.nomope, a.nom, a.tel
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   o.opeid     LIKE 'G%';
SELECT    o.nomope, a.nom, a.tel
    FROM  Adherent_cluster a, Operateurs_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   o.opeid_cle LIKE 'G%';
SET AUTOTRACE OFF

-- Hash cluster 

CREATE CLUSTER ope_adh_hash_cluster
   (opeid_cle CHAR(4)) 
   PCTFREE 5
   HASHKEYS 40001
   TABLESPACE tbs_cluster;
 
CREATE TABLE Adherent_hash_cluster
 (adhid      NUMBER(10), 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(20), 
  solde      NUMBER(8,2),
  opeid_cle  CHAR(4))
  CLUSTER ope_adh_hash_cluster(opeid_cle);

CREATE TABLE Operateurs_hash_cluster
 (opeid_cle    CHAR(4),
  nomope      VARCHAR(25) NOT NULL, 
  creaope     DATE NOT NULL,
  siegesocial VARCHAR(15) NOT NULL,
  nbclients   NUMBER(7) NOT NULL)
  CLUSTER ope_adh_hash_cluster(opeid_cle);

INSERT /*+ APPEND */ INTO Adherent_hash_cluster 
       SELECT * FROM AdherentBis;
INSERT /*+ APPEND */ INTO Operateurs_hash_cluster 
       SELECT * FROM Operateurs2;

ALTER TABLE Adherent_hash_cluster ADD
      CONSTRAINT pk_Adherent_hcluster 
      PRIMARY KEY (adhid)
      USING INDEX TABLESPACE tbs_index;

ALTER TABLE Operateurs_hash_cluster ADD 
      CONSTRAINT pk_Operateurs_hcluster 
      PRIMARY KEY (opeid_cle)
      USING INDEX TABLESPACE tbs_index;

-- collecte des stats
-- modifier 'SOUTOU' par votre user en majuscules

EXEC DBMS_STATS.gather_schema_stats('SOUTOU', cascade=>TRUE);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT    a.nom, a.tel, o.opeid, a.date_nais
    FROM  Adherentbis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    ORDER BY o.opeid DESC;
SELECT    a.nom, a.tel, o.opeid_cle, a.date_nais
    FROM  Adherent_hash_cluster a, Operateurs_hash_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    ORDER BY o.opeid_cle DESC;
--
SELECT    o.opeid, COUNT(a.adhid)
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    GROUP BY o.opeid;
SELECT    o.opeid_cle, COUNT(a.adhid_cle)
    FROM  Adherent_hash_cluster a, Operateurs_hash_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    GROUP BY o.opeid_cle;
--  
SELECT    o.nomope
    FROM  Adherentbis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   a.adhid     = 23456;
SELECT    o.nomope
   FROM  Adherent_hash_cluster a, Operateurs_hash_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   a.adhid     = 23456;
--
SELECT    o.nomope
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   a.prenom    = 'CELINE';
SELECT    o.nomope
   FROM  Adherent_hash_cluster a, Operateurs_hash_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   a.prenom    = 'CELINE';
--
SELECT    o.nomope, a.nom, a.tel
    FROM  AdherentBis a, Operateurs2 o
    WHERE a.opeid_cle = o.opeid
    AND   o.opeid     LIKE 'G%';
SELECT    o.nomope, a.nom, a.tel
    FROM  Adherent_hash_cluster a, Operateurs_hash_cluster o
    WHERE a.opeid_cle = o.opeid_cle
    AND   o.opeid_cle LIKE 'G%';
SET AUTOTRACE OFF

SET TIMING OFF

-- Single table hash cluster

CREATE CLUSTER adh_single_ash_cluster
   (adhid NUMBER(10)) 
   SINGLE TABLE
   HASHKEYS 45000
   TABLESPACE tbs_cluster;
 
CREATE TABLE Adherent_single_hash_cluster
 (adhid      NUMBER(10), 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(20), 
  solde      NUMBER(8,2))
  CLUSTER adh_single_ash_cluster(adhid);

-- c'est trs trs long 

INSERT /*+ APPEND */ INTO Adherent_single_hash_cluster
       (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis
              WHERE adhid < 49800;

ALTER TABLE Adherent_single_hash_cluster ADD
      CONSTRAINT pk_Adh_single_hash_cluster 
      PRIMARY KEY (adhid)
      USING INDEX TABLESPACE tbs_index;

-- collecte des stats
-- modifier 'SOUTOU' par votre user en majuscules

EXEC DBMS_STATS.gather_schema_stats('SOUTOU', cascade=>TRUE);

-- nombre de blocs

SET AUTOTRACE TRACEONLY
 SELECT * FROM Adherent_single_hash_cluster;
SET AUTOTRACE OFF

SET TIMING ON

SET AUTOTRACE ON
SELECT    /*+ FULL(a) */ a.adhid, a.nom, a.tel, a.date_nais
    FROM  Adherent_single_hash_cluster a
    WHERE a.adhid IN (1,777,25001,49799);
SELECT    /*+ INDEX(a pk_Adh_single_hash_cluster) */ a.adhid, a.nom, a.tel,a.date_nais
      FROM  Adherent_single_hash_cluster a
      WHERE a.adhid IN (1,777,25001,49799);
SELECT   a.adhid, a.nom, a.tel,a.date_nais
      FROM  Adherent_single_hash_cluster a
      WHERE a.adhid IN (1,777,25001,49799);
SET AUTOTRACE OFF

-- sorted hash cluster

CREATE CLUSTER appels_sorted_hash_cluster 
  (tel          NUMBER(18),
   appel_moment TIMESTAMP SORT, 
   appel_duree  NUMBER    SORT) 
  HASHKEYS 100001
  SIZE 512
  HASH IS tel 
  TABLESPACE tbs_cluster;

CREATE TABLE Appels_detail 
  (tel          NUMBER(18), 
   appel_moment TIMESTAMP SORT, 
   appel_duree  NUMBER   SORT, 
   mots_cle     VARCHAR2(30)) 
  CLUSTER appels_sorted_hash_cluster 
          (tel,appel_moment,appel_duree);

-- de 100000 appels alatoires
DECLARE
 i NUMBER;
BEGIN
 FOR i IN 1..100000 LOOP
     INSERT /*+ APPEND */ INTO Appels_detail VALUES 
         (ABS(TRUNC(100*DBMS_RANDOM.VALUE,0)),
          CURRENT_TIMESTAMP,
          ABS(TRUNC(100*DBMS_RANDOM.VALUE,2)),
          DBMS_RANDOM.STRING('l',30));
END LOOP;
COMMIT;
END;
/

-- collecte des stats
-- modifier 'SOUTOU' par votre user en majuscules

EXEC DBMS_STATS.gather_schema_stats('SOUTOU', cascade=>TRUE);

SET TIMING ON

COL appel_moment FORMAT A25
COL mots_cle     FORMAT A10
SET AUTOTRACE ON
  SELECT a.appel_moment, a.appel_duree,SUBSTR(a.mots_cle,1,10) "Mots cle" 
      FROM  Appels_detail a
      WHERE a.tel = 056;
SET AUTOTRACE OFF

SET TIMING OFF