-- Jointures

-- remise des index sur Sport, Adherent et Pratique 

-- collecte des stats
BEGIN
DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'ADHERENT', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'SPORT', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'PRATIQUE', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
END;
/

--> essai join rel, proc et SQL92

SET AUTOTRACE TRACEONLY
SELECT    a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;

SELECT  a.adhid, a.nom, a.tel FROM Adherent a 
  INNER JOIN Pratique p ON p.adhid = a.adhid
    INNER JOIN Sport s ON s.spid = p.spid 
       WHERE s.splibelle IN ('Escrime','Ping-pong');

SELECT  adhid, nom, tel
  FROM Adherent 
  WHERE adhid IN 
    (SELECT adhid
       FROM  Pratique
       WHERE spid IN 
	(SELECT spid FROM Sport WHERE splibelle IN ('Escrime','Ping-pong')));
SET AUTOTRACE OFF

-->hash join deux 1ere hash join semi right pour la dernire
-- mme perfos 348 blocs cout 88 

--nested loop 

SET AUTOTRACE TRACEONLY

SELECT    /*+ USE_NL(s p) */ p.adhid
    FROM  Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   s.spid  = p.spid;
-- nl 157 blocs, cout 32
SET AUTOTRACE OFF

--> hash join si pas hint
SET AUTOTRACE TRACEONLY
SELECT    /*+ USE_NL(a p s) */ a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
--> 2904 blocs cout 142

SELECT  /*+ USE_NL(a p s) */ a.adhid, a.nom, a.tel FROM Adherent a 
  INNER JOIN Pratique p ON p.adhid = a.adhid
    INNER JOIN Sport s ON s.spid = p.spid 
       WHERE s.splibelle IN ('Escrime','Ping-pong');
--> 2904 blocs cout 142

--> ne fait pas nl ! normal : p et s ne sont pas au 1er niveau...
SELECT  /*+ USE_NL(a p s) */ a.adhid, a.nom, a.tel
  FROM Adherent a
  WHERE a.adhid IN 
    (SELECT p.adhid
       FROM  Pratique p WHERE p.spid IN 
	(SELECT s.spid FROM Sport s WHERE s.splibelle IN ('Escrime','Ping-pong')));
-->HASH JOIN RIGHT SEMI
SET AUTOTRACE OFF

--tests
SELECT    COUNT (DISTINCT a.adhid)
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;

SELECT    COUNT (*)
    FROM  Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong');

SELECT    a.adhid
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid
INTERSECT
SELECT    a.adhid
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;

--hash join

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
--> 348 blocs cout 88

SELECT a.adhid, a.nom, a.tel FROM Adherent a 
  INNER JOIN Pratique p ON p.adhid = a.adhid
    INNER JOIN Sport s ON s.spid = p.spid 
       WHERE s.splibelle IN ('Escrime','Ping-pong');
--> 348 blocs cout 88
SET AUTOTRACE OFF

--hint USE_HASH

SET AUTOTRACE TRACEONLY
SELECT  /*+ USE_HASH(a p s) */ a.adhid, a.nom, a.tel
  FROM Adherent a
  WHERE a.adhid IN 
    (SELECT p.adhid
       FROM  Pratique p WHERE p.spid IN 
	(SELECT s.spid FROM Sport s WHERE s.splibelle IN ('Escrime','Ping-pong')));
SET AUTOTRACE OFF


--hint NO_USE_HASH

SET AUTOTRACE TRACEONLY
SELECT  /*+ NO_USE_HASH(a p s) */ a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong')
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
SET AUTOTRACE OFF

--> ne fait pas nl !
SELECT  /*+ USE_NL(a p s) */ a.adhid, a.nom, a.tel
  FROM Adherent a
  WHERE a.adhid IN 
    (SELECT p.adhid
       FROM  Pratique p WHERE p.spid IN 
	(SELECT s.spid FROM Sport s WHERE s.splibelle IN ('Escrime','Ping-pong')));

-- sort merge join

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Rugby','Moto')
    AND   a.adhid > p.adhid
    AND   s.spid  > p.spid;
SET AUTOTRACE OFF

--Merge join seul

SET AUTOTRACE ON
SELECT   COUNT(a.adhid)
    FROM  Adherent a, Sport s, Pratique p
    WHERE s.splibelle  IN ('Escrime','Ping-pong');
SET AUTOTRACE OFF

-- requetes imbriques

SET AUTOTRACE TRACEONLY
--> HASH JOIN RIGHT SEMI
SELECT a.adhid, a.nom, a.tel
  FROM Adherent a
  WHERE a.adhid IN 
    (SELECT p.adhid
       FROM  Pratique p WHERE p.spid IN 
	(SELECT s.spid FROM Sport s WHERE s.splibelle IN ('Escrime','Ping-pong')));
SET AUTOTRACE OFF

--EXISTS / IN

--Les sports ayant des adhrents

SET AUTOTRACE TRACEONLY
SELECT s.spid,s.splibelle 
  FROM Sport s 
  WHERE EXISTS
   (SELECT p.adhid
      FROM Pratique p WHERE p.spid=s.spid);

SELECT s.spid,s.splibelle 
  FROM Sport s 
  WHERE s.spid IN
   (SELECT p.adhid FROM Pratique p);
SET AUTOTRACE OFF

--adhrents inscrits  un sport

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE EXISTS
   (SELECT p.adhid
      FROM Pratique p WHERE p.adhid=a.adhid);
SELECT  a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.adhid IN
   (SELECT p.adhid FROM Pratique p);
SET AUTOTRACE OFF

--Les sports ayant des adhrents

--NOT EXISTS / NOT IN

SET AUTOTRACE TRACEONLY
SELECT s.spid,s.splibelle 
  FROM Sport s 
  WHERE NOT EXISTS
   (SELECT p.adhid
      FROM Pratique p WHERE p.spid=s.spid);
SELECT s.spid,s.splibelle 
  FROM Sport s 
  WHERE s.spid NOT IN
   (SELECT p.adhid FROM Pratique p);
SET AUTOTRACE OFF

--adhrents inscrits  aucun sport

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE NOT EXISTS
   (SELECT p.adhid
      FROM Pratique p WHERE p.adhid=a.adhid);
SELECT  a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.adhid NOT IN
   (SELECT p.adhid FROM Pratique p);
SET AUTOTRACE OFF

--no unest

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE NOT EXISTS
   (SELECT /*+ NO_UNNEST */ p.adhid
      FROM Pratique p WHERE p.adhid=a.adhid);
SET AUTOTRACE OFF
