
CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

CREATE TABLE Avion
	(immat CHAR(6), typeAvion CHAR(15), nbhVol NUMBER(10,2), proprio CHAR(4),
	CONSTRAINT pk_Avion PRIMARY KEY(immat),
	CONSTRAINT nn_proprio CHECK (proprio IS NOT NULL),
	CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp));

CREATE TABLE Affreter
	(compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax NUMBER(3),
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');

INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

--null
INSERT INTO Pilote
 VALUES ('PL-4', 'Un Connu', 0, NULL);

--
INSERT INTO Pilote
 VALUES ('PL-5', 'Pb de Compagnie', 0, '?');

INSERT INTO Avion
   VALUES ('F-WTSS', 'Concorde', 6570, 'SING');

INSERT INTO Affreter
   VALUES ('AF', 'F-WTSS', '15-05-2003', 82);


DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Pilote;
DROP TABLE Compagnie;

--- ON DELETE CASCADE

CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp));

CREATE TABLE Avion
	(immat CHAR(6), typeAvion CHAR(15), nbhVol NUMBER(10,2), proprio CHAR(4),
	CONSTRAINT pk_Avion PRIMARY KEY(immat),
	CONSTRAINT nn_proprio CHECK (proprio IS NOT NULL),
	CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp));

CREATE TABLE Affreter
	(compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax NUMBER(3),
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat) ON DELETE CASCADE,
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');


INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

INSERT INTO Avion
   VALUES ('F-WTSS', 'Concorde', 6570, 'SING');

INSERT INTO Affreter
   VALUES ('AF', 'F-WTSS', '15-05-2003', 82);

DELETE FROM Avion WHERE immat = 'F-WTSS';

SELECT * FROM Affreter;


DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Pilote;
DROP TABLE Compagnie;

--- ON DELETE SET NULL

CREATE TABLE Compagnie
	(comp CHAR(4), nrue NUMBER(3), rue CHAR(20), ville CHAR(15), nomComp CHAR(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet CHAR(6), nom CHAR(15), nbHVol NUMBER(7,2), compa CHAR(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp)
	 ON DELETE SET NULL);

CREATE TABLE Avion
	(immat CHAR(6), typeAvion CHAR(15), nbhVol NUMBER(10,2), proprio CHAR(4),
	CONSTRAINT pk_Avion PRIMARY KEY(immat),
	CONSTRAINT nn_proprio CHECK (proprio IS NOT NULL),
	CONSTRAINT fk_Avion_comp_Compag FOREIGN KEY(proprio) REFERENCES Compagnie(comp));

CREATE TABLE Affreter
	(compAff CHAR(4), immat CHAR(6), dateAff DATE, nbPax NUMBER(3),
	CONSTRAINT pk_Affreter PRIMARY KEY (compAff, immat, dateAff),
	CONSTRAINT fk_Aff_na_Avion FOREIGN KEY(immat) REFERENCES Avion(immat),
	CONSTRAINT fk_Aff_comp_Compag FOREIGN KEY(compAff) REFERENCES Compagnie(comp));


INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');


INSERT INTO Pilote
 VALUES ('PL-1', 'Amlie Sulpice', 450, 'AF');
INSERT INTO Pilote
 VALUES ('PL-2', 'Thomas Sulpice', 900, 'AF');
INSERT INTO Pilote
 VALUES ('PL-3', 'Paul Soutou', 1000, 'SING');

DELETE FROM Compagnie WHERE comp = 'AF';

SELECT * FROM Pilote;

DROP TABLE Affreter;
DROP TABLE Avion;
DROP TABLE Pilote;
DROP TABLE Compagnie;


