
CREATE TABLE Affreter
	(numAff  NUMBER(5),comp VARCHAR2(4), immat VARCHAR2(6), dateAff DATE, nbPax NUMBER(3),
	CONSTRAINT pk_Affreter PRIMARY KEY (numAff));

CREATE TABLE Passager
	(numPax NUMBER(6), nom VARCHAR2(15), siege VARCHAR2(4), dernierVol NUMBER(5),
	CONSTRAINT pk_Passager PRIMARY KEY(numPax),
	CONSTRAINT fk_Pax_vol_Affreter FOREIGN KEY(dernierVol) REFERENCES Affreter(numAff));

CREATE SEQUENCE seqAff
  MAXVALUE 10000
  NOMINVALUE;

CREATE SEQUENCE seqPax
  INCREMENT BY 10
  START WITH 100
  MAXVALUE 100000
  NOMINVALUE;

-- ALTER

SELECT seqAff.CURRVAL "seqaff CUR" FROM DUAL;
SELECT seqPax.CURRVAL "seqPax CUR" FROM DUAL;


INSERT INTO Affreter VALUES (seqAff.NEXTVAL,'AF', 'F-WTSS', '13-05-2003', 85);

SELECT seqAff.CURRVAL "seqaff CUR" FROM DUAL;
SELECT seqPax.CURRVAL "seqPax CUR" FROM DUAL;


INSERT INTO Affreter VALUES (seqAff.NEXTVAL,'SING', 'F-GAFU', '05-02-2003', 155);

SELECT seqAff.CURRVAL "seqaff CUR" FROM DUAL;
SELECT seqPax.CURRVAL "seqPax CUR" FROM DUAL;

SELECT * FROM Affreter ;

INSERT INTO Passager VALUES (seqPax.NEXTVAL, 'Payrissat', '7A', seqAff.CURRVAL);

SELECT seqAff.CURRVAL "seqaff CUR" FROM DUAL;
SELECT seqPax.CURRVAL "seqPax CUR" FROM DUAL;

INSERT INTO Affreter VALUES (seqAff.NEXTVAL,'AF', 'F-WTSS', '15-05-2003', 82);

SELECT seqAff.CURRVAL "seqaff CUR" FROM DUAL;
SELECT seqPax.CURRVAL "seqPax CUR" FROM DUAL;

SELECT * FROM Passager ;
SELECT * FROM Affreter ;

INSERT INTO Passager VALUES (seqPax.NEXTVAL, 'Castaings', '2E', seqAff.CURRVAL);

SELECT * FROM Passager ;

SELECT seqAff.CURRVAL "seqAff (CURRVAL)" ,
       seqPax.CURRVAL "seqPax  (CURRVAL)" FROM DUAL;

SELECT seqAff.NEXTVAL "seqAff (NEXTVAL)", 
       seqPax.NEXTVAL "seqPax (NEXTVAL)" FROM DUAL;
--

ALTER SEQUENCE seqAff INCREMENT BY 5 MAXVALUE 850;

ALTER SEQUENCE seqPax INCREMENT BY 5 MAXVALUE 95000;

DROP SEQUENCE seqAff;
DROP SEQUENCE seqPax;

DROP TABLE Passager;
DROP TABLE Affreter;

-- DEFAULT Values Using Sequences

CREATE SEQUENCE master_seq;
CREATE SEQUENCE detail_seq;

CREATE TABLE vol (
  id          NUMBER DEFAULT master_seq.NEXTVAL,
  description VARCHAR2(6),
  jour_vol    DATE);

CREATE TABLE places (
  id       NUMBER DEFAULT detail_seq.NEXTVAL,
  vol_id   NUMBER DEFAULT master_seq.CURRVAL,
  pax_nom  VARCHAR2(30));

INSERT INTO vol (description,jour_vol) VALUES ('AF6143',SYSDATE-1);
INSERT INTO places (pax_nom) VALUES ('Joppe');
INSERT INTO places (pax_nom) VALUES ('Rienna');
INSERT INTO places (pax_nom) VALUES ('Guilbaud');

COL description FORMAT A15
SELECT * FROM vol;
SELECT * FROM places;

DROP TABLE places ;
DROP TABLE vol;

DROP SEQUENCE master_seq;
DROP SEQUENCE detail_seq;

-- col auto incremente

-- GENERATED [ ALWAYS | BY DEFAULT [ ON NULL ] ] AS IDENTITY [ ( identity_options ) ]


DROP TABLE billets ;

CREATE TABLE billets (
  id         NUMBER(6) GENERATED ALWAYS AS IDENTITY NOT NULL,
  vol_id     VARCHAR2(6) NOT NULL,
  jour_vol   DATE DEFAULT SYSDATE NOT NULL,
  pax_nom    VARCHAR2(30) NOT NULL,
  siege_pax  CHAR(3) NOT NULL,
  CONSTRAINT pk_billets PRIMARY KEY(id));

INSERT INTO billets(vol_id,pax_nom,siege_pax) 
  VALUES           ('AF6143','Guilbaud','03F');

INSERT INTO billets(vol_id,pax_nom,siege_pax) 
  VALUES           ('AF6145','Blanchet','23B');

INSERT INTO billets(vol_id,pax_nom,siege_pax) 
  VALUES           ('AF6145','Bruchez','02A');

col siege_pax format A10

SELECT * FROM billets;

-- essai forcer

INSERT INTO billets(id,vol_id,pax_nom,siege_pax) 
  VALUES           (14,'AF6150','Thiriet','24A');

--> possible avec BY DEFAULT si pas doublon pk

DROP TABLE billets ;





