
set lines 130 pages 50 

--

DROP TABLE vol_jour ;
DROP TABLE compagnie;

CREATE TABLE compagnie
(comp               VARCHAR2(4), 
 nom_comp           VARCHAR2(15), 
 date_creation      DATE CONSTRAINT nn_date_crea NOT NULL,
 CONSTRAINT pk_compagnie PRIMARY KEY(comp),
 CONSTRAINT un_nom_comp  UNIQUE(nom_comp));

CREATE TABLE vol_jour 
 (num_vol      VARCHAR2(6)  NOT NULL,
  aero_dep     VARCHAR2(3)  CONSTRAINT nn_depart NOT NULL ,
  aero_arr     VARCHAR2(3)  CONSTRAINT nn_arrivee NOT NULL ,
  comp         VARCHAR2(4)  DEFAULT 'AF',
  jour_vol     DATE         NOT NULL,
  nb_passagers NUMBER(3),
  CONSTRAINT   pk_vol_jour  PRIMARY KEY(num_vol, jour_vol),
  CONSTRAINT   fk_vol_jour_comp_compagnie FOREIGN KEY(comp) 
               REFERENCES   compagnie(comp),
  CONSTRAINT   ck_nb_pax    CHECK (nb_passagers>0),
  CONSTRAINT   ck_trajet    CHECK (aero_dep != aero_arr));


INSERT INTO compagnie
  VALUES ('SING', 'Singapore AL', TO_DATE('19470101','YYYYMMDD'));

INSERT INTO compagnie(nom_comp, comp, date_creation)
  VALUES ('Air France', 'AF', TO_DATE('19330101','YYYYMMDD'));

INSERT INTO compagnie(nom_comp, comp, date_creation)
  VALUES (NULL, 'GO', TO_DATE('20141231','YYYYMMDD'));

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,jour_vol,nb_passagers)
  VALUES ('AF6143', 'TLS', 'ORY', TO_DATE('20141120 15:30','YYYYMMDD HH24:MI'),120);

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,jour_vol)
  VALUES ('AF6145', 'ORY', 'TLS', TO_DATE('20141120 18:45','YYYYMMDD HH24:MI'));

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('SQ747', 'CDG', 'SIN', 'SING', TO_DATE('20141120 19:30','YYYYMMDD HH24:MI'),NULL);

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('AF6550', 'CDG', 'TLS', DEFAULT, TO_DATE('20141120 20:00','YYYYMMDD HH24:MI'),195);


COMMIT;

select * from compagnie;

select * from vol_jour;


--pk

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('AF6550', 'AGN', 'TLS', 'AF', TO_DATE('20141120 20:00','YYYYMMDD HH24:MI'),95);

-- nn

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('AF6530', 'AGN', NULL, 'AF', TO_DATE('20141120 10:00','YYYYMMDD HH24:MI'),95);


-- CK

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('AF6530', 'AGN', 'AGN', 'AF', TO_DATE('20141120 10:00','YYYYMMDD HH24:MI'),95);

-- FK

INSERT INTO vol_jour 
        (num_vol,aero_dep,aero_arr,comp,jour_vol,nb_passagers)
  VALUES ('AF6530', 'AGN', 'TLS', 'BA', TO_DATE('20141120 10:00','YYYYMMDD HH24:MI'),95);




---Dates

-- SELECT TO_CHAR(sysdate+80,'DD Month YYYY HH24:MI') FROM DUAL;

DROP TABLE Pilote;

CREATE TABLE pilote
(brevet    VARCHAR2(6),  
 prenom    VARCHAR2(20) NOT NULL, 
 nom       VARCHAR2(20) NOT NULL,  
 date_nais DATE NOT NULL,    
 embauche  DATE NOT NULL,
 CONSTRAINT pk_pilote PRIMARY KEY(brevet));


INSERT INTO Pilote(brevet, prenom, nom, date_nais, embauche)
VALUES ('B1', 'Christian', 'Mermoz', TO_DATE('05/02/1965','DD/MM/YYYY'),SYSDATE);

INSERT INTO Pilote(brevet, prenom, nom, date_nais, embauche)
VALUES ('B2', 'Christian', 'Mermoz', TO_DATE('19650205','YYYYMMDD'), TRUNC(SYSDATE));


DROP TABLE Pilote;

SELECT TO_DATE('05-02-1965:06:30','DD-MM-YYYY:HH24:MI') FROM DUAL;

--

CREATE TABLE Evenements
(arrive TIMESTAMP, arriveLocalement TIMESTAMP WITH TIME ZONE);

INSERT INTO Evenements(arrive, arriveLocalement)
  VALUES (TIMESTAMP '1965-02-05 09:30:02.12345', TIMESTAMP '1965-01-16 12:30:05.98 + 4:30');

DROP TABLE Evenements;

--

CREATE TABLE Durees
 (dureeAnneesMois INTERVAL YEAR TO MONTH, dureeJourSecondes INTERVAL DAY TO SECOND);

INSERT INTO Durees(dureeAnneesMois, dureeJourSecondes)
  VALUES ('1-7', '5 15:13:56.97');

DROP TABLE Durees;

SELECT CURRENT_DATE, LOCALTIMESTAMP, SYSTIMESTAMP, DBTIMEZONE, SESSIONTIMEZONE FROM DUAL;

----NCHAR
/*
-- Locate sqldeveloper.conf, and add the following lines:
-- C:\Program Files (x86)\sqldeveloper\sqldeveloper\bin
AddVMOption -Doracle.jdbc.defaultNChar=true 
AddVMOption -Doracle.jdbc.convertNcharLiterals=true

*/

SELECT UNISTR('\00A9') FROM DUAL;

SELECT UNISTR('\0930\0941\092A\092F\093E') FROM DUAL;


CREATE TABLE CaracteresUnicode (col1 NVARCHAR2(10), col2 NVARCHAR2(10));

INSERT INTO CaracteresUnicode(col1,col2) VALUES(N'copyright', UNISTR('\00A9'));

INSERT INTO CaracteresUnicode(col1,col2) VALUES(N'du hindi', UNISTR('\0930\0941\092A\092F\093E'));

--> Le caractre ?????'

SELECT * FROM CaracteresUnicode ;

DROP TABLE CaracteresUnicode;

---------BLOB


--sous SYSTEM
connect system/manager@cxbdsoutou

GRANT CREATE ANY DIRECTORY TO soutou;

connect soutou/ingres@cxbdsoutou

CREATE TABLE Trombinoscope (nomEtudiant VARCHAR(30), photo BFILE);

CREATE DIRECTORY repertoire_etudiants AS 'D:\PhotosEtudiant';

INSERT INTO Trombinoscope
   VALUES ('Soutou', BFILENAME('repertoire_etudiants', 'photoCS.jpg'));

--pas de contrle ni d'existence ni si le rpertoire ou le fichier est supprim
INSERT INTO Trombinoscope
   VALUES ('Soutou', BFILENAME('repertoire_etudiants', 'ttt.jpg'));

DROP TABLE Trombinoscope;


---UPDATE

UPDATE compagnie
SET    nom_comp      = 'Go Airways',
       date_creation = TO_DATE('30/12/2014','DD/MM/YYYY')
WHERE comp = 'GO';

UPDATE vol_jour
SET    nb_passagers = 10
WHERE  nb_passagers = NULL;

UPDATE vol_jour
SET    nb_passagers = 10
WHERE  nb_passagers IS NULL;

COMMIT;

--pk

UPDATE compagnie
SET    comp = 'AF'
WHERE  comp = 'GO';

--nn

UPDATE vol_jour
SET    aero_dep = NULL
WHERE  num_vol  = 'AF6143';

--ck

UPDATE vol_jour
SET    aero_arr = 'TLS'
WHERE  num_vol  = 'AF6143';

--un

UPDATE compagnie
SET    nom_comp = 'Go Airways'
WHERE  comp = 'AF';

--fk

UPDATE vol_jour
SET    comp = 'EJET'
WHERE  num_vol  = 'AF6143';

-- modif de cl trangre possible 

UPDATE vol_jour
SET    comp     = 'GO'
WHERE  num_vol  = 'AF6143';

UPDATE vol_jour
SET    comp     = 'AF'
WHERE  num_vol  = 'AF6143';

-- modif de cl primaire possible si pas rfrence

UPDATE compagnie
SET    comp = 'GOA'
WHERE  comp = 'GO';

rollback;

---dates

CREATE TABLE Pilote
	(brevet VARCHAR(6), nom VARCHAR(20), dateNaiss DATE, dernierVol DATE,
	 dateEmbauche DATE, prochainVolControle DATE, nombreJoursNaisBoulot NUMBER,
	 intervalleNaisBoulot       INTERVAL DAY(7) TO SECOND(3), 
	 intervalleVolExterieur     INTERVAL DAY(2) TO SECOND(0),
	 intervalleEntreVols        INTERVAL DAY(2) TO SECOND(2),
	 intervalleEmbaucheControle INTERVAL DAY(2) TO SECOND(1),
	 compa VARCHAR(4), CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote
	VALUES ('PL-1', 'Thierry Albaric', '25-03-1967', '10-04-2003', SYSDATE, 
	TO_DATE('13-05-2003 15:30:00','DD:MM:YYYY HH24:MI:SS'), NULL, NULL, NULL, NULL, NULL, 'AF');

--et le thme astral...
UPDATE  Pilote
	SET dateNaiss = TO_DATE('25-03-1967 12:35:00', 'DD:MM:YYYY HH24:MI:SS') 
	WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateNaiss,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

--revenez la semaine prochaine + 10minutes , on vous crira srement d'ici l
UPDATE  Pilote
	SET dateEmbauche = dateEmbauche+7+(10/(24*60))  WHERE brevet = 'PL-1';

SELECT nom, TO_CHAR(dateEmbauche,'DD:MM:YYYY HH:MI:SS') FROM Pilote;

SELECT dateEmbauche-dateNaiss FROM Pilote;

--Attendre avant la premire paye
UPDATE  Pilote
	SET nombreJoursNaisBoulot = dateEmbauche-dateNaiss WHERE brevet = 'PL-1';


SELECT nombreJoursNaisBoulot  FROM Pilote;

--au format intervalle

UPDATE  Pilote
	SET intervalleNaisBoulot = NUMTODSINTERVAL(dateEmbauche-dateNaiss,'DAY'),
             intervalleEntreVols = NUMTODSINTERVAL(prochainVolControle-dernierVol,'DAY'),
		intervalleVolExterieur =  NUMTODSINTERVAL(dateEmbauche-dernierVol,'DAY')
	 WHERE brevet = 'PL-1';

SELECT intervalleNaisBoulot FROM Pilote;

--au format intervalle entre vol

SELECT intervalleEntreVols FROM Pilote;


--intervalleVolExterieur     

SELECT intervalleVolExterieur FROM Pilote;

--intervalleEmbaucheControle     
UPDATE  Pilote
SET intervalleEmbaucheControle =   intervalleEntreVols - intervalleVolExterieur
	 WHERE brevet = 'PL-1';

SELECT intervalleEmbaucheControle FROM Pilote;

SELECT TO_CHAR(dateNaiss ,'J')  FROM Pilote;

SELECT TO_CHAR(dateNaiss ,'DAY - MONTH - YEAR')  FROM Pilote;

SELECT TO_CHAR(dateEmbauche ,'DDD')  FROM Pilote;

SELECT TO_DATE('May 13, 1995, 12:30 A.M.','MONTH DD, YYYY, HH:MI A.M.','NLS_DATE_LANGUAGE = American')
     FROM DUAL;

SELECT TO_DATE('13 Mai, 1995, 12:30','DD MONTH, YYYY, HH24:MI','NLS_DATE_LANGUAGE = French')
     FROM DUAL;


SELECT EXTRACT(DAY FROM intervalleVolExterieur) FROM Pilote;
SELECT EXTRACT(MONTH FROM dateNaiss) FROM Pilote;

SELECT NUMTOYMINTERVAL (1.54, 'YEAR') FROM DUAL;

SELECT NUMTOYMINTERVAL (1.54, 'MONTH') FROM DUAL;

SELECT NUMTODSINTERVAL(1.54,'DAY') FROM DUAL;

SELECT NUMTODSINTERVAL(1.54,'HOUR') FROM DUAL;


DROP TABLE Pilote;

---  DELETE


select * from compagnie;

select * from vol_jour;


DELETE FROM compagnie WHERE nom_comp = 'Go Airways';

DELETE FROM vol_jour 
WHERE  jour_vol = TO_DATE('20/11/2014 15:30','DD/MM/YYYY HH24:MI')
AND    num_vol  = 'AF6143';



DROP TABLE Pilote;
DROP TABLE vol_jour;
DROP TABLE compagnie;

