---MERGE

DROP TABLE Vol ;
DROP TABLE Primes;

CREATE TABLE Primes
	(brevet CHAR(6), nom CHAR(20), grade CHAR(5), paye NUMBER(7,2), compa CHAR(4));

CREATE TABLE Vol 
	(brevet CHAR(6), dateVol DATE, bonus NUMBER(3));

INSERT INTO Primes VALUES ('PL-1', 'Aurlia Ente', 'CDB',  100, 'AF');
INSERT INTO Primes VALUES ('PL-2', 'Agns Bidal', 'PIL', 80, 'AF');
INSERT INTO Primes VALUES ('PL-3', 'Sylvie Payrissat', 'CDB', 20, 'SING');


INSERT INTO Vol VALUES ('PL-1', SYSDATE-10, 50);
INSERT INTO Vol VALUES ('PL-2', SYSDATE-5,    40);
INSERT INTO Vol VALUES ('PL-3', SYSDATE,  30);
INSERT INTO Vol VALUES ('PL-4', SYSDATE,    20);

SELECT * FROM Vol ;
SELECT * FROM Primes ;

MERGE INTO Primes p
   USING (SELECT brevet, bonus FROM Vol) v
   ON    (p.brevet = v.brevet)
   WHEN MATCHED THEN
         UPDATE SET p.paye = p.paye + v.bonus WHERE grade = 'CDB'
        DELETE WHERE paye < 90
   WHEN NOT MATCHED THEN INSERT (brevet, paye) VALUES (v.brevet, v.bonus);


SELECT * FROM Vol ;
SELECT * FROM Primes ;


SQL> SELECT * FROM Primes ;

BREVET NOM                  GRADE       PAYE COMP
------ -------------------- ----- ---------- ----
PL-1   Aurlia Ente         CDB          150 AF
PL-2   Agns Bidal          PIL           80 AF
PL-4                                      20

DROP TABLE Vol ;
DROP TABLE Primes;