

DROP TRIGGER TrigPassagerConducteur;


CREATE TRIGGER TrigPassagerConducteur
BEFORE INSERT ON transporter
FOR EACH ROW
DECLARE 
	v_nbre NUMBER;
BEGIN
	SELECT cOUNT(n_conducteur) INTO v_nbre
	FROM visite
	WHERE n_conducteur = :NEW.n_transporte
	AND  TO_CHAR(date_jour,'DD/MM/YYYY') = TO_CHAR(:NEW.date_jour,'DD/MM/YYYY')
	AND  n_vehicule = :NEW.n_vehicule;
	IF (v_nbre > 0) THEN
	   RAISE_APPLICATION_ERROR(-20102,'Le passager' ||  :NEW.n_transporte || ' est dj conducteur de la visite!');
	END IF;
END;
/


--Tests

SET SERVEROUT ON

--test visite passager dj conducteur

INSERT INTO transporter VALUES ('CH1','V1','01/04/2008','E1');

--correction sur le passager

INSERT INTO transporter VALUES ('CH1','V1','01/04/2008','E2');

SELECT * FROM transporter;

--


CREATE TRIGGER TrigcapaciteVehicule FOR INSERT ON transporter
 COMPOUND TRIGGER
   v_nbrePassagers NUMBER := 0;
   v_nbreMax       NUMBER := 0;
   v_nom           employe.nom_emp%TYPE;
   TYPE trajets_rec IS RECORD 
	(n_chantier transporter.n_chantier%TYPE,
	n_vehicule transporter.n_vehicule%TYPE,
	date_jour DATE, nbre_transporte NUMBER);
   TYPE trajets_tytab IS TABLE OF trajets_rec INDEX BY SIMPLE_INTEGER;
   tab_trajets trajets_tytab;
   CURSOR curseur IS 
	SELECT  n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;
   v_indice NUMBER          := 1;
   v_trouve BOOLEAN         := FALSE;
   v_nombre_trajets NUMBER  := 0;
 BEFORE STATEMENT IS
  BEGIN
        FOR enreg IN curseur LOOP
	   tab_trajets(v_indice) := enreg;
--            DBMS_OUTPUT.PUT_LINE('indice : ' || v_indice || ' chantier : ' || tab_trajets(v_indice).n_chantier );
            v_indice := v_indice +1;
	END LOOP;
  END BEFORE STATEMENT;
  --
  AFTER STATEMENT IS
  BEGIN
      DBMS_OUTPUT.PUT_LINE('Trajets trait(s) : ' || v_nombre_trajets );
   END AFTER STATEMENT;
   --
  BEFORE EACH ROW IS 
   BEGIN
      v_nombre_trajets := v_nombre_trajets +1;
      SELECT nom_emp INTO v_nom FROM employe WHERE n_emp = :NEW.n_transporte;
	SELECT capacite INTO v_nbreMax     
		FROM vehicule
		WHERE n_vehicule = :NEW.n_vehicule;
    DBMS_OUTPUT.PUT_LINE('Enregistrement du transport de : ' ||  v_nom );
    v_indice := 1;
     WHILE (NOT v_trouve AND NOT (v_indice > tab_trajets.COUNT) ) LOOP
--	 DBMS_OUTPUT.PUT_LINE('recherche  indice : ' || v_indice);  
	IF (tab_trajets(v_indice).n_chantier = :NEW.n_chantier 
	AND tab_trajets(v_indice).n_vehicule = :NEW.n_vehicule
	AND TO_CHAR(tab_trajets(v_indice).date_jour,'DD/MM/YYYY') = TO_CHAR(:NEW.date_jour,'DD/MM/YYYY') ) THEN
		 DBMS_OUTPUT.PUT_LINE('Trouve  indice : ' || v_indice);   
		v_trouve := TRUE;
		v_nbrePassagers := tab_trajets(v_indice).nbre_transporte;
	END IF;     
	v_indice := v_indice +1;
    END LOOP;
     IF (NOT v_trouve) THEN 
		 DBMS_OUTPUT.PUT_LINE('Premier trajet de la visite.');  
--		 DBMS_OUTPUT.PUT_LINE('v_nbrePassagers' || v_nbrePassagers || ' v_nbreMax  ' || v_nbreMax );  
     END IF;
     IF (v_nbrePassagers = v_nbreMax) THEN
		RAISE_APPLICATION_ERROR (num => -20101,
			msg => 'Capacit max atteinte (' || v_nbreMax || ')  pour la visite : '||:NEW.n_chantier || ' du '
				|| TO_CHAR(:NEW.date_jour,'DD/MM/YYYY') || ' vhicule : ' || :NEW.n_vehicule);
     END IF;   
     IF  NOT (v_nbrePassagers < v_nbreMax) THEN
		RAISE_APPLICATION_ERROR (num => -20100,
			msg => 'BASE INCORRECTE : Capacit dpasse (' || v_nbreMax || ') pour la visite : '||:NEW.n_chantier || ' du '
				|| TO_CHAR(:NEW.date_jour,'DD/MM/YYYY') || ' vhicule : ' || :NEW.n_vehicule);
     END IF;    
  END BEFORE EACH ROW;
  --
  AFTER EACH ROW IS
  BEGIN
      DBMS_OUTPUT.PUT_LINE('Transport de : ' ||  v_nom || ' bien enregistr.');   
      DBMS_OUTPUT.PUT_LINE('Il ne reste plus que : ' || (v_nbreMax-v_nbrePassagers-1) || 
	' place(s) disponible(s).');
  END AFTER EACH ROW;
END TrigcapaciteVehicule;
/


--Tests

SET SERVEROUT ON

--test 1ere visite vhicule capacit 1 conducteur + 1 passager

SELECT * FROM visite;

SELECT n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;

INSERT INTO visite (n_chantier,n_vehicule,date_jour,kilometres,n_conducteur)
	VALUES ('CH1','V3',TO_DATE(TO_CHAR(SYSDATE,'DD-MM-YYYY'), 'DD-MM-YYYY'), 42, 'E1');

INSERT INTO transporter VALUES ('CH1','V3',TO_DATE(TO_CHAR(SYSDATE,'DD-MM-YYYY'), 'DD-MM-YYYY'),'E2');

SELECT n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;

SELECT * FROM visite;

SELECT * FROM transporter ;

--test dpassement capacit

INSERT INTO transporter VALUES ('CH1','V3',TO_DATE(TO_CHAR(SYSDATE,'DD-MM-YYYY'), 'DD-MM-YYYY'),'E3');


--test 2eme visite pour une voiture 3 places

SELECT * FROM visite;

SELECT n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;

INSERT INTO transporter VALUES ('CH2','V5','03-04-2008','E8');

SELECT n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;

SELECT * FROM visite;

--test capacit dj dpasse 

ALTER TRIGGER TrigcapaciteVehicule DISABLE;

--dpassement capacit

INSERT INTO transporter VALUES ('CH1','V3',TO_DATE(TO_CHAR(SYSDATE,'DD-MM-YYYY'), 'DD-MM-YYYY'),'E3');

ALTER TRIGGER TrigcapaciteVehicule ENABLE;

-- capacit dj dpasse 

SELECT n_chantier,n_vehicule,date_jour,COUNT(n_transporte) 
	FROM transporter 
	GROUP BY n_chantier,n_vehicule,date_jour;

INSERT INTO transporter VALUES ('CH1','V3',TO_DATE(TO_CHAR(SYSDATE,'DD-MM-YYYY'), 'DD-MM-YYYY'),'E4');



