
spool req

--Numro et nom des conducteurs qui taient sur la route le 1//4/2008

SELECT n_emp, nom_emp 
	FROM employe
	WHERE n_emp IN (SELECT n_conducteur FROM visite
		WHERE TO_DATE(date_jour) = TO_DATE('01/04/2008'));


--Numro et nom des passagers qui ont visits un chantier le 1//4/2008

SELECT n_emp, nom_emp 
	FROM employe
	WHERE n_emp IN (SELECT n_transporte FROM transporter
		WHERE TO_DATE(date_jour) = TO_DATE('01/04/2008'));


--En dduire le numro et nom des employs qui n'ont pas boug le 1//4/2008

SELECT n_emp, nom_emp FROM employe 
MINUS
SELECT n_emp, nom_emp 
	FROM employe
	WHERE n_emp IN (SELECT n_transporte FROM transporter
		WHERE TO_DATE(date_jour) = TO_DATE('01/04/2008'))
MINUS
SELECT n_emp, nom_emp 
	FROM employe
	WHERE n_emp IN (SELECT n_conducteur FROM visite
		WHERE TO_DATE(date_jour) = TO_DATE('01/04/2008'));

-- Numro des chantiers visits les entre le 2 et le 3 du mois
-- (d'une anne et d'un mois donn) avec le nombre de visites pour chacun deux 

SELECT n_chantier, date_jour,COUNT(n_vehicule)
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
	AND EXTRACT(DAY FROM date_jour) BETWEEN 2 AND 3 
	GROUP BY n_chantier, date_jour
	ORDER BY 1,2;

--En dduire les chantiers les plus visits

SELECT n_chantier, date_jour,COUNT(n_vehicule)
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
	AND EXTRACT(DAY FROM date_jour) BETWEEN 2 AND 3 
	GROUP BY n_chantier, date_jour
	HAVING COUNT(n_vehicule) = (SELECT MAX(COUNT(n_vehicule))
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
	AND EXTRACT(DAY FROM date_jour) BETWEEN 2 AND 3 
	GROUP BY n_chantier, date_jour);

-- Nombre de visites des employs (transports comme conducteur) pour un mois donn

SELECT n_conducteur,COUNT(n_chantier) "Nbre visite"
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
GROUP BY n_conducteur
UNION
SELECT n_transporte,COUNT(n_chantier)
	FROM transporter
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
GROUP BY n_transporte
ORDER BY 2 DESC;

-- Temps de conduite des conducteurs d'un mois donn

SELECT n_conducteur,SUM(temps_trajet) "Temps trajet"
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
GROUP BY n_conducteur
ORDER BY 2 DESC;

--Numro du conducteur qui a fait le plus de kilomtrage dans l'anne
--et kilomtrage total

SELECT n_conducteur,SUM(temps_trajet) "Temps trajet"
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY') = '2008'
GROUP BY n_conducteur
HAVING SUM(temps_trajet) = 
    (SELECT MAX(SUM(temps_trajet))
	FROM visite WHERE TO_CHAR(date_jour,'YYYY') = '2008' GROUP BY n_conducteur);


--Nom et qualification du Conducteur autoris  tous types de vhicule

SELECT e.nom_emp,e.qualif_emp FROM employe e
  WHERE NOT EXISTS
	(SELECT d.type_vehicule
	 FROM   droitsconduite d
	 WHERE  d.n_conducteur = e.n_emp
	MINUS
	 SELECT DISTINCT(type_vehicule) 
	 FROM   vehicule)
  AND NOT EXISTS
	(SELECT DISTINCT(type_vehicule) 
	 FROM   vehicule
	MINUS
	SELECT d.type_vehicule
	 FROM   droitsconduite d
	 WHERE  d.n_conducteur = e.n_emp);

spool off





