/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

class Win3BitmapHeader {
    int size;
    int width;
    int height;
    short planes;
    short bitsPerPixel;
    int compression;
    int sizeOfBitmap;
    int horzResolution;
    int vertResolution;
    int colorsUsed;
    int colorsImportant;
    boolean topDown;
    int actualSizeOfBitmap;
    int scanLineSize;
    int actualColorsUsed;
    int noOfPixels;

    public void read(SwappedDataInputStream dis) throws IOException, Exception {
        this.size = dis.readInt();
        this.width = dis.readInt();
        this.height = dis.readInt();
        this.planes = dis.readShort();
        this.bitsPerPixel = dis.readShort();
        this.compression = dis.readInt();
        this.sizeOfBitmap = dis.readInt();
        this.horzResolution = dis.readInt();
        this.vertResolution = dis.readInt();
        this.colorsUsed = dis.readInt();
        this.colorsImportant = dis.readInt();
        this.topDown = this.height < 0;
        this.noOfPixels = this.width * this.height;
        this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
        this.actualSizeOfBitmap = this.sizeOfBitmap != 0 ? this.sizeOfBitmap : this.scanLineSize * this.height;
        this.actualColorsUsed = this.colorsUsed != 0 ? this.colorsUsed : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
    }

    Win3BitmapHeader() {
    }
}

