/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public final class IncrementalTOC
extends Applet {
    private static Hashtable imageDictionary = new Hashtable();
    private TreeView treeView;
    private WrappingTextPanel docPanel;
    private KSLSplitterPanel splitter;
    private Utilities utils;
    Checkbox checkbox1;

    void checkbox1_Action(Event event) {
        if (this.checkbox1.getState()) {
            this.splitter.showBottomPanel();
        } else {
            this.splitter.hideBottomPanel();
        }
    }

    public void init() {
        InputStream contents;
        URL url;
        super.init();
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(267, 500);
        this.setBackground(new Color(0xFFFFFF));
        this.checkbox1 = new Checkbox("");
        this.checkbox1.setBounds(0, 0, 267, 23);
        this.checkbox1.setFont(new Font("Dialog", 0, 12));
        this.checkbox1.setBackground(new Color(0xC0C0C0));
        this.add("North", this.checkbox1);
        this.checkbox1.setState(true);
        String contentsFile = this.getParameter("contents");
        try {
            url = new URL(this.getCodeBase(), Utilities.encode(contentsFile));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("Improper URL: " + contentsFile);
            return;
        }
        try {
            contents = url.openStream();
        }
        catch (IOException iOException) {
            System.out.println("Error opening connection to " + contentsFile);
            return;
        }
        try {
            LineInputStream inputStream = new LineInputStream(contents);
            String aLine = inputStream.readLine().trim();
            this.checkbox1.setLabel(aLine);
            this.parseContents(null, inputStream, true);
        }
        catch (IOException iOException) {
            System.out.println("Error parsing contents file " + contentsFile);
            return;
        }
        this.docPanel = new WrappingTextPanel();
        this.splitter = new KSLSplitterPanel(this.treeView, this.docPanel, true);
        this.add("Center", this.splitter);
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.checkbox1 && event.id == 1001) {
            this.checkbox1_Action(event);
            return true;
        }
        if (event.target == this.treeView) {
            if (event.id == 701) {
                TreeNode t = (TreeNode)event.arg;
                this.docPanel.setText(t.getDocumentation());
                return true;
            }
            if (event.id == 1001) {
                URL theUrl;
                TreeNode t = this.treeView.getSelectedNode();
                if (t != null && (theUrl = t.getUrlHTML()) != null) {
                    URL newUrl;
                    String u = theUrl.toString();
                    int fIdx = u.indexOf(":/\\");
                    if (fIdx >= 0) {
                        String tail = u.substring(fIdx + 4);
                        String head = u.substring(0, fIdx + 2);
                        String sUrl = String.valueOf(head) + "/" + tail;
                        try {
                            newUrl = new URL(sUrl);
                        }
                        catch (MalformedURLException malformedURLException) {
                            System.out.println("Improper URL: " + sUrl);
                            return true;
                        }
                    } else {
                        newUrl = theUrl;
                    }
                    AppletContext context = this.getAppletContext();
                    context.showDocument(newUrl, "contents_frame");
                }
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void resizeApplet(int width, int height) {
        this.resize(width, height);
        this.invalidate();
        this.validate();
        this.layout();
        this.repaint();
    }

    private void parseContents(TreeNode parent, LineInputStream contents, boolean firstLevel) throws IOException {
        boolean firstNode = true;
        TreeNode lastNode = parent;
        if (firstLevel) {
            this.treeView = new TreeView(this);
        }
        this.treeView.setBackground(Color.white);
        while (!contents.eof()) {
            String linkToName;
            String aLine = contents.readLine().trim();
            if (aLine.equals("(")) {
                this.parseContents(lastNode, contents, false);
                continue;
            }
            if (aLine.equals(")")) {
                return;
            }
            String name = aLine;
            URL urlImage = Utilities.makeURL(this.treeView.getApplet().getCodeBase(), contents.readLine().trim());
            Image image = this.treeView.getImage(urlImage);
            String testName = linkToName = contents.readLine().trim();
            testName.toLowerCase();
            URL urlHTML = testName.startsWith("http:") || testName.startsWith("ftp:") || testName.startsWith("news:") || testName.startsWith("mailto:") ? new URL(Utilities.encode(linkToName)) : Utilities.makeURL(this.getCodeBase(), linkToName);
            URL urlTXT = Utilities.makeURL(this.getCodeBase(), contents.readLine().trim());
            String subContents = contents.readLine().trim();
            URL urlSubContents = Utilities.makeURL(this.getCodeBase(), subContents);
            String contentsDirectory = contents.readLine().trim();
            TreeNode prevNode = lastNode;
            lastNode = new TreeNode(name, image, urlHTML, urlTXT, urlSubContents, contentsDirectory);
            if (firstLevel) {
                if (firstNode) {
                    this.treeView.addRoot(lastNode);
                    firstNode = false;
                    continue;
                }
                this.treeView.insert(lastNode, prevNode, 1);
                continue;
            }
            this.treeView.insert(lastNode, parent, 0);
        }
    }
}

