/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;

public class KSLSplitterPanel
extends Panel {
    private Dimension curDim;
    private Point curLoc;
    private boolean dimChanged = true;
    private Panel topPanel;
    private int lastTopHeight;
    private int lastBottomHeight;
    private Panel bottomPanel;
    private boolean displayBottomPanel;
    private boolean doMoveSplit;
    private int moveFromY;
    private static final int borderSize = 0;
    private static final int gapSize = 6;
    private static final Color gapColor = Color.lightGray;

    public KSLSplitterPanel(Panel topPanel, Panel bottomPanel, boolean bottomPanelVisible) {
        this.setLayout(null);
        this.topPanel = topPanel;
        this.bottomPanel = bottomPanel;
        this.add(topPanel);
        this.add(bottomPanel);
        this.displayBottomPanel = bottomPanelVisible;
        this.lastTopHeight = 1;
        this.lastBottomHeight = 1;
        this.curDim = new Dimension(-1, -1);
        this.curLoc = new Point(-1, -1);
    }

    public synchronized void layout() {
        this.placeComponents();
    }

    public void placeComponents() {
        this.dimChanged = false;
        int x = 0;
        int topY = 0;
        int width = this.size().width;
        int totalHeight = this.size().height - 6;
        int topHeight = this.displayBottomPanel ? totalHeight * this.lastTopHeight / (this.lastTopHeight + this.lastBottomHeight) : totalHeight;
        this.topPanel.reshape(x, topY, width, topHeight);
        this.topPanel.layout();
        this.topPanel.invalidate();
        this.topPanel.validate();
        this.topPanel.repaint();
        if (this.displayBottomPanel) {
            int bottomY = topY + topHeight + 6;
            int bottomHeight = totalHeight - topHeight;
            this.bottomPanel.reshape(x, bottomY, width, bottomHeight);
            this.bottomPanel.invalidate();
            this.bottomPanel.validate();
            this.bottomPanel.repaint();
        }
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        if (this.curDim.width != width || this.curDim.height != height || this.curLoc.x != x || this.curLoc.y != y) {
            this.dimChanged = true;
            this.curDim.width = width;
            this.curDim.height = height;
            this.curLoc.x = x;
            this.curLoc.y = y;
        }
    }

    public void showBottomPanel() {
        if (!this.displayBottomPanel) {
            this.displayBottomPanel = true;
            this.dimChanged = true;
            this.bottomPanel.show();
            this.repaint();
        }
    }

    public void hideBottomPanel() {
        if (this.displayBottomPanel) {
            this.displayBottomPanel = false;
            this.dimChanged = true;
            this.bottomPanel.hide();
            this.repaint();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.dimChanged) {
            this.placeComponents();
        }
        Dimension d = this.size();
        g.setColor(gapColor);
        g.fillRect(0, 0, d.width, d.height);
        this.drawGap(g);
        super.paint(g);
    }

    public void setLayout(LayoutManager mgr) {
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 503: {
                if (evt.target == this && this.inGap(evt.x, evt.y)) {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                return true;
            }
            case 501: {
                if (evt.target != this || !this.inGap(evt.x, evt.y)) break;
                this.doMoveSplit = true;
                this.moveFromY = evt.y;
                return true;
            }
            case 506: {
                if (!this.doMoveSplit) break;
                return true;
            }
            case 502: {
                if (!this.doMoveSplit) break;
                this.moveSplit(evt.y - this.moveFromY);
                this.doMoveSplit = false;
                return true;
            }
        }
        return super.handleEvent(evt);
    }

    public void moveSplit(int spY) {
        if (spY == 0) {
            return;
        }
        int xTop = this.topPanel.location().x;
        int yTop = this.topPanel.location().y;
        int widthTop = this.topPanel.size().width;
        int heightTop = this.topPanel.size().height + spY;
        int xBottom = this.bottomPanel.location().x;
        int yBottom = this.bottomPanel.location().y + spY;
        int widthBottom = this.bottomPanel.size().width;
        int heightBottom = this.bottomPanel.size().height - spY;
        if (heightTop > 20 && heightBottom > 20) {
            this.topPanel.reshape(xTop, yTop, widthTop, heightTop);
            this.bottomPanel.reshape(xBottom, yBottom, widthBottom, heightBottom);
            this.lastTopHeight = heightTop;
            this.lastBottomHeight = heightBottom;
            this.topPanel.layout();
            this.topPanel.invalidate();
            this.topPanel.validate();
            this.topPanel.repaint();
            this.bottomPanel.layout();
            this.bottomPanel.invalidate();
            this.bottomPanel.validate();
            this.bottomPanel.repaint();
            this.repaint();
        }
    }

    public boolean inGap(int evtX, int evtY) {
        int gapX = 0;
        int gapY = this.bottomPanel.location().y - 6;
        int gapWidth = this.size().width;
        int gapHeight = 6;
        Rectangle gapRect = new Rectangle(gapX, gapY, gapWidth, gapHeight);
        return gapRect.inside(evtX, evtY);
    }

    public void drawGap(Graphics g) {
        int yGap = this.bottomPanel.location().y - 6 + 1;
        g.setColor(Color.white);
        g.fillRect(0, yGap, this.size().width, 1);
        g.setColor(Color.darkGray);
        g.fillRect(0, yGap += 3, this.size().width, 1);
        g.setColor(Color.black);
        g.fillRect(0, ++yGap, this.size().width, 1);
    }
}

