/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public final class TreeNode {
    TreeNode sibling;
    TreeNode child;
    TreeNode parent;
    URL urlHTML;
    URL urlDocumentation;
    URL urlContents;
    String baseDirectory;
    String text;
    String documentation;
    Image image;
    int depth = -1;
    boolean isExpanded = false;
    boolean contentsLoaded = false;
    boolean documentationLoaded = false;
    int numberOfChildren;
    private Utilities utils;

    public TreeNode(String text, Image image, URL urlHTML, URL urlDocumentation, URL urlContents, String contentsDirectory) {
        this.text = text;
        this.sibling = null;
        this.child = null;
        this.image = image;
        this.urlHTML = urlHTML;
        this.urlDocumentation = urlDocumentation;
        this.urlContents = urlContents;
        this.numberOfChildren = 0;
        this.baseDirectory = contentsDirectory;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public boolean isExpandable() {
        return this.child != null || this.urlContents != null;
    }

    public void expand(TreeView treeView) {
        if (this.isExpandable()) {
            if (this.urlContents != null && !this.contentsLoaded) {
                InputStream contents;
                try {
                    contents = this.urlContents.openStream();
                }
                catch (IOException iOException) {
                    System.out.println("Error opening connection to " + this.urlContents.toString());
                    return;
                }
                try {
                    this.parseContents(treeView, this, new LineInputStream(contents));
                }
                catch (IOException iOException) {
                    System.out.println("Error parsing contents file " + this.urlContents.toString());
                    return;
                }
                this.contentsLoaded = true;
                try {
                    contents.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error closing contents file " + this.urlContents.toString());
                }
            }
            this.isExpanded = true;
        }
    }

    public void collapse() {
        this.isExpanded = false;
    }

    public void toggle(TreeView treeView) {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isExpandable()) {
            this.expand(treeView);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    public String getDocumentation() {
        if (!this.documentationLoaded) {
            this.documentation = "";
            if (this.urlDocumentation != null) {
                InputStream docStream;
                try {
                    docStream = this.urlDocumentation.openStream();
                }
                catch (IOException iOException) {
                    return "Error opening connection to " + this.urlDocumentation.toString();
                }
                try {
                    this.documentation = Utilities.readInputStreamAsString(docStream);
                    if (this.documentation.length() == 0) {
                        this.documentation = "No documentation available";
                    }
                }
                catch (IOException iOException) {
                    return "Error reading documentation file " + this.urlDocumentation.toString();
                }
                this.documentationLoaded = true;
                try {
                    docStream.close();
                }
                catch (IOException iOException) {}
            } else {
                this.documentationLoaded = true;
                this.documentation = "No documentation available";
            }
        }
        return this.documentation;
    }

    public URL getUrlHTML() {
        return this.urlHTML;
    }

    public URL getUrlDocumentation() {
        return this.urlDocumentation;
    }

    public URL getUrlContents() {
        return this.urlContents;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    private void parseContents(TreeView treeView, TreeNode parent, LineInputStream contents) throws IOException {
        TreeNode lastNode = parent;
        while (!contents.eof()) {
            String contentsDirectory;
            String aLine = contents.readLine().trim();
            if (aLine.equals("(")) {
                this.parseContents(treeView, lastNode, contents);
                continue;
            }
            if (aLine.equals(")")) {
                return;
            }
            URL codeBase = treeView.getApplet().getCodeBase();
            String name = aLine;
            String sImage = contents.readLine().trim();
            URL urlImage = Utilities.makeURL(codeBase, Utilities.addBase(this.baseDirectory, sImage));
            String linkToName = contents.readLine().trim();
            URL urlHTML = null;
            if (linkToName.length() > 0) {
                String testName = linkToName;
                testName.toLowerCase();
                urlHTML = testName.startsWith("http:") || testName.startsWith("ftp:") || testName.startsWith("news:") || testName.startsWith("mailto:") ? new URL(Utilities.encode(linkToName)) : Utilities.makeURL(codeBase, Utilities.addBase(this.baseDirectory, linkToName));
            }
            String documentation = contents.readLine().trim();
            URL urlDocumentation = null;
            if (documentation.length() > 0) {
                urlDocumentation = Utilities.makeURL(codeBase, Utilities.addBase(this.baseDirectory, documentation));
            }
            String subContents = contents.readLine().trim();
            URL urlSubContents = null;
            if (subContents.length() > 0) {
                urlSubContents = Utilities.makeURL(codeBase, Utilities.addBase(this.baseDirectory, subContents));
            }
            if ((contentsDirectory = contents.readLine().trim()).length() > 0) {
                contentsDirectory = Utilities.addBase(this.baseDirectory, contentsDirectory);
            }
            Image image = treeView.getImage(urlImage);
            lastNode = new TreeNode(name, image, urlHTML, urlDocumentation, urlSubContents, contentsDirectory);
            treeView.insert(lastNode, parent, 0);
        }
    }
}

