/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class TreeView
extends Panel {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    private TreeNode rootNode;
    private TreeNode selectedNode;
    private TreeNode topVisibleNode;
    Scrollbar sbV;
    int sbVPosition;
    int sbVWidth = 16;
    long sbVTimer = -1L;
    private int count;
    private int viewCount;
    private Color bgHighlightColor = new Color(0, 0, 128);
    private Color fgHighlightColor = Color.white;
    private int viewHeight;
    private int viewWidth;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    private FontMetrics fm;
    long timeMouseDown;
    int doubleClickResolution = 333;
    protected Image im1;
    protected Graphics g1;
    private static Hashtable imageDictionary = new Hashtable();
    private Applet myApplet;
    private Vector e;
    private Vector v;

    public TreeView(Applet anApplet) {
        super.setLayout(new BorderLayout());
        this.sbV = new Scrollbar(1);
        this.add("East", this.sbV);
        this.myApplet = anApplet;
    }

    public TreeView(Applet anApplet, TreeNode head) {
        this(anApplet);
        this.addRoot(head);
    }

    public void addRoot(TreeNode head) {
        this.selectedNode = null;
        this.rootNode = head;
        this.count = 1;
    }

    public Image getImage(URL imageUrl) {
        Image theImage = (Image)imageDictionary.get(imageUrl);
        if (theImage == null) {
            theImage = this.myApplet.getImage(imageUrl);
            imageDictionary.put(imageUrl, theImage);
        }
        return theImage;
    }

    public void insert(TreeNode newNode, TreeNode relativeNode, int position) {
        if (newNode == null || relativeNode == null) {
            return;
        }
        if (!this.exists(relativeNode)) {
            return;
        }
        switch (position) {
            case 0: {
                this.addChild(newNode, relativeNode);
                break;
            }
            case 1: {
                this.addSibling(newNode, relativeNode);
                break;
            }
            case 2: {
                this.addSibling(newNode, relativeNode);
                break;
            }
            default: {
                return;
            }
        }
    }

    public Applet getApplet() {
        return this.myApplet;
    }

    public int getCount() {
        return this.count;
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public boolean exists(TreeNode node) {
        this.recount();
        int i = 0;
        while (i < this.count) {
            if (node == this.e.elementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void addChild(TreeNode newNode, TreeNode relativeNode) {
        if (relativeNode.child == null) {
            relativeNode.child = newNode;
            newNode.parent = relativeNode;
            ++this.count;
        } else {
            this.addSibling(newNode, relativeNode.child);
        }
        ++relativeNode.numberOfChildren;
    }

    void addSibling(TreeNode newNode, TreeNode siblingNode) {
        TreeNode tempNode = siblingNode;
        while (tempNode.sibling != null) {
            tempNode = tempNode.sibling;
        }
        tempNode.sibling = newNode;
        newNode.parent = tempNode.parent;
        ++this.count;
    }

    private void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    private void traverse(TreeNode node) {
        ++this.count;
        this.e.addElement(node);
        if (node.child != null) {
            node.child.depth = node.depth + 1;
            this.traverse(node.child);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.traverse(node.sibling);
        }
    }

    private void resetVector() {
        this.v = new Vector(this.count);
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode);
        this.viewCount = this.v.size();
    }

    private void vectorize(TreeNode node) {
        if (node == null) {
            return;
        }
        this.v.addElement(node);
        if (node.isExpanded()) {
            node.child.depth = node.depth + 1;
            this.vectorize(node.child);
        }
        if (node.sibling != null) {
            node.sibling.depth = node.depth;
            this.vectorize(node.sibling);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.sbV) {
            if (event.arg == null) {
                return false;
            }
            if (this.sbVPosition != (Integer)event.arg) {
                this.sbVPosition = (Integer)event.arg;
                this.redraw();
                return false;
            }
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int x, int y) {
        int index = y / this.cellSize + this.sbVPosition;
        if (index > this.viewCount - 1) {
            return false;
        }
        TreeNode oldNode = this.selectedNode;
        TreeNode newNode = (TreeNode)this.v.elementAt(index);
        int newDepth = newNode.getDepth();
        this.changeSelection(newNode);
        Rectangle toggleBox = new Rectangle(this.cellSize * newDepth + this.cellSize / 4, (index - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (toggleBox.inside(x, y)) {
            newNode.toggle(this);
            this.redraw();
        } else {
            long currentTime = event.when;
            if (newNode == oldNode && event.when - this.timeMouseDown < (long)this.doubleClickResolution) {
                this.sendActionEvent(event);
                this.redraw();
                return false;
            }
            this.timeMouseDown = event.when;
        }
        return true;
    }

    public boolean keyDown(Event event, int key) {
        if (this.selectedNode == null) {
            return false;
        }
        int index = this.v.indexOf(this.selectedNode);
        switch (key) {
            case 10: {
                this.sendActionEvent(event);
                break;
            }
            case 1003: {
                this.sbVPosition = this.sbVPosition + this.sbV.getPageIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getPageIncrement()) : this.sbV.getMaximum();
                this.redraw();
                break;
            }
            case 1002: {
                this.sbVPosition = this.sbVPosition - this.sbV.getPageIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getPageIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1006: {
                if (this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle(this);
                    this.redraw();
                    break;
                }
            }
            case 1004: {
                if (index <= 0) break;
                this.changeSelection((TreeNode)this.v.elementAt(--index));
                this.requestFocus();
                break;
            }
            case 1007: {
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle(this);
                    this.redraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 1005: {
                if (index >= this.viewCount - 1) break;
                this.changeSelection((TreeNode)this.v.elementAt(++index));
                this.requestFocus();
                break;
            }
        }
        return false;
    }

    private void sendActionEvent(Event event) {
        int id = event.id;
        Object arg = event.arg;
        event.id = 1001;
        event.arg = new String(this.selectedNode.getText());
        this.postEvent(event);
        event.id = id;
        event.arg = arg;
    }

    private void sendSelectedEvent() {
        Event e = new Event(this, 701, this.selectedNode);
        this.postEvent(e);
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    private void changeSelection(TreeNode node) {
        if (node == this.selectedNode) {
            return;
        }
        TreeNode oldNode = this.selectedNode;
        this.selectedNode = node;
        if (oldNode != null) {
            this.drawNodeText(oldNode, (this.v.indexOf(oldNode) - this.sbVPosition) * this.cellSize, true);
        }
        this.drawNodeText(node, (this.v.indexOf(node) - this.sbVPosition) * this.cellSize, true);
        this.sendSelectedEvent();
        int index = this.v.indexOf(this.selectedNode);
        if (index < this.sbVPosition) {
            --this.sbVPosition;
            this.sbV.setValue(this.sbVPosition);
            this.redraw();
            return;
        }
        if (index >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.sbV.setValue(this.sbVPosition);
            this.redraw();
            return;
        }
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight) {
            this.redraw();
        }
        g.drawImage(this.im1, 0, 0, this);
    }

    public void redraw() {
        this.resetVector();
        int vh = this.size().height;
        if (this.viewCount > vh / this.cellSize) {
            this.sbV.setValues(this.sbVPosition, vh / this.cellSize, 0, this.viewCount - 2);
            int increment = vh / 2 / this.cellSize;
            if (increment <= 0) {
                increment = 1;
            }
            this.sbV.setPageIncrement(increment);
            this.sbVWidth = 16;
            this.sbV.show();
            this.layout();
        } else {
            this.sbV.hide();
            this.sbVWidth = 0;
            this.sbVPosition = 0;
            this.layout();
        }
        this.drawTree();
        this.repaint();
    }

    public synchronized void drawTree() {
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight || this.g1 == null) {
            this.im1 = this.createImage(d.width, d.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = d.width;
            this.viewHeight = d.height;
        }
        Font f = new Font("Dialog", 0, 12);
        this.g1.setFont(f);
        ((Component)this).setFont(f);
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(Color.white);
        this.g1.fillRect(0, 0, this.viewWidth, this.viewHeight);
        int lastOne = this.sbVPosition + this.viewHeight / this.cellSize;
        if (lastOne > this.viewCount) {
            lastOne = this.viewCount;
        }
        int i = this.sbVPosition;
        while (i < lastOne) {
            Image nodeImage;
            TreeNode node = (TreeNode)this.v.elementAt(i);
            int x = this.cellSize * (node.depth + 1);
            int y = (i - this.sbVPosition) * this.cellSize;
            this.g1.setColor(Color.black);
            if (node.sibling != null) {
                int k = this.v.indexOf(node.sibling) - i;
                if (k > lastOne) {
                    k = lastOne;
                }
                this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x - this.cellSize / 2, y + this.cellSize / 2 + k * this.cellSize);
            }
            int m = 0;
            while (m < i) {
                TreeNode sib = (TreeNode)this.v.elementAt(m);
                if (sib.sibling == node && m < this.sbVPosition) {
                    this.drawDotLine(x - this.cellSize / 2, 0, x - this.cellSize / 2, y + this.cellSize / 2);
                }
                ++m;
            }
            if (node.isExpanded()) {
                this.drawDotLine(x + this.cellSize / 2, y + this.cellSize, x + this.cellSize / 2, y + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(Color.black);
            this.drawDotLine(x - this.cellSize / 2, y + this.cellSize / 2, x + this.cellSize / 2, y + this.cellSize / 2);
            if (node.isExpandable()) {
                this.g1.setColor(Color.white);
                this.g1.fillRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(Color.gray);
                this.g1.drawRect(this.cellSize * node.depth + this.cellSize / 4, y + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(Color.black);
                this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 4 + 2, y + this.cellSize / 2, this.cellSize * node.depth + this.cellSize / 4 + this.clickSize - 2, y + this.cellSize / 2);
                if (!node.isExpanded()) {
                    this.g1.drawLine(this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + 2, this.cellSize * node.depth + this.cellSize / 2, y + this.clickSize / 2 + this.clickSize - 2);
                }
            }
            if (node.text != null) {
                this.drawNodeText(node, y, node == this.selectedNode);
            }
            if ((nodeImage = node.getImage()) != null) {
                this.g1.drawImage(nodeImage, x + this.imageInset, y, this);
            }
            ++i;
        }
    }

    private void drawNodeText(TreeNode node, int yPosition, boolean eraseBackground) {
        Color bg;
        Color fg;
        int depth = node.depth;
        int textOffset = (depth + 1) * this.cellSize + this.cellSize + this.textInset;
        if (node == this.selectedNode) {
            fg = this.fgHighlightColor;
            bg = this.bgHighlightColor;
        } else {
            fg = Color.black;
            bg = Color.white;
        }
        if (eraseBackground) {
            this.g1.setColor(bg);
            this.g1.fillRect(textOffset - 1, yPosition + 1, this.fm.stringWidth(node.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(fg);
        this.g1.drawString(node.text, textOffset, yPosition + this.cellSize - this.textBaseLine);
    }

    private void drawDotLine(int x0, int y0, int x1, int y1) {
        this.g1.setColor(Color.gray);
        if (y0 == y1) {
            int i = x0;
            while (i < x1) {
                this.g1.drawLine(i, y0, i, y1);
                i += 2;
            }
        } else {
            int i = y0;
            while (i < y1) {
                this.g1.drawLine(x0, i, x1, i);
                i += 2;
            }
        }
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public void setLayout(LayoutManager lm) {
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (infoflags == 32) {
            this.drawTree();
            this.repaint();
            return false;
        }
        return true;
    }
}

