/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;

public class WrappingTextPanel
extends Panel {
    private String text;
    Scrollbar sbV;
    int sbVPosition;
    int sbVWidth = 16;
    private FontMetrics fm;
    protected Image im1;
    protected Graphics g1;
    private Font font;
    private int rowSize;
    private int textBaseLine;
    private int viewWidth;
    private int viewHeight;
    private boolean bDirty;
    private TextScanner scanner;

    public WrappingTextPanel() {
        super.setLayout(new BorderLayout());
        this.sbV = new Scrollbar(1);
        this.add("East", this.sbV);
        this.font = new Font("Dialog", 0, 12);
        this.fm = this.getToolkit().getFontMetrics(this.font);
        this.rowSize = this.fm.getHeight();
        this.textBaseLine = this.fm.getDescent() + this.fm.getLeading() / 2;
        this.viewWidth = 0;
        this.viewHeight = 0;
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.invalidate();
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.invalidate();
    }

    public void setText(String text) {
        this.scanner = new TextScanner(text, this.viewWidth - this.sbVWidth, this.fm);
        this.sbVPosition = 0;
        this.redraw();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.sbV) {
            if (event.arg == null) {
                return false;
            }
            if (this.sbVPosition != (Integer)event.arg) {
                this.sbVPosition = (Integer)event.arg;
                this.redraw();
            }
        }
        return super.handleEvent(event);
    }

    public boolean keyDown(Event event, int key) {
        switch (key) {
            case 1003: {
                this.sbVPosition = this.sbVPosition + this.sbV.getPageIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getPageIncrement()) : this.sbV.getMaximum();
                this.redraw();
                break;
            }
            case 1002: {
                this.sbVPosition = this.sbVPosition - this.sbV.getPageIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getPageIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1004: {
                this.sbVPosition = this.sbVPosition - this.sbV.getLineIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getLineIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1005: {
                this.sbVPosition = this.sbVPosition + this.sbV.getLineIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getLineIncrement()) : this.sbV.getMaximum();
                this.redraw();
                break;
            }
        }
        return false;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight) {
            this.redraw();
        }
        g.drawImage(this.im1, 0, 0, this);
    }

    public void redraw() {
        if (this.isShowing()) {
            this.drawText();
            this.repaint();
        } else {
            this.bDirty = true;
        }
    }

    public void repaint() {
        if (this.bDirty) {
            this.drawText();
        }
        this.bDirty = false;
        super.repaint();
    }

    public void drawText() {
        Dimension d = this.size();
        if (d.width != this.viewWidth || d.height != this.viewHeight || this.g1 == null) {
            this.im1 = this.createImage(d.width - this.sbVWidth, d.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = d.width;
            this.viewHeight = d.height;
            if (this.scanner != null) {
                this.scanner.setLineWidth(this.viewWidth - this.sbVWidth);
            }
        }
        if (this.scanner != null) {
            if (this.scanner.getNumberOfLines() > this.viewHeight / this.rowSize) {
                int nWindowRows = this.viewHeight / this.rowSize;
                int nLines = this.scanner.getNumberOfLines();
                int lastTopRow = nLines - nWindowRows + 2;
                if (lastTopRow > nLines - 1) {
                    lastTopRow = nLines - 1;
                }
                this.sbV.show();
                if (this.sbVPosition > lastTopRow) {
                    this.sbVPosition = lastTopRow;
                }
                this.sbV.setValues(this.sbVPosition, nWindowRows, 0, this.scanner.getNumberOfLines() - nWindowRows);
            } else {
                this.sbVPosition = 0;
                this.sbV.hide();
            }
        } else {
            this.sbVPosition = 0;
            this.sbV.hide();
        }
        this.g1.setFont(this.font);
        ((Component)this).setFont(this.font);
        this.g1.setColor(this.getBackground());
        this.g1.fillRect(0, 0, this.viewWidth - this.sbVWidth, this.viewHeight);
        if (this.scanner != null) {
            int lastOne = this.sbVPosition + this.viewHeight / this.rowSize;
            int rowCount = this.scanner.getNumberOfLines();
            if (lastOne > rowCount) {
                lastOne = rowCount;
            }
            this.g1.setColor(this.getForeground());
            int i = this.sbVPosition;
            while (i < lastOne) {
                String line = this.scanner.getLineAt(i);
                int x = 0;
                int y = (i - this.sbVPosition) * this.rowSize;
                this.g1.drawString(line, x, y + this.rowSize - this.textBaseLine);
                ++i;
            }
        }
    }

    public void setLayout(LayoutManager lm) {
    }
}

