/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.context;

import javax.portlet.PortletContext;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public abstract class PortletApplicationContextUtils {
    public static ApplicationContext getWebApplicationContext(PortletContext pc) {
        Assert.notNull((Object)pc, (String)"PortletContext must not be null");
        Object attr = pc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr == null) {
            return null;
        }
        if (attr instanceof RuntimeException) {
            throw (RuntimeException)attr;
        }
        if (attr instanceof Error) {
            throw (Error)attr;
        }
        if (!(attr instanceof ApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr);
        }
        return (ApplicationContext)attr;
    }

    public static ApplicationContext getRequiredWebApplicationContext(PortletContext pc) throws IllegalStateException {
        ApplicationContext wac = PortletApplicationContextUtils.getWebApplicationContext(pc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }
}

