/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.util.Assert;

public class MapSqlParameterSource
extends AbstractSqlParameterSource {
    private final Map values = new HashMap();

    public MapSqlParameterSource() {
    }

    public MapSqlParameterSource(String paramName, Object value) {
        this.addValue(paramName, value);
    }

    public MapSqlParameterSource(Map values) {
        this.addValues(values);
    }

    public MapSqlParameterSource addValue(String paramName, Object value) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        this.values.put(paramName, value);
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value, int sqlType) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        this.values.put(paramName, value);
        this.registerSqlType(paramName, sqlType);
        return this;
    }

    public MapSqlParameterSource addValues(Map values) {
        if (values != null) {
            this.values.putAll(values);
        }
        return this;
    }

    public Map getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public boolean hasValue(String paramName) {
        return this.values.containsKey(paramName);
    }

    public Object getValue(String paramName) {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("No value registered for key '" + paramName + "'");
        }
        return this.values.get(paramName);
    }
}

