/*
 * Decompiled with CFR 0.152.
 */
package net.sf.acegisecurity.providers.x509.populator;

import java.security.cert.X509Certificate;
import net.sf.acegisecurity.AuthenticationException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.AuthenticationDao;
import net.sf.acegisecurity.providers.x509.X509AuthoritiesPopulator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DaoX509AuthoritiesPopulator
implements X509AuthoritiesPopulator,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$net$sf$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator == null ? (class$net$sf$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator = DaoX509AuthoritiesPopulator.class$("net.sf.acegisecurity.providers.x509.populator.DaoX509AuthoritiesPopulator")) : class$net$sf$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator));
    private AuthenticationDao authenticationDao;
    private String subjectDNRegex = "CN=(.*?),";
    private Pattern subjectDNPattern;
    static /* synthetic */ Class class$net$sf$acegisecurity$providers$x509$populator$DaoX509AuthoritiesPopulator;

    public void setAuthenticationDao(AuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setSubjectDNRegex(String subjectDNRegex) {
        this.subjectDNRegex = subjectDNRegex;
    }

    public UserDetails getUserDetails(X509Certificate clientCert) throws AuthenticationException {
        Perl5Matcher matcher = new Perl5Matcher();
        String subjectDN = clientCert.getSubjectDN().getName();
        if (!matcher.contains(subjectDN, this.subjectDNPattern)) {
            throw new BadCredentialsException("No matching pattern was found in subjectDN: " + subjectDN);
        }
        MatchResult match = matcher.getMatch();
        if (match.groups() != 2) {
            throw new IllegalArgumentException("Regular expression must contain a single group ");
        }
        String userName = match.group(1);
        return this.authenticationDao.loadUserByUsername(userName);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationDao, (String)"An authenticationDao must be set");
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.subjectDNPattern = compiler.compile(this.subjectDNRegex, 32769);
        }
        catch (MalformedPatternException mpe) {
            throw new IllegalArgumentException("Malformed regular expression: " + this.subjectDNRegex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

