/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class TransactionAttributeSourceAdvisor
extends AbstractPointcutAdvisor {
    private TransactionAttributeSource transactionAttributeSource;
    private TransactionAttributeSourcePointcut pointcut;

    public TransactionAttributeSourceAdvisor() {
    }

    public TransactionAttributeSourceAdvisor(TransactionInterceptor interceptor) {
        this.setTransactionInterceptor(interceptor);
    }

    public void setTransactionInterceptor(TransactionInterceptor interceptor) {
        this.setAdvice((Advice)interceptor);
        if (interceptor.getTransactionAttributeSource() == null) {
            throw new AopConfigException("Cannot construct a TransactionAttributeSourceAdvisor using a TransactionInterceptor that has no TransactionAttributeSource configured");
        }
        this.transactionAttributeSource = interceptor.getTransactionAttributeSource();
        this.pointcut = new TransactionAttributeSourcePointcut(this.transactionAttributeSource);
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    private static class TransactionAttributeSourcePointcut
    extends StaticMethodMatcherPointcut
    implements Serializable {
        private final TransactionAttributeSource transactionAttributeSource;

        public TransactionAttributeSourcePointcut(TransactionAttributeSource transactionAttributeSource) {
            this.transactionAttributeSource = transactionAttributeSource;
        }

        public boolean matches(Method method, Class targetClass) {
            Assert.notNull((Object)this.transactionAttributeSource, (String)"transactionAttributeSource is required");
            return this.transactionAttributeSource.getTransactionAttribute(method, targetClass) != null;
        }
    }
}

