/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.CreateException;
import javax.ejb.EJBLocalObject;
import javax.naming.NamingException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;

public class LocalSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        EJBLocalObject ejb = null;
        try {
            ejb = this.getSessionBeanInstance();
            Method method = invocation.getMethod();
            if (method.getDeclaringClass().isInstance(ejb)) {
                Object object = method.invoke((Object)ejb, invocation.getArguments());
                return object;
            }
            Method ejbMethod = ejb.getClass().getMethod(method.getName(), method.getParameterTypes());
            Object object = ejbMethod.invoke((Object)ejb, invocation.getArguments());
            return object;
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method of local EJB [" + this.getJndiName() + "] threw exception"), targetEx);
            }
            if (targetEx instanceof CreateException) {
                throw new AspectException("Could not create local EJB [" + this.getJndiName() + "]", targetEx);
            }
            throw targetEx;
        }
        catch (NamingException ex) {
            throw new AspectException("Failed to locate local EJB [" + this.getJndiName() + "]", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new AspectException("Could not access method [" + invocation.getMethod().getName() + "] of local EJB [" + this.getJndiName() + "]", (Throwable)ex);
        }
        finally {
            this.releaseSessionBeanInstance(ejb);
        }
    }

    protected EJBLocalObject getSessionBeanInstance() throws NamingException, InvocationTargetException {
        return this.newSessionBeanInstance();
    }

    protected void releaseSessionBeanInstance(EJBLocalObject ejb) {
        this.removeSessionBeanInstance(ejb);
    }

    protected EJBLocalObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to local EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBLocalObject)) {
            throw new AspectException("EJB instance [" + ejbInstance + "] is not a local SLSB");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to local EJB: " + ejbInstance));
        }
        return (EJBLocalObject)ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBLocalObject ejb) {
        if (ejb != null) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not invoke 'remove' on local EJB proxy", ex);
            }
        }
    }
}

