/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DynamicDestinationResolver;
import org.springframework.jms.support.destination.JmsDestinationAccessor;

public abstract class AbstractMessageListenerContainer
extends JmsDestinationAccessor
implements DisposableBean,
Lifecycle {
    private Object destination;
    private String messageSelector;
    private Object messageListener;
    private ExceptionListener exceptionListener;
    private boolean exposeListenerSession = true;
    private boolean autoStartup = true;
    private Connection connection;
    private boolean running = false;
    private volatile boolean active = false;

    public AbstractMessageListenerContainer() {
        this.setDestinationResolver(new DynamicDestinationResolver());
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    protected Destination getDestination() {
        return this.destination instanceof Destination ? (Destination)this.destination : null;
    }

    public void setDestinationName(String destinationName) {
        this.destination = destinationName;
    }

    protected String getDestinationName() {
        return this.destination instanceof String ? (String)this.destination : null;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    protected String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof SessionAwareMessageListener)) {
            throw new IllegalArgumentException("messageListener needs to be of type [javax.jms.MessageListener] or [org.springframework.jmx.listener.SessionAwareMessageListener]");
        }
    }

    protected Object getMessageListener() {
        return this.messageListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    protected ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    protected boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.destination == null) {
            throw new IllegalArgumentException("destination or destinationName is required");
        }
        if (this.messageListener == null) {
            throw new IllegalArgumentException("messageListener is required");
        }
        this.initialize();
    }

    public void initialize() {
        try {
            this.active = true;
            this.connection = this.createConnection();
            this.registerListener();
            if (this.autoStartup) {
                this.connection.start();
                this.running = true;
            }
        }
        catch (JMSException ex) {
            JmsUtils.closeConnection(this.connection);
            this.active = false;
            throw this.convertJmsAccessException(ex);
        }
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    public void destroy() throws JmsException {
        try {
            this.active = false;
            this.destroyListener();
            this.logger.debug((Object)"Closing JMS Connection");
            this.connection.close();
        }
        catch (JMSException ex) {
            JmsUtils.closeConnection(this.connection);
            throw this.convertJmsAccessException(ex);
        }
    }

    public synchronized void start() throws JmsException {
        try {
            this.connection.start();
            this.running = true;
        }
        catch (IllegalStateException ex) {
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    public synchronized void stop() throws JmsException {
        try {
            this.connection.stop();
            this.running = false;
        }
        catch (IllegalStateException ex) {
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    public final synchronized boolean isRunning() {
        return this.running;
    }

    public final boolean isActive() {
        return this.active;
    }

    protected void executeListener(Session session, Message message) {
        try {
            this.doExecuteListener(session, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected void doExecuteListener(Session session, Message message) throws JMSException {
        try {
            this.invokeListener(session, message);
        }
        catch (JMSException ex) {
            ExceptionListener exceptionListener = this.getExceptionListener();
            if (exceptionListener != null) {
                exceptionListener.onException(ex);
            }
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnExceptionIfNecessary(session, err);
            throw err;
        }
        this.commitIfNecessary(session, message);
    }

    protected void invokeListener(Session session, Message message) throws JMSException {
        if (this.getMessageListener() instanceof SessionAwareMessageListener) {
            this.invokeListener((SessionAwareMessageListener)this.getMessageListener(), session, message);
        } else if (this.getMessageListener() instanceof MessageListener) {
            ((MessageListener)this.getMessageListener()).onMessage(message);
        } else {
            throw new IllegalArgumentException("Only MessageListener and SessionAwareMessageListener supported");
        }
    }

    protected void invokeListener(MessageListener listener, Message message) throws JMSException {
        listener.onMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeListener(SessionAwareMessageListener listener, Session session, Message message) throws JMSException {
        Session sessionToExpose = session;
        Connection con = null;
        try {
            if (!this.isExposeListenerSession()) {
                con = this.createConnection();
                sessionToExpose = this.createSession(con);
            }
            ((SessionAwareMessageListener)this.getMessageListener()).onMessage(message, sessionToExpose);
            if (sessionToExpose != session && sessionToExpose.getTransacted() && this.isSessionTransacted()) {
                JmsUtils.commitIfNecessary(sessionToExpose);
            }
        }
        finally {
            if (sessionToExpose != session) {
                JmsUtils.closeSession(sessionToExpose);
                JmsUtils.closeConnection(con);
            }
        }
    }

    protected void commitIfNecessary(Session session, Message message) throws JmsException {
        try {
            if (session.getTransacted()) {
                if (this.isSessionTransacted()) {
                    JmsUtils.commitIfNecessary(session);
                }
            } else if (this.isClientAcknowledge(session)) {
                message.acknowledge();
            }
        }
        catch (JMSException ex) {
            this.convertJmsAccessException(ex);
        }
    }

    protected void rollbackOnExceptionIfNecessary(Session session, Throwable ex) throws JmsException {
        try {
            if (session.getTransacted() && this.isSessionTransacted()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
                }
                JmsUtils.rollbackIfNecessary(session);
            }
        }
        catch (JMSException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw this.convertJmsAccessException(ex2);
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected void handleListenerException(Throwable ex) {
        this.logger.error((Object)"Execution of JMS message listener failed", ex);
    }

    protected abstract void registerListener() throws JMSException;

    protected abstract void destroyListener() throws JMSException;

    protected Connection createConnection() throws JMSException {
        return this.getConnectionFactory().createConnection();
    }

    protected Session createSession(Connection con) throws JMSException {
        return con.createSession(this.isSessionTransacted(), this.getSessionAcknowledgeMode());
    }

    protected boolean isClientAcknowledge(Session session) throws JMSException {
        return session.getAcknowledgeMode() == 2;
    }
}

